/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.pad;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;
import org.jgraph.graph.GraphModel;
import org.jgraph.pad.GPGraph;
import org.jgraph.pad.GraphModelFileFormat;
import org.jgraph.pad.resources.Translator;

public class DefaultGraphModelFileFormatSerial
implements GraphModelFileFormat {
    JComponent compZipSelect;
    FileFilter fileFilter = new FileFilter(){

        public boolean accept(File file) {
            if (file == null) {
                return false;
            }
            if (file.getName() == null) {
                return false;
            }
            if (file.getName().endsWith(".pad")) {
                return true;
            }
            return file.isDirectory();
        }

        public String getDescription() {
            return Translator.getString("FileDesc.JGraphpadDiagram");
        }
    };
    public static final String COMPRESS_WITH_ZIP = "CompressWithZip";

    public DefaultGraphModelFileFormatSerial() {
        this.compZipSelect = new JCheckBox(Translator.getString("zipCompress"));
    }

    public String getFileExtension() {
        return "pad";
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public JComponent getWriteAccessory() {
        return this.compZipSelect;
    }

    public JComponent getReadAccessory() {
        return null;
    }

    public void write(URL uRL, Hashtable hashtable, GPGraph gPGraph, GraphModel graphModel) throws Exception {
        OutputStream outputStream = new FileOutputStream(uRL.getFile());
        if (hashtable != null && hashtable.get(COMPRESS_WITH_ZIP) != null && ((Boolean)hashtable.get(COMPRESS_WITH_ZIP)).booleanValue()) {
            outputStream = new GZIPOutputStream(outputStream);
        }
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(gPGraph.getArchiveableState());
        objectOutputStream.flush();
        objectOutputStream.close();
    }

    public Hashtable getWriteProperties(JComponent jComponent) {
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
        if (!(jComponent instanceof JCheckBox)) {
            return hashtable;
        }
        hashtable.put(COMPRESS_WITH_ZIP, new Boolean(((JCheckBox)jComponent).isSelected()));
        return hashtable;
    }

    public GraphModel read(URL uRL, Hashtable hashtable, GPGraph gPGraph) throws Exception {
        Object object = null;
        try {
            InputStream inputStream = uRL.openStream();
            inputStream = new GZIPInputStream(inputStream);
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            object = objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            InputStream inputStream = uRL.openStream();
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            object = objectInputStream.readObject();
            objectInputStream.close();
        }
        gPGraph.setArchivedState(object);
        return gPGraph.getModel();
    }

    public Hashtable getReadProperties(JComponent jComponent) {
        return null;
    }
}

