/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.pad.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.undo.CannotUndoException;
import org.jgraph.GPGraphpad;
import org.jgraph.pad.GPBarFactory;
import org.jgraph.pad.actions.AbstractActionDefault;
import org.jgraph.pad.resources.Translator;

public class EditUndo
extends AbstractActionDefault {
    protected Vector menuItems = new Vector();

    public EditUndo(GPGraphpad gPGraphpad) {
        super(gPGraphpad);
        this.setEnabled(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            this.getCurrentDocument().getGraphUndoManager().undo(this.graphpad.getCurrentGraph().getGraphLayoutCache());
        }
        catch (CannotUndoException cannotUndoException) {
            System.out.println("Unable to graphUndoManager: " + cannotUndoException);
            cannotUndoException.printStackTrace();
        }
        this.graphpad.update();
    }

    public void update() {
        Enumeration enumeration = this.menuItems.elements();
        while (enumeration.hasMoreElements()) {
            JMenuItem jMenuItem = (JMenuItem)enumeration.nextElement();
            if (this.getCurrentDocument() != null && this.getCurrentDocument().getGraphUndoManager().canUndo(this.getCurrentGraphLayoutCache())) {
                this.setEnabled(true);
                jMenuItem.setText(this.getCurrentDocument().getGraphUndoManager().getUndoPresentationName());
                continue;
            }
            this.setEnabled(false);
            jMenuItem.setText(Translator.getString("Component.EditUndo.Text"));
        }
    }

    protected Component getMenuComponent(String string) {
        JMenuItem jMenuItem = new JMenuItem(this);
        GPBarFactory.fillMenuButton(jMenuItem, this.getName(), string);
        this.menuItems.add(jMenuItem);
        return jMenuItem;
    }
}

