/*
 * Decompiled with CFR 0.152.
 */
package br.arca.morcego.physics;

import br.arca.morcego.Config;
import br.arca.morcego.physics.Vector3D;
import br.arca.morcego.structure.Graph;
import br.arca.morcego.structure.Node;
import java.util.Enumeration;

public class Camera
extends Vector3D {
    public Camera(int x, int y, int z) {
        super(x, y, z);
    }

    public Camera() {
        super(0.0f, 0.0f, Config.getInteger("morcego.cameraDistance"));
    }

    public void adjustPosition(Graph graph) {
        if (Config.getBoolean(Config.adjustCameraPosition)) {
            Camera camera = this;
            synchronized (camera) {
                int distance = Config.getInteger("morcego.cameraDistance");
                this.z = distance;
                Enumeration en = graph.getNodes().elements();
                while (en.hasMoreElements()) {
                    Node node = (Node)en.nextElement();
                    if (!(node.getBody().z + (float)distance > this.z)) continue;
                    this.z = node.getBody().z + (float)distance;
                }
            }
        }
    }
}

