/*
 * Decompiled with CFR 0.152.
 */
package br.arca.morcego.structure;

import br.arca.morcego.Config;
import br.arca.morcego.Morcego;
import br.arca.morcego.component.DescriptionBox;
import br.arca.morcego.physics.PositionedObject;
import br.arca.morcego.physics.PunctualBody;
import br.arca.morcego.physics.Vector3D;
import br.arca.morcego.structure.Graph;
import br.arca.morcego.structure.GraphElement;
import br.arca.morcego.structure.Link;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;

public class Node
extends GraphElement
implements PositionedObject {
    protected String id;
    protected PunctualBody body;
    protected int nodeSize;
    protected Rectangle boundRectangle = new Rectangle();
    private Hashtable links = new Hashtable();
    private boolean isCentered;
    private DescriptionBox description;
    private float maxModule;

    public Node(String name) {
        this(name, new Graph());
    }

    public Node(String name, Graph graph) {
        this.graph = graph;
        this.id = name;
        this.graph.addNode(this);
        int x = this.randomLength();
        int y = this.randomLength();
        int z = this.randomLength();
        z = -1 * Math.abs(z);
        this.body = new PunctualBody(x, y, z);
    }

    public PunctualBody getBody() {
        return this.body;
    }

    public void setBody(PunctualBody body) {
        this.body = body;
    }

    public boolean isLinkedTo(Node node) {
        return this.links.containsKey(node.id);
    }

    public boolean centered() {
        return this.isCentered;
    }

    public void center() {
        this.isCentered = true;
        this.body.fixPosition(0, 0, 0);
    }

    public void unCenter() {
        this.isCentered = false;
        this.releasePosition();
    }

    public int linkCount() {
        int i = 0;
        Enumeration e = this.links.keys();
        while (e.hasMoreElements()) {
            e.nextElement();
            ++i;
        }
        return i;
    }

    public void move() {
        this.body.move();
        this.proj();
    }

    public void releasePosition() {
        this.body.releasePosition();
    }

    public void fixPosition() {
        this.body.fixPosition();
    }

    public synchronized void proj() {
        this.nodeSize = (int)Math.round((double)Config.getInteger("morcego.nodeSize") * (double)this.body.getScale());
        if (this.nodeSize < Config.getInteger("morcego.minNodeSize")) {
            this.nodeSize = Config.getInteger("morcego.minNodeSize");
        }
        int c = this.nodeSize / 2;
        int cornerU = this.body.projection.x - c;
        int cornerV = this.body.projection.y - c;
        this.boundRectangle = new Rectangle(cornerU, cornerV, this.nodeSize, this.nodeSize);
    }

    public boolean contains(MouseEvent e) {
        return this.boundRectangle.contains(e.getX(), e.getY());
    }

    public int randomLength() {
        return (int)((Math.random() * 2.0 - 1.0) * 500.0);
    }

    public void addLink(String nodeName) {
        this.links.put(nodeName, new Object());
    }

    public void paint(Graphics g) {
        this.proj();
    }

    public String getId() {
        return this.id;
    }

    public Enumeration getLinkList() {
        return this.links.keys();
    }

    public float getDepth() {
        return Morcego.getCamera().getDistanceTo(this.body);
    }

    public void setDescription(String nodeDescription) {
        this.description = new DescriptionBox(nodeDescription);
    }

    public void init() {
        if (this.getProperty("description") != null) {
            this.setDescription((String)this.getProperty("description"));
        }
    }

    public void mouseClicked(MouseEvent e) {
        URL url;
        boolean navigate;
        boolean bl = navigate = this.centered() || Config.getBoolean(Config.loadPageOnCenter);
        if (!this.centered()) {
            this.graph.navigateTo(this);
            if (this.description != null) {
                Morcego.getApplication().remove(this.description);
            }
        }
        if (navigate && (url = (URL)this.graph.getFocus().getProperty("actionUrl")) != null) {
            Morcego.showDocument(url, Config.getString("morcego.controlWindowName"));
        }
    }

    public void mouseEntered(MouseEvent e) {
        Morcego.setHandCursor();
        if (this.description != null) {
            this.description.setPosition(this.body.projection.x, this.body.projection.y);
            Morcego application = Morcego.getApplication();
            application.add(this.description);
            this.description.setVisible(true);
            e.consume();
            Morcego.notifyRenderer();
        }
    }

    public void mouseExited(MouseEvent e) {
        Morcego.setDefaultCursor();
        if (this.description != null) {
            Morcego.getApplication().remove(this.description);
            Morcego.notifyRenderer();
        }
    }

    public void mousePressed(MouseEvent e) {
        Enumeration el = this.graph.getNodes().elements();
        float reachableRadius = 0.0f;
        while (el.hasMoreElements()) {
            Node node = (Node)el.nextElement();
            float radius = node.getBody().module();
            if (!(radius > reachableRadius)) continue;
            reachableRadius = radius;
        }
        this.maxModule = 5.0f * reachableRadius;
        this.fixPosition();
        this.graph.fixFocus();
        if (this.description != null) {
            Morcego.getApplication().remove(this.description);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (!this.centered()) {
            this.releasePosition();
        }
        this.mouseExited(e);
        this.graph.releaseFocus();
    }

    public void mouseDragged(MouseEvent e) {
        if (!this.centered()) {
            Vector3D position = this.body.unproj(e.getX(), e.getY());
            if (position.module() > this.maxModule) {
                position.resize(this.maxModule / position.module());
            }
            this.body.moveTo(position);
            this.graph.notifyBalancer();
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void rotate(float xTheta, float yTheta) {
        this.body.rotate(xTheta, yTheta);
    }

    public void setProperty(String name, Object value) {
        if (name.equals("bodyCharge")) {
            this.body.setCharge(((Float)value).floatValue());
        }
        if (name.equals("bodyMass")) {
            this.body.setMass(((Float)value).floatValue());
        }
        super.setProperty(name, value);
    }

    public Link getLinkTo(Node node) {
        if (this.isLinkedTo(node)) {
            return (Link)this.links.get(node.id);
        }
        return null;
    }

    public boolean visible() {
        float scale = this.getBody().getScale();
        return true;
    }
}

