<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1246 $
 * $Id: WindowViewHelp.php 1246 2007-09-14 23:47:42Z ipso $
 * $Date: 2007-09-14 16:47:42 -0700 (Fri, 14 Sep 2007) $
 */
require_once('../../includes/global.inc.php');
require_once(Environment::getBasePath() .'includes/Interface.inc.php');

if ( !$permission->Check('help','enabled')
		OR !( $permission->Check('help','view') OR $permission->Check('help','view_own') ) ) {

	$permission->Redirect( FALSE ); //Redirect

}

/*
$title = 'Edit Help';
$smarty->assign('title', $title);
*/

/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'script',
												'group',
												'title'
												) ) );

$hf = new HelpFactory();

switch ($action) {
	case 'submit':
		Debug::Text('Submit!', __FILE__, __LINE__, __METHOD__,10);
	default:
		//Trim path off script name
		$split_script = explode('/', $script);
		$script = $split_script[count($split_script)-1];

		$hlf = new HelpListFactory();

		//$hlf->getByScriptNameAndGroupName($script, NULL);
		$hlf->getByScriptNameAndStatus($script,'ACTIVE');
		//$hlf->getById($id);

		$i=0;
		foreach ($hlf as $help_obj) {
			//Debug::Arr($station,'Department', __FILE__, __LINE__, __METHOD__,10);

			if ( $i > 0 AND $prev_type != $help_obj->getType() ) {
				$type_change = TRUE;
			} else {
				$type_change = FALSE;
			}

			$help_entries[] = array(
							'id' => $help_obj->GetId(),
							'type_id' => $help_obj->getType(),
							'type' => Option::getByKey($help_obj->getType(), $help_obj->getOptions('type') ),
							'type_change' => $type_change,
							'status_id' => $help_obj->getStatus(),
							'status' => Option::getByKey($help_obj->getStatus(), $help_obj->getOptions('status') ),
							'heading' => $help_obj->getHeading(),
							'body' => $help_obj->getBody(),
							'keywords' => $help_obj->getKeywords(),
							'private' => $help_obj->getPrivate(),
							'created_date' => $help_obj->getCreatedDate(),
							'created_by' => $help_obj->getCreatedBy(),
							'updated_date' => $help_obj->getUpdatedDate(),
							'updated_by' => $help_obj->getUpdatedBy(),
							'deleted_date' => $help_obj->getDeletedDate(),
							'deleted_by' => $help_obj->getDeletedBy(),
							'deleted' => $help_obj->getDeleted()
							);

			$prev_type = $help_obj->getType();

			$i++;
		}

		$smarty->assign_by_ref('help_entries', $help_entries);
		$smarty->assign_by_ref('title', $title);

		$smarty->assign_by_ref('SCRIPT_BASE_NAME', $script);

		break;
}

$smarty->assign_by_ref('hf', $hf);

$smarty->display('help/WindowViewHelp.tpl');
?>