/* valamethod.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#ifndef __VALA_VALAMETHOD_H__
#define __VALA_VALAMETHOD_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gee/list.h>
#include <vala/valamember.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_METHOD (vala_method_get_type ())
#define VALA_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD, ValaMethod))
#define VALA_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD, ValaMethodClass))
#define VALA_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD))
#define VALA_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD))
#define VALA_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD, ValaMethodClass))

typedef struct _ValaMethodPrivate ValaMethodPrivate;

/**
 * Represents a type or namespace method.
 */
struct _ValaMethod {
	ValaMember parent_instance;
	ValaMethodPrivate * priv;
};

struct _ValaMethodClass {
	ValaMemberClass parent_class;
	char* (*get_default_cname) (ValaMethod* self);
	char* (*get_real_cname) (ValaMethod* self);
};


#define VALA_METHOD_DEFAULT_SENTINEL "NULL"
ValaMethod* vala_method_construct (GType object_type, const char* name, ValaDataType* return_type, ValaSourceReference* source_reference);
ValaMethod* vala_method_new (const char* name, ValaDataType* return_type, ValaSourceReference* source_reference);
void vala_method_add_parameter (ValaMethod* self, ValaFormalParameter* param);
GeeList* vala_method_get_parameters (ValaMethod* self);
void vala_method_clear_parameters (ValaMethod* self);
char* vala_method_get_cname (ValaMethod* self);
char* vala_method_get_default_cname (ValaMethod* self);
char* vala_method_get_real_cname (ValaMethod* self);
void vala_method_set_cname (ValaMethod* self, const char* cname);
void vala_method_process_attributes (ValaMethod* self);
gboolean vala_method_compatible (ValaMethod* self, ValaMethod* base_method, char** invalid_match);
void vala_method_add_precondition (ValaMethod* self, ValaExpression* precondition);
GeeList* vala_method_get_preconditions (ValaMethod* self);
void vala_method_add_postcondition (ValaMethod* self, ValaExpression* postcondition);
GeeList* vala_method_get_postconditions (ValaMethod* self);
ValaDataType* vala_method_get_return_type (ValaMethod* self);
void vala_method_set_return_type (ValaMethod* self, ValaDataType* value);
ValaBlock* vala_method_get_body (ValaMethod* self);
void vala_method_set_body (ValaMethod* self, ValaBlock* value);
ValaBasicBlock* vala_method_get_entry_block (ValaMethod* self);
void vala_method_set_entry_block (ValaMethod* self, ValaBasicBlock* value);
ValaBasicBlock* vala_method_get_exit_block (ValaMethod* self);
void vala_method_set_exit_block (ValaMethod* self, ValaBasicBlock* value);
MemberBinding vala_method_get_binding (ValaMethod* self);
void vala_method_set_binding (ValaMethod* self, MemberBinding value);
const char* vala_method_get_vfunc_name (ValaMethod* self);
void vala_method_set_vfunc_name (ValaMethod* self, const char* value);
const char* vala_method_get_sentinel (ValaMethod* self);
void vala_method_set_sentinel (ValaMethod* self, const char* value);
gboolean vala_method_get_is_abstract (ValaMethod* self);
void vala_method_set_is_abstract (ValaMethod* self, gboolean value);
gboolean vala_method_get_is_virtual (ValaMethod* self);
void vala_method_set_is_virtual (ValaMethod* self, gboolean value);
gboolean vala_method_get_overrides (ValaMethod* self);
void vala_method_set_overrides (ValaMethod* self, gboolean value);
gboolean vala_method_get_is_inline (ValaMethod* self);
void vala_method_set_is_inline (ValaMethod* self, gboolean value);
gboolean vala_method_get_returns_modified_pointer (ValaMethod* self);
void vala_method_set_returns_modified_pointer (ValaMethod* self, gboolean value);
ValaMethod* vala_method_get_base_method (ValaMethod* self);
ValaMethod* vala_method_get_base_interface_method (ValaMethod* self);
gboolean vala_method_get_entry_point (ValaMethod* self);
ValaFormalParameter* vala_method_get_this_parameter (ValaMethod* self);
void vala_method_set_this_parameter (ValaMethod* self, ValaFormalParameter* value);
ValaLocalVariable* vala_method_get_result_var (ValaMethod* self);
void vala_method_set_result_var (ValaMethod* self, ValaLocalVariable* value);
double vala_method_get_cinstance_parameter_position (ValaMethod* self);
void vala_method_set_cinstance_parameter_position (ValaMethod* self, double value);
double vala_method_get_carray_length_parameter_position (ValaMethod* self);
void vala_method_set_carray_length_parameter_position (ValaMethod* self, double value);
double vala_method_get_cdelegate_target_parameter_position (ValaMethod* self);
void vala_method_set_cdelegate_target_parameter_position (ValaMethod* self, double value);
gboolean vala_method_get_no_array_length (ValaMethod* self);
void vala_method_set_no_array_length (ValaMethod* self, gboolean value);
gboolean vala_method_get_array_null_terminated (ValaMethod* self);
void vala_method_set_array_null_terminated (ValaMethod* self, gboolean value);
gboolean vala_method_get_printf_format (ValaMethod* self);
void vala_method_set_printf_format (ValaMethod* self, gboolean value);
gboolean vala_method_get_has_construct_function (ValaMethod* self);
void vala_method_set_has_construct_function (ValaMethod* self, gboolean value);
gboolean vala_method_get_coroutine (ValaMethod* self);
void vala_method_set_coroutine (ValaMethod* self, gboolean value);
GType vala_method_get_type (void);


G_END_DECLS

#endif
