#!/usr/bin/perl

use strict;

use Math::Trig;

if (@ARGV)
{
    open(INFILE, "<$ARGV[0]") || die("Can't open $ARGV[0]\n");

    my $flattening = 0.09796;
    my $omf2 = ((1 - $flattening) * (1 - $flattening));
    my @months = ( 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 );
    for (my $i = 0; $i < 4; $i++)
    {
        <INFILE>;
    }
    while (<INFILE>)
    {
        my @fields = split(" ", $_);
        my $year      = $fields[0];
        my $day       = $fields[1];
        my $hour      = $fields[2];
        my $min       = $fields[3];
        my $sec       = $fields[4];
        my $lon       = $fields[5];
        my $lat       = $fields[6];
        my $localtime = $fields[7];
        my $rad       = $fields[8];

        if ($year eq "2000" || $year eq "2004" || $year eq "2008")
        {
            $months[1] = 29;
        }
        else
        {
            $months[1] = 28;
        }

        my $month = 0;
        while ($day > $months[$month])
        {
            $day -= $months[$month++];
        }
        $month++;

        # convert planetocentric latitude to planetographic
        $lat = deg2rad($lat);
        $lat = atan(tan($lat) / $omf2);
        $lat = rad2deg($lat);

        printf("%4.4d%2.2d%2.2d.%2.2d%2.2d%2.2d %10.3f %8.3f %8.3f %8.3f\n",
               $year, $month, $day, $hour, $min, $sec, $rad, $lat, $lon, $localtime);
    }
}
else
{
    print "Use this perl script with tables produced from http://www-pw.physics.uiowa.edu/~jbg/cas.html\n";
}
