/*
 * farsight-plugin.h - Header for farsight plugin infrastructure
 *
 * Farsight Voice+Video library
 * Copyright (c) 2005 INdT.
 *   @author: Andre Moreira Magalhaes <andre.magalhaes@indt.org.br>
 * Copyright (c) 2005,2006 Collabora Ltd.
 * Copyright (c) 2005,2006 Nokia Corp.
 *   @author: Rob Taylor <rob.taylor@collabora.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __FARSIGHT_PLUGIN_H__
#define __FARSIGHT_PLUGIN_H__

#include <glib.h>
#include <glib-object.h>
#include <gmodule.h>
#include <gst/gst.h>

G_BEGIN_DECLS


/* TYPE MACROS */
#define FARSIGHT_TYPE_PLUGIN \
  (farsight_plugin_get_type())
#define FARSIGHT_PLUGIN(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), FARSIGHT_TYPE_PLUGIN, FarsightPlugin))
#define FARSIGHT_PLUGIN_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), FARSIGHT_TYPE_PLUGIN, FarsightPluginClass))
#define FARSIGHT_IS_PLUGIN(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), FARSIGHT_TYPE_PLUGIN))
#define FARSIGHT_IS_PLUGIN_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), FARSIGHT_TYPE_PLUGIN))
#define FARSIGHT_PLUGIN_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), FARSIGHT_TYPE_PLUGIN, FarsightPluginClass))

typedef struct _FarsightPlugin FarsightPlugin;
typedef struct _FarsightPluginClass FarsightPluginClass;
typedef struct _FarsightPluginPrivate FarsightPluginPrivate;
typedef struct _FarsightPluginInfo FarsightPluginInfo;

struct _FarsightPlugin
{
  GTypeModule parent;

  gchar *name;			/* name of the plugin */

  FarsightPluginInfo *info;

  FarsightPluginPrivate *priv;
};

struct _FarsightPluginClass
{
  GTypeModuleClass parent_class;

};

struct _FarsightPluginInfo
{
  guint major_version;          /* major version of core that plugin was compiled for */
  guint minor_version;          /* minor version of core that plugin was compiled for */
 
  gchar *description;           /* description of plugin */
  gchar *version;               /* version of the plugin */
  gchar *author;                /* author of the plugin */
  gchar *homepage;              /* homepage of the plugin */

  /* callbacks */
  /* This function is called when the last instance of the plugin is
   * unloaded. It can be useful to deallocate resources common for all
   * instances of the plugin. */
  void (*unload) (FarsightPlugin * plugin);
  /* This function is called to generate a new object of the type used by the 
     plugin */
  GObject* (*new_) (void);
};



GType farsight_plugin_get_type (void);

GObject *farsight_plugin_create (const gchar * name, const gchar *type_suffix,
                                 FarsightPlugin **pluginptr);

G_CONST_RETURN gchar *farsight_plugin_get_name (FarsightPlugin * plugin);
G_CONST_RETURN gchar *farsight_plugin_get_description (FarsightPlugin *
    plugin);
G_CONST_RETURN gchar *farsight_plugin_get_version (FarsightPlugin * plugin);
G_CONST_RETURN gchar *farsight_plugin_get_author (FarsightPlugin * plugin);
G_CONST_RETURN gchar *farsight_plugin_get_homepage (FarsightPlugin * plugin);


#define FARSIGHT_INIT_PLUGIN(initfunc, plugininfo) \
    G_MODULE_EXPORT gboolean farsight_init_plugin(FarsightPlugin *plugin) { \
        plugin->info = &(plugininfo); \
        return initfunc((plugin)); \
    }



G_END_DECLS
#endif

