       I     d   a        0     1             	  |  /           '    $    8      )      H   X    !  ;  %W  }  ,  ~  .  y  /  
  1
    2  z  3     5w  a  5    7_    9z  
  </  4  >:     ?o    @    A     B    C    E
  
  F     I     JY     K)     K     L     Mo     N.     N     O  9  Pt  A  R     T     U     VH     W    W  K  Y     Z]     [:    [    ]     _    `7     a    b    d7     e  &  f    g     h    ik     jz  x  ki  g  m    pJ  J  r     sR     t%    t.    u    v     x    y    {U    |      _    Q  H        w    )  X  2  u                  6  ;      5           [  K  9        5    b       @                              {     9                    l     ,            m  Ď         ɒ     K              Y  e       Z     ?        Ұ     Ԇ    7     (             ۩  -  ܘ             ߋ  -              |  _  C          q         H                                     B      "          8       )   	         '   6   0                     >   
      ;               *   C   /      ,   2   &          1   .   E   =           I         -      G       9   :      (   3   #   ?   D   @   A   7                        
   $      4   %   !           <              5       F   +           @FUNCTION=ASC
@SYNTAX=ASC(string)
@DESCRIPTION=ASC a compatibility function that is meaningless in Gnumeric.  In MS Excel (tm) it converts 2 byte @string into single byte text.

@EXAMPLES=
CHAR("Foo") equals "Foo".

@SEEALSO= @FUNCTION=BASE
@SYNTAX=BASE(number,base[,length])
@DESCRIPTION=BASE function converts a number to a string representing that number in base @base.

* @base must be an integer between 2 and 36.
* This function is OpenOffice.Org compatible.
* Optional argument @length specifies the minimum result length.  Leading  zeroes will be added to reach this length.

@EXAMPLES=
BASE(255,16,4) equals "00FF".

@SEEALSO=DECIMAL @FUNCTION=BIN2DEC
@SYNTAX=BIN2DEC(x)
@DESCRIPTION=BIN2DEC function converts a binary number in string or number to its decimal equivalent.

* This function is Excel compatible.

@EXAMPLES=
BIN2DEC(101) equals 5.

@SEEALSO=DEC2BIN, BIN2OCT, BIN2HEX @FUNCTION=BIN2HEX
@SYNTAX=BIN2HEX(number[,places])
@DESCRIPTION=BIN2HEX function converts a binary number to a hexadecimal number.  @places is an optional field, specifying to zero pad to that number of spaces.

* If @places is too small or negative #NUM! error is returned.
* This function is Excel compatible.

@EXAMPLES=
BIN2HEX(100111) equals 27.

@SEEALSO=HEX2BIN, BIN2OCT, BIN2DEC @FUNCTION=BIN2OCT
@SYNTAX=BIN2OCT(number[,places])
@DESCRIPTION=BIN2OCT function converts a binary number to an octal number. @places is an optional field, specifying to zero pad to that number of spaces.

* If @places is too small or negative #NUM! error is returned.
* This function is Excel compatible.

@EXAMPLES=
BIN2OCT(110111) equals 67.

@SEEALSO=OCT2BIN, BIN2DEC, BIN2HEX @FUNCTION=CELL
@SYNTAX=CELL(type,ref)
@DESCRIPTION=CELL returns information about the formatting, location, or contents of a cell.

@type specifies the type of information you want to obtain:

  address    	Returns the given cell reference as text.
  col        		Returns the number of the column in @ref.
  contents   	Returns the contents of the cell in @ref.
  format     		Returns the code of the format of the cell.
  parentheses	Returns 1 if @ref contains a negative value
             		and its format displays it with parentheses.
  row        		Returns the number of the row in @ref.
  width      		Returns the column width.

* This function is Excel compatible.

@EXAMPLES=
Cell("format",A1) returns the code of the format of the cell A1.

@SEEALSO=INDIRECT @FUNCTION=COUNTBLANK
@SYNTAX=COUNTBLANK(range)
@DESCRIPTION=COUNTBLANK returns the number of blank cells in a @range.

* This function is Excel compatible.

@EXAMPLES=
COUNTBLANK(A1:A20) returns the number of blank cell in A1:A20.

@SEEALSO=COUNT @FUNCTION=DATE
@SYNTAX=DATE (year,month,day)
@DESCRIPTION=DATE returns the number of days since the 1st of January of 1900(the date serial number) for the given year, month and day.

* If @month < 1 or @month > 12, the year will be corrected.  A similar correction takes place for days.
* The @years should be at least 1900.  If @years < 1900, it is assumed to be 1900 + @years.
* If the given date is not valid, DATE returns #NUM! error.
* This function is Excel compatible.

@EXAMPLES=
DATE(2001, 3, 30) returns 'Mar 30, 2001'.
 
@SEEALSO=TODAY, NOW @FUNCTION=DATE2UNIX
@SYNTAX=DATE2UNIX(serial)
@DESCRIPTION=DATE2UNIX converts a spreadsheet date and time serial number into a unix time.

A unix time is the number of seconds since midnight January 1, 1970.

@EXAMPLES=
DATE2UNIX("01/01/2000") equals 946656000.

@SEEALSO=NOW, DATE, UNIX2DATE @FUNCTION=DATEDIF
@SYNTAX=DATEDIF(date1,date2,interval)
@DESCRIPTION=DATEDIF returns the difference between two dates.  @interval is one of six possible values:  "y", "m", "d", "ym", "md", and "yd".

The first three options will return the number of complete years, months, or days, respectively, between the two dates specified.

  "ym" will return the number of full months between the two dates, not including the difference in years.
  "md" will return the number of full days between the two dates, not including the difference in months.
  "yd" will return the number of full days between the two dates, not including the difference in years.

* This function is Excel compatible.

@EXAMPLES=
DATEDIF(DATE(2000,4,30),DATE(2003,8,4),"d") equals 1191.
DATEDIF(DATE(2000,4,30),DATE(2003,8,4),"y") equals 3.

@SEEALSO=DATE @FUNCTION=DATEVALUE
@SYNTAX=DATEVALUE(date_str)
@DESCRIPTION=DATEVALUE returns the serial number of the date.  @date_str is the string that contains the date. The value depends on the date convention.  The MS Excel 1900 convention dates things from Jan 1 1900 while the 1904 convention uses Jan 1 1904.

* This function is Excel compatible.

@EXAMPLES=
DATEVALUE("1/1/1999") equals 36161 (in the 1900 convention).
@SEEALSO=DATE @FUNCTION=DAVERAGE
@SYNTAX=DAVERAGE(database,field,criteria)
@DESCRIPTION=DAVERAGE function returns the average of the values in a list or database that match conditions specified.

@database is a range of cells in which rows of related information are records and columns of data are fields. The first row of a database contains labels for each column. 

@field specifies which column is used in the function.  If @field is an integer, for example 2, the second column is used. Field can also be the label of a column.  For example, ``Age'' refers to the column with the label ``Age'' in @database range. 

@criteria is the range of cells which contains the specified conditions.  The first row of a @criteria should contain the labels of the fields for which the criteria are for.  Cells below the labels specify conditions, for example, ``>3'' or ``<9''.  Equality condition can be given simply by specifying a value, e.g. ``3'' or ``John''. 
Each row in @criteria specifies a separate condition. If a row in @database matches a row in @criteria, then that row is counted. Technically speaking, this a boolean OR operation between the rows in @criteria.
If @criteria specifies more than one column, then each of the conditions in the specified columns must be true for the row in @database to match. Technically speaking, this is a boolean AND operation between the columns in @criteria.

@EXAMPLES=
Let us assume that the range A1:C7 contain the following values:
Name    Age     Salary
John    34      54342
Bill    35      22343
Clark   29      34323
Bob     43      47242
Susan   37      42932
Jill    45      45324

In addition, the cells A9:B11 contain the following values:
Age     Salary
<30
>40     >46000

DAVERAGE(A1:C7, "Salary", A9:A11) equals 42296.3333.
DAVERAGE(A1:C7, "Age", A9:A11) equals 39.
DAVERAGE(A1:C7, "Salary", A9:B11) equals 40782.5.
DAVERAGE(A1:C7, "Age", A9:B11) equals 36.

@SEEALSO=DCOUNT @FUNCTION=DAY
@SYNTAX=DAY (date)
@DESCRIPTION=DAY converts a serial number to a day of month.

* Note that Gnumeric will perform regular string to serial number conversion for you, so you can enter a date as a string.
* This function is Excel compatible.

@EXAMPLES=
DAY("10/24/1968") equals 24.

@SEEALSO=MONTH, TIME, NOW, YEAR @FUNCTION=DAYS360 
@SYNTAX=DAYS360 (date1,date2,method)
@DESCRIPTION=DAYS360 returns the number of days from @date1 to @date2 following a 360-day calendar in which all months are assumed to have 30 days.

* If @method is 1, the European method will be used.  In this case, if the day of the month is 31 it will be considered as 30.
* If @method is 0 or omitted, the MS Excel (tm) US method will be used.  This is a somewhat complicated industry standard method where the last day of February is considered to be the 30th day of the month, but only for the first date.
* If @method is 2, a saner version of the US method is used in which both dates get the same February treatment.
* Note that Gnumeric will perform regular string to serial number conversion for you, so you can enter a date as a string.
* This function is mostly Excel compatible.

@EXAMPLES=
DAYS360(DATE(2003, 2, 3), DATE(2007, 4, 2)) equals 1499.

@SEEALSO=MONTH, TIME, NOW, YEAR @FUNCTION=DCOUNT
@SYNTAX=DCOUNT(database,field,criteria)
@DESCRIPTION=DCOUNT function counts the cells that contain numbers in a database that match conditions specified.

@database is a range of cells in which rows of related information are records and columns of data are fields. The first row of a database contains labels for each column. 

@field specifies which column is used in the function.  If @field is an integer, for example 2, the second column is used. Field can also be the label of a column.  For example, ``Age'' refers to the column with the label ``Age'' in @database range. 

@criteria is the range of cells which contains the specified conditions.  The first row of a @criteria should contain the labels of the fields for which the criteria are for.  Cells below the labels specify conditions, for example, ``>3'' or ``<9''.  Equality condition can be given simply by specifying a value, e.g. ``3'' or ``John''. 
Each row in @criteria specifies a separate condition. If a row in @database matches a row in @criteria, then that row is counted. Technically speaking, this a boolean OR operation between the rows in @criteria.
If @criteria specifies more than one column, then each of the conditions in the specified columns must be true for the row in @database to match. Technically speaking, this is a boolean AND operation between the columns in @criteria.

@EXAMPLES=
Let us assume that the range A1:C7 contain the following values:
Name    Age     Salary
John    34      54342
Bill    35      22343
Clark   29      34323
Bob     43      47242
Susan   37      42932
Jill    45      45324

In addition, the cells A9:B11 contain the following values:
Age     Salary
<30
>40     >46000

DCOUNT(A1:C7, "Salary", A9:A11) equals 3.
DCOUNT(A1:C7, "Salary", A9:B11) equals 2.
DCOUNT(A1:C7, "Name", A9:B11) equals 0.

@SEEALSO=DAVERAGE @FUNCTION=DEC2BIN
@SYNTAX=DEC2BIN(number[,places])
@DESCRIPTION=DEC2BIN function converts a decimal number to a binary number. @places is an optional field, specifying to zero pad to that number of spaces.

* If @places is too small or negative #NUM! error is returned.
* This function is Excel compatible.

@EXAMPLES=
DEC2BIN(42) equals 101010.

@SEEALSO=BIN2DEC, DEC2OCT, DEC2HEX @FUNCTION=DEC2HEX
@SYNTAX=DEC2HEX(number[,places])
@DESCRIPTION=DEC2HEX function converts a decimal number to a hexadecimal number. @places is an optional field, specifying to zero pad to that number of spaces.

* If @places is too small or negative #NUM! error is returned.
* This function is Excel compatible.

@EXAMPLES=
DEC2HEX(42) equals 2A.

@SEEALSO=HEX2DEC, DEC2BIN, DEC2OCT @FUNCTION=DEC2OCT
@SYNTAX=DEC2OCT(number[,places])
@DESCRIPTION=DEC2OCT function converts a decimal number to an octal number. @places is an optional field, specifying to zero pad to that number of spaces.

* If @places is too small or negative #NUM! error is returned.
* This function is Excel compatible.

@EXAMPLES=
DEC2OCT(42) equals 52.

@SEEALSO=OCT2DEC, DEC2BIN, DEC2HEX @FUNCTION=DECIMAL
@SYNTAX=DECIMAL(text,base)
@DESCRIPTION=DECIMAL function converts a number in base @base to decimal.

* @base must be an integer between 2 and 36.
* This function is OpenOffice.Org compatible.

@EXAMPLES=
DECIMAL("A1",16) equals 161.

@SEEALSO=BASE @FUNCTION=EDATE
@SYNTAX=EDATE(date,months)
@DESCRIPTION=EDATE returns the serial number of the date that is the specified number of months before or after a given date.  @date is the serial number of the initial date and @months is the number of months before (negative number) or after (positive number) the initial date.

* If @months is not an integer, it is truncated.
* This function is Excel compatible.

@EXAMPLES=
EDATE(DATE(2001,12,30),2) returns 'Feb 28, 2002'.

@SEEALSO=DATE @FUNCTION=EOMONTH
@SYNTAX=EOMONTH (start_date,months)
@DESCRIPTION=EOMONTH returns the last day of the month which is @months from the @start_date.

* EOMONTH returns #NUM! if @start_date or @months are invalid.
* This function is Excel compatible.

@EXAMPLES=
If A1 contains 12/21/00 then EOMONTH(A1,0)=12/31/00, EOMONTH(A1,5)=5/31/01, and EOMONTH(A1,2)=2/28/01

@SEEALSO=MONTH @FUNCTION=ERROR
@SYNTAX=ERROR(text)
@DESCRIPTION=ERROR return the specified error.

@EXAMPLES=
ERROR("#OWN ERROR").

@SEEALSO=ISERROR @FUNCTION=ERROR.TYPE
@SYNTAX=ERROR.TYPE(value)
@DESCRIPTION=ERROR.TYPE returns an error number corresponding to the given error value.  The error numbers for error values are:

	#DIV/0!  		2
	#VALUE!  	3
	#REF!    		4
	#NAME?   	5
	#NUM!    		6
	#N/A     		7

* This function is Excel compatible.

@EXAMPLES=
ERROR.TYPE(NA()) equals 7.

@SEEALSO=ISERROR @FUNCTION=EURO
@SYNTAX=EURO(currency)
@DESCRIPTION=EURO converts one Euro to a given national currency in the European monetary union.

@currency is one of the following:

    ATS	(Austria)
    BEF	(Belgium)
    DEM	(Germany)
    ESP	(Spain)
    EUR	(Euro)
    FIM	(Finland)
    FRF	(France)
    GRD	(Greek)
    IEP	(Ireland)
    ITL	(Italy)
    LUF	(Luxembourg)
    NLG	(Netherlands)
    PTE	(Portugal)

* If the given @currency is other than one of the above, EURO returns #NUM! error.

@EXAMPLES=
EURO("DEM") returns 1.95583.
@SEEALSO= @FUNCTION=EUROCONVERT
@SYNTAX=EUROCONVERT(n,source,target)
@DESCRIPTION=EUROCONVERT converts the currency value @n of @source currency to a target currency @target. Both currencies are given as three-letter strings using the ISO code system names.  The following currencies are available:

    ATS	(Austria)
    BEF	(Belgium)
    DEM	(Germany)
    ESP	(Spain)
    EUR	(Euro)
    FIM	(Finland)
    FRF	(France)
    GRD	(Greek)
    IEP	(Ireland)
    ITL	(Italy)
    LUF	(Luxembourg)
    NLG	(Netherlands)
    PTE	(Portugal)

* If the given @source or @target is other than one of the above, EUROCONVERT returns #VALUE! error.

@EXAMPLES=
EUROCONVERT(2.1,"DEM","EUR") returns 1.07.
@SEEALSO=EURO @FUNCTION=EXECSQL
@SYNTAX=EXECSQL(dsn,username,password,sql)
@DESCRIPTION=The EXECSQL function lets you execute a command in a database server, and show the results returned in current sheet. It uses libgda as the means for accessing the databases.
For using it, you need first to set up a libgda data source.
@EXAMPLES=
To get all the data from the table "Customers" present in the "mydatasource" GDA data source, you would use:
EXECSQL("mydatasource","username","password","SELECT * FROM customers")
@SEEALSO=READDBTABLE @FUNCTION=EXPRESSION
@SYNTAX=EXPRESSION(cell)
@DESCRIPTION=EXPRESSION returns expression in @cell as a string, or empty if the cell is not an expression.
@EXAMPLES=
entering '=EXPRESSION(A3)' in A2 = empty (assuming there is nothing in A3).
entering '=EXPRESSION(A2)' in A1 = 'EXPRESSION(A3)'.

@SEEALSO=TEXT @FUNCTION=FALSE
@SYNTAX=FALSE()
@DESCRIPTION=FALSE returns boolean value false.

* This function is Excel compatible.

@EXAMPLES=
FALSE() equals FALSE.

@SEEALSO=TRUE @FUNCTION=GETENV
@SYNTAX=GETENV(string)
@DESCRIPTION=GETENV retrieves a value from the execution environment.

* If the variable specified by @string does not exist, #N/A! will be returned.  Note, that variable names are case sensitive.
@EXAMPLES=

@SEEALSO= @FUNCTION=HEX2BIN
@SYNTAX=HEX2BIN(number[,places])
@DESCRIPTION=HEX2BIN function converts a hexadecimal number to a binary number.  @places is an optional field, specifying to zero pad to that number of spaces.

* If @places is too small or negative #NUM! error is returned.
* This function is Excel compatible.

@EXAMPLES=
HEX2BIN("2A") equals 101010.

@SEEALSO=BIN2HEX, HEX2OCT, HEX2DEC @FUNCTION=HEX2DEC
@SYNTAX=HEX2DEC(x)
@DESCRIPTION=HEX2DEC function converts a hexadecimal number to its decimal equivalent.

* This function is Excel compatible.

@EXAMPLES=
HEX2DEC("2A") equals 42.

@SEEALSO=DEC2HEX, HEX2BIN, HEX2OCT @FUNCTION=HEX2OCT
@SYNTAX=HEX2OCT(number[,places])
@DESCRIPTION=HEX2OCT function converts a hexadecimal number to an octal number.  @places is an optional field, specifying to zero pad to that number of spaces.

* If @places is too small or negative #NUM! error is returned.
* This function is Excel compatible.

@EXAMPLES=
HEX2OCT("2A") equals 52.

@SEEALSO=OCT2HEX, HEX2BIN, HEX2DEC @FUNCTION=HOUR
@SYNTAX=HOUR (date)
@DESCRIPTION=HOUR converts a serial number to an hour.  The hour is returned as an integer in the range 0 (12:00 A.M.) to 23 (11:00 P.M.).

* Note that Gnumeric will perform regular string to serial number conversion for you, so you can enter a date as a string.
* This function is Excel compatible.

@EXAMPLES=
HOUR(0.128472) equals 3.

@SEEALSO=MINUTE, NOW, TIME, SECOND @FUNCTION=INFO
@SYNTAX=INFO(type)
@DESCRIPTION=INFO returns information about the current operating environment. 

@type is the type of information you want to obtain:

  memavail 	Returns the amount of memory available, bytes.
  memused  	Returns the amount of memory used (bytes).
  numfile  		Returns the number of active worksheets.
  osversion		Returns the operating system version.
  recalc   		Returns the recalculation mode (automatic).
  release  		Returns the version of Gnumeric as text.
  system   		Returns the name of the environment.
  totmem   		Returns the amount of total memory available.

* This function is Excel compatible, except that types directory and origin are not implemented.

@EXAMPLES=
INFO("system") returns "Linux" on a Linux system.

@SEEALSO= @FUNCTION=ISBLANK
@SYNTAX=ISBLANK(value)
@DESCRIPTION=ISBLANK returns TRUE if the value is blank.

* This function is Excel compatible.

@EXAMPLES=
ISBLANK(A1).

@SEEALSO= @FUNCTION=ISERR
@SYNTAX=ISERR(value)
@DESCRIPTION=ISERR returns TRUE if the value is any error value except #N/A.

* This function is Excel compatible. 
@EXAMPLES=
ISERR(NA()) return FALSE.

@SEEALSO=ISERROR @FUNCTION=ISERROR
@SYNTAX=ISERROR(value)
@DESCRIPTION=ISERROR returns a TRUE value if the expression has an error.

* This function is Excel compatible.

@EXAMPLES=
ISERROR(NA()) equals TRUE.

@SEEALSO=ERROR @FUNCTION=ISEVEN
@SYNTAX=ISEVEN(value)
@DESCRIPTION=ISEVEN returns TRUE if the number is even.

* This function is Excel compatible.

@EXAMPLES=
ISEVEN(4) equals TRUE.

@SEEALSO=ISODD @FUNCTION=ISLOGICAL
@SYNTAX=ISLOGICAL(value)
@DESCRIPTION=ISLOGICAL returns TRUE if the value is a logical value.

* This function is Excel compatible.

@EXAMPLES=
ISLOGICAL(A1).

@SEEALSO= @FUNCTION=ISNA
@SYNTAX=ISNA(value)
@DESCRIPTION=ISNA returns TRUE if the value is the #N/A error value.

* This function is Excel compatible.

@EXAMPLES=
ISNA(NA()) equals TRUE.

@SEEALSO=NA @FUNCTION=ISNONTEXT
@SYNTAX=ISNONTEXT(value)
@DESCRIPTION=ISNONTEXT Returns TRUE if the value is not text.

* This function is Excel compatible.

@EXAMPLES=
ISNONTEXT("text") equals FALSE.

@SEEALSO=ISTEXT @FUNCTION=ISNUMBER
@SYNTAX=ISNUMBER(value)
@DESCRIPTION=ISNUMBER returns TRUE if the value is a number.

* This function is Excel compatible.

@EXAMPLES=
ISNUMBER("text") equals FALSE.

@SEEALSO= @FUNCTION=ISODD
@SYNTAX=ISODD(value)
@DESCRIPTION=ISODD returns TRUE if the number is odd.

* This function is Excel compatible.

@EXAMPLES=
ISODD(3) equals TRUE.

@SEEALSO=ISEVEN @FUNCTION=ISOWEEKNUM
@SYNTAX=ISOWEEKNUM (date)
@DESCRIPTION=ISOWEEKNUM returns the ISO 8601 week number of @date.

An ISO 8601 week starts on Monday. Weeks are numbered from 1. A week including days from two different years is assigned to the year which includes the most days. This means that Dec 31 could be in week 1 of the following year, and Jan 1 could be in week 52 or 53 of the previous year. ISOWEEKNUM returns the week number.

* ISOWEEKNUM returns #NUM! if date is invalid.

@EXAMPLES=
If A1 contains 12/21/00 then ISOWEEKNUM(A1)=51
@SEEALSO=WEEKNUM, ISOYEAR @FUNCTION=ISOYEAR
@SYNTAX=ISOYEAR (date)
@DESCRIPTION=ISOYEAR returns the year of the ISO 8601 week number of @date.

An ISO 8601 week starts on Monday. Weeks are numbered from 1. A week including days from two different years is assigned to the year which includes the most days. This means that Dec 31 could be in week 1 of the following year, and Jan 1 could be in week 52 or 53 of the previous year. ISOYEAR returns the year the week is assigned to.

* ISOYEAR returns #NUM! if date is invalid.
@EXAMPLES=
If A1 contains 12/31/2001 then ISOYEAR(A1)=2002
@SEEALSO=ISOWEEKNUM @FUNCTION=ISPRIME
@SYNTAX=ISPRIME(i)
@DESCRIPTION=ISPRIME function returns TRUE if @i is prime and FALSE otherwise.

@EXAMPLES=
@SEEALSO=ITHPRIME, NT_D, NT_SIGMA @FUNCTION=ISREF
@SYNTAX=ISREF(value)
@DESCRIPTION=ISREF returns TRUE if the value is a reference.

* This function is Excel compatible.

@EXAMPLES=
ISREF(A1) equals TRUE.

@SEEALSO= @FUNCTION=ISTEXT
@SYNTAX=ISTEXT(value)
@DESCRIPTION=ISTEXT returns TRUE if the value is text.

* This function is Excel compatible.

@EXAMPLES=
ISTEXT("text") equals TRUE.

@SEEALSO=ISNONTEXT @FUNCTION=ITHPRIME
@SYNTAX=ITHPRIME(i)
@DESCRIPTION=ITHPRIME function returns the @ith prime.

@EXAMPLES=
@SEEALSO=NT_D, NT_SIGMA @FUNCTION=MINUTE
@SYNTAX=MINUTE (date)
@DESCRIPTION=MINUTE converts a serial number to a minute.  The minute is returned as an integer in the range 0 to 59.

* Note that Gnumeric will perform regular string to serial number conversion for you, so you can enter a date as a string.
* This function is Excel compatible.

@EXAMPLES=
MINUTE(0.128472) equals 5.

@SEEALSO=HOUR, NOW, TIME, SECOND @FUNCTION=MONTH
@SYNTAX=MONTH (date)
@DESCRIPTION=MONTH converts a serial number to a month.

* Note that Gnumeric will perform regular string to serial number conversion for you, so you can enter a date as a string.
* This function is Excel compatible.

@EXAMPLES=
MONTH(DATE(2003, 4, 30)) equals 4.

@SEEALSO=DAY, TIME, NOW, YEAR @FUNCTION=N
@SYNTAX=N(value)
@DESCRIPTION=N returns a value converted to a number.  Strings containing text are converted to the zero value.

* This function is Excel compatible.

@EXAMPLES=
N("42") equals 42.

@SEEALSO= @FUNCTION=NA
@SYNTAX=NA()
@DESCRIPTION=NA returns the error value #N/A.

* This function is Excel compatible.

@EXAMPLES=
NA() equals #N/A error.

@SEEALSO=ISNA @FUNCTION=NETWORKDAYS
@SYNTAX=NETWORKDAYS (start_date,end_date[,holidays])
@DESCRIPTION=NETWORKDAYS returns the number of non-weekend non-holidays between @start_date and @end_date including these dates. Holidays are optionally supplied in @holidays.

* NETWORKDAYS returns #NUM! if @start_date or @end_date are invalid.
* This function is Excel compatible.

@EXAMPLES=
NETWORKDAYS(DATE(2001,1,2),DATE(2001,2,15)) equals 33.

@SEEALSO=WORKDAY @FUNCTION=NOW
@SYNTAX=NOW ()
@DESCRIPTION=NOW returns the serial number for the date and time at the time it is evaluated.

Serial Numbers in Gnumeric are represented as follows: The integral part is the number of days since the 1st of January of 1900.  The decimal part represent the fraction of the day and is mapped into hour, minutes and seconds.

For example: .0 represents the beginning of the day, and 0.5 represents noon.

* This function is Excel compatible.

@EXAMPLES=
NOW().

@SEEALSO=TODAY @FUNCTION=NT_PI
@SYNTAX=NT_PI(n)
@DESCRIPTION=NT_PI function returns the number of primes less than or equal to @n.

@EXAMPLES=
@SEEALSO=ITHPRIME, NT_PHI, NT_D, NT_SIGMA @FUNCTION=OCT2BIN
@SYNTAX=OCT2BIN(number[,places])
@DESCRIPTION=OCT2BIN function converts an octal number to a binary number.  @places is an optional field, specifying to zero pad to that number of spaces.

* If @places is too small or negative #NUM! error is returned.
* This function is Excel compatible.

@EXAMPLES=
OCT2BIN("213") equals 10001011.

@SEEALSO=BIN2OCT, OCT2DEC, OCT2HEX @FUNCTION=OCT2DEC
@SYNTAX=OCT2DEC(x)
@DESCRIPTION=OCT2DEC function converts an octal number in a string or number to its decimal equivalent.

* This function is Excel compatible.

@EXAMPLES=
OCT2DEC("124") equals 84.

@SEEALSO=DEC2OCT, OCT2BIN, OCT2HEX @FUNCTION=OCT2HEX
@SYNTAX=OCT2HEX(number[,places])
@DESCRIPTION=OCT2HEX function converts an octal number to a hexadecimal number.  @places is an optional field, specifying to zero pad to that number of spaces.

* If @places is too small or negative #NUM! error is returned.
* This function is Excel compatible.

@EXAMPLES=
OCT2HEX(132) equals 5A.

@SEEALSO=HEX2OCT, OCT2BIN, OCT2DEC @FUNCTION=SECOND
@SYNTAX=SECOND (date)
@DESCRIPTION=SECOND converts a serial number to a second.  The second is returned as an integer in the range 0 to 59.

* Note that Gnumeric will perform regular string to serial number conversion for you, so you can enter a date as a string.
* This function is Excel compatible.

@EXAMPLES=
SECOND(0.600613) equals 53.

@SEEALSO=HOUR, MINUTE, NOW, TIME @FUNCTION=TIME
@SYNTAX=TIME (hours,minutes,seconds)
@DESCRIPTION=TIME returns a fraction representing the time of day.

* This function is Excel compatible.

@EXAMPLES=
TIME(3, 5, 23) equals 3:05AM.

@SEEALSO=HOUR @FUNCTION=TIMEVALUE
@SYNTAX=TIMEVALUE (timetext)
@DESCRIPTION=TIMEVALUE returns a fraction representing the time of day, a number between 0 and 1.

* This function is Excel compatible.

@EXAMPLES=
TIMEVALUE("3:05") equals 0.128472.
TIMEVALUE("2:24:53 PM") equals 0.600613.

@SEEALSO=HOUR,MINUTE @FUNCTION=TODAY
@SYNTAX=TODAY()
@DESCRIPTION=TODAY returns the serial number for today (the number of days elapsed since the 1st of January of 1900).

* This function is Excel compatible.

@EXAMPLES=
TODAY() returns 'Nov 6, 2001' on that particular day.
 
@SEEALSO=NOW @FUNCTION=TRUE
@SYNTAX=TRUE()
@DESCRIPTION=TRUE returns boolean value true.

* This function is Excel compatible.

@EXAMPLES=
TRUE() equals TRUE.

@SEEALSO=FALSE @FUNCTION=TYPE
@SYNTAX=TYPE(value)
@DESCRIPTION=TYPE returns a number indicating the data type of a value.

1  == number
2  == text
4  == boolean
16 == error
64 == array
* This function is Excel compatible.

@EXAMPLES=
TYPE(3) equals 1.
TYPE("text") equals 2.

@SEEALSO= @FUNCTION=UNIX2DATE
@SYNTAX=UNIX2DATE(unixtime)
@DESCRIPTION=UNIX2DATE converts a unix time into a spreadsheet date and time.

A unix time is the number of seconds since midnight January 1, 1970.

@EXAMPLES=

@SEEALSO=NOW, DATE, DATE2UNIX @FUNCTION=WEEKDAY
@SYNTAX=WEEKDAY (date[, method])
@DESCRIPTION=WEEKDAY converts a serial number to a weekday.

This function returns an integer indicating the day of week.
@METHOD indicates the numbering system.  It defaults to 1.

  For @METHOD=1: Sunday is 1, Monday is 2, etc.
  For @METHOD=2: Monday is 1, Tuesday is 2, etc.
  For @METHOD=3: Monday is 0, Tuesday is 1, etc.

* Note that Gnumeric will perform regular string to serial number conversion for you, so you can enter a date as a string.
* This function is Excel compatible.

@EXAMPLES=
WEEKDAY("10/24/1968") equals 5 (Thursday).

@SEEALSO=DAY, MONTH, TIME, NOW, YEAR @FUNCTION=WEEKNUM
@SYNTAX=WEEKNUM (date[,method])
@DESCRIPTION=WEEKNUM returns the week number of @date according to the given @method.

@method defaults to 1.

  For @method=1, week starts on Sunday, and days before first Sunday are in week 0.
  For @method=2, week starts on Monday, and days before first Monday are in week 0.
  For @method=150, the ISO 8601 week number is returned.

* WEEKNUM returns #NUM! if @date or @method is invalid.
* This function is Excel compatible, except that Excel does not support ISO 8601 week numbers.

@EXAMPLES=
If A1 contains 12/21/00 then WEEKNUM(A1,2)=51
@SEEALSO=ISOWEEKNUM @FUNCTION=WORKDAY
@SYNTAX=WORKDAY (start_date,days[,holidays])
@DESCRIPTION=WORKDAY returns the date which is @days working days from the @start_date.  Weekends and holidays optionally supplied in @holidays are respected.

* WORKDAY returns #NUM! if @start_date or @days are invalid.
* This function is Excel compatible.

@EXAMPLES=
DAY(WORKDAY(DATE(2001,1,5),30)) equals 16 and
MONTH(WORKDAY(DATE(2001,1,5),30)) equals 2.

@SEEALSO=NETWORKDAYS @FUNCTION=YEAR
@SYNTAX=YEAR (date)
@DESCRIPTION=YEAR converts a serial number to a year.

* Note that Gnumeric will perform regular string to serial number conversion for you, so you can enter a date as a string.
* This function is Excel compatible.

@EXAMPLES=
YEAR(DATE(2003, 4, 30)) equals 2003.

@SEEALSO=DAY, MONTH, TIME, NOW @FUNCTION=YEARFRAC
@SYNTAX=YEARFRAC (start_date, end_date [,basis])
@DESCRIPTION=YEARFRAC returns the number of full days between @start_date and @end_date according to the @basis.

@EXAMPLES=

@SEEALSO=DATEDIF x:value. Project-Id-Version: gnumeric-functions HEAD
Report-Msgid-Bugs-To: 
POT-Creation-Date: 2007-12-29 14:31-0500
PO-Revision-Date: 2007-03-17 20:13+0200
Last-Translator: Tomas Kuliavas <tokul@users.sourceforge.net>
Language-Team: Lithuanian <komp_lt@konferencijos.lt>
MIME-Version: 1.0
Content-Type: text/plain; charset=UTF-8
Content-Transfer-Encoding: 8bit
Plural-Forms: nplurals=3; plural=n%10==1 && n%100!=11 ? 0 : n%10>=2 && (n%100<10 || n%100>=20) ? 1 : 2;
 @FUNCTION=ASC
@SYNTAX=ASC(tekstas)
@DESCRIPTION=ASC yra suderinamumo funkcija, kurios panaudojimas Gnumeric neturi prasmės. MS Excel (tm) programoje funkcija paverčia 2 baitų @string į vieno baito tekstą.

@EXAMPLES=
ASC("Foo") išveda "Foo".

@SEEALSO= @FUNCTION=BASE
@SYNTAX=BASE(number,base[,length])
@DESCRIPTION=BASE funkcija konvertuoja skaičių į tekstą, kuris atitinkantį skaičių @base nurodytoje skaičiavimo sistemoje.

* @base turi būti sveikas skaičius tarp 2 ir 36.
* Ši funkcija suderinama su OpenOffice.Org.
* Papildomas @length parametras nurodo mažiausia resultato ilgį. Jei rezultatas yra mažesnis, funkcija priekyje prideda nulius.

@EXAMPLES=
BASE(255,16,4) lygu "00FF".

@SEEALSO=DECIMAL @FUNCTION=BIN2DEC
@SYNTAX=BIN2DEC(x)
@DESCRIPTION=BIN2DEC funkcija verčia dvejetainį skaičių į dešimtainį.

* Ši funkcija yra suderinama su Excel.

@EXAMPLES=
BIN2DEC(101) lygi 5.

@SEEALSO=DEC2BIN, BIN2OCT, BIN2HEX @FUNCTION=BIN2HEX
@SYNTAX=BIN2HEX(skaičius[,vietos])
@DESCRIPTION=BIN2HEX funkcija verčia dvejetainį skaičių į šešioliktainį. @vietos yra papildomas argumentas, kuris leidžia nustatyti nulinį priedąlygų vietų skaičiui.

* Jei @vietos yra per mažas arba neigiamas, išvedama #SKAIČIUS! klaida.
* Ši funkcija yra suderinama su Excel.

@EXAMPLES=
BIN2HEX(100111) lygu 27.

@SEEALSO=HEX2BIN, BIN2OCT, BIN2DEC @FUNCTION=BIN2OCT
@SYNTAX=BIN2OCT(skaičius[,vietos])
@DESCRIPTION=BIN2OCT funkcija verčia dvejetainį skaičių į aštuntainį. @vietos yra papildomas argumentas, kuris leidžia nustatyti nulinį priedąlygų vietų skaičiui.

* Jei @vietos yra per mažas arba neigiamas, išvedama #SKAIČIUS! klaida.
* Ši funkcija yra suderinama su Excel.

@EXAMPLES=
BIN2OCT(110111) lygi 67.

@SEEALSO=OCT2BIN, BIN2DEC, BIN2HEX @FUNCTION=CELL
@SYNTAX=CELL(type,ref)
@DESCRIPTION=CELL išveda formatavimo, vietos ir turinio informaciją apielaukelį.

@type nustato norimos informacijos tipą:

  address    	Išveda tekstinę laukelio nuorodą.
  col        		Išveda @ref nurodyto stulpelio numerį.
  contents   	Išveda @ref nurodyto laukelio turinį.
  format     		Išveda laukelio formato kodą.
  parentheses	Išveda 1, jei @ref saugo neigiamą reikšmę
             		ir laukelio formatavimas rodo duomenis skliaustuose.
  row        		Išveda @ref nurodytos eilutės numerį.
  width      		Išveda stulpelio plotį.

* Ši funkcija suderinama su Excel.

@EXAMPLES=
Cell("format",A1) išveda laukelio A1 formato kodą.

@SEEALSO=INDIRECT @FUNCTION=COUNTBLANK
@SYNTAX=COUNTBLANK(range)
@DESCRIPTION=COUNTBLANK išveda @range nurodytoje srityje esančių tuščių laukelių skaičių.

* Ši funkcija suderinama su Excel.

@EXAMPLES=
COUNTBLANK(A1:A20) išveda tarp A1:A20 esančių tuščių laukelių kiekį.

@SEEALSO=COUNT @FUNCTION=DATE
@SYNTAX=DATE (metai,mėnuo,diena)
@DESCRIPTION=DATE išveda dienų kiekį nuo 1900 metų sausio 1 dienos (datos serijinį numerį) nurodytais metais, mėnesį ir dieną.

* Jei @mėnuo < 1 arba @mėnuo > 12, metų reikšmė bus pataisyta. Panašus pataisymai bus taikomi ir dienų atveju.
* @metai turi būti ne mažesni kaip 1900. Jei @metai < 1900, reikšmė bus prilyginta 1900 + @years.
* Jei nurodyta data yra neteisinga, DATE išveda #NUM! klaidą.
* Ši funkcija suderinama su Excel.

@EXAMPLES=
DATE(2001, 3, 30) išveda 2001 metų kovo mėnesio 30 dienos datą.
 
@SEEALSO=TODAY, NOW @FUNCTION=DATE2UNIX
@SYNTAX=DATE2UNIX(serijinė data)
@DESCRIPTION=DATE2UNIX konvertuoja skaičiuoklės datos ir laiko serijinį numerį į unix laiką.

Unix laikas yra skaičius nurodantis sekunčių kiekį nuo 1970 metų sausio 1 dienos vidurnakčio.

@EXAMPLES=
DATE2UNIX("01/01/2000") lygus 946656000.

@SEEALSO=NOW, DATE, UNIX2DATE @FUNCTION=DATEDIF
@SYNTAX=DATEDIF(data1,data2,intervalas)
@DESCRIPTION=DATEDIF išveda skirtumą tarp dviejų datų.  @intervalas turi vieną iš šešių galimų reikšmių:  "y", "m", "d", "ym", "md" ir "yd".

Pirmos trys reikšmės išvestų metų, mėnesių arba dienų kiekį tarp dviejų nurodytų datų.

  "ym" išves pilnų mėnesių kiekį tarp dviejų datų neskaitant metų skritumo.
  "md" išves pilnų dienų kiekį tarp dviejų datų neskaitant mėnesių skirtumo.
  "yd" išves pilnų dienų kiekį tarp dviejų datų neskaitant metų skirtumo.

* Ši funkcija suderinama su Excel.

@EXAMPLES=
DATEDIF(DATE(2000,4,30),DATE(2003,8,4),"d") lygi 1191.
DATEDIF(DATE(2000,4,30),DATE(2003,8,4),"y") lygi 3.

@SEEALSO=DATE @FUNCTION=DATEVALUE
@SYNTAX=DATEVALUE(datos_eilutė)
@DESCRIPTION=DATEVALUE išveda datos serijinį numerį.  @datos_eilutė yra simbolinė datos išraiška. Reikšmė priklauso nuo datos formato. MS Excel 1900 datos formatas skaičiuoja datas nuo 1900 sausio 1 dienos, o 1904 formatas naudoja 1904 metų saugio 1 dieną.

* Ši funkcija suderinama su Excel.

@EXAMPLES=
DATEVALUE("1/1/1999") lygi 36161 (1900 formate).
@SEEALSO=DATE @FUNCTION=DAVERAGE
@SYNTAX=DAVERAGE(duomenų_bazė,laukas,kriterijus)
@DESCRIPTION=DAVERAGE funkcija apskaičiuoja vidurkį reikšmių, saugomų sąraše arba duomenų bazėje ir atitinkančių nurodytus kriterijus.

@duomenų_bazė nustato laukelių sritį saugančią apdorojamą informaciją. Kiekviena eilutė yra atskiras įrašas. Kiekvienas stulpelis yra laukas. Pirma eilutėsaugo kiekvieno stulpelio žymes. 

@laukas nustato funkcijos apdorojamą stulpelį. Jei @laukas nurodo sveiką skaičių, naudojamas atitinkamas duomenų stulpelis. Pavyzdžiui, 2 reiškia antrą duomenų stulpelį. Laukas gali nurodyti ir stulpelio žymes. Pavyzdžiui, „Amžius“ reikšmė nurodo, kad reikia naudoti @duomenų_bazė srityje esantį stulpelį su „Amžius“ žyme.

@kriterijus yra laukelių sritis, kuri nustato atrinkimo sąlygas. Pirma @kriterijus nurodytos srities eilutė turi saugoti laukų žymes. Žemiau esantys laukeliai nustato sąlygas.Pavyzdžiui, „>3“ arba „<9“. Sutapimo sąlygos yra nurodomos reikšmėmis be sąlygų. Pavyzdžiui, „3“' arba „Jonas“.
Kiekviena @kriterijus eilutė nustato atskirą sąlygą. Jei @duomenų_bazė eilutė atitinka @kriterijus eilutė, ji yra naudojama. Techniškai kalbant, kiekviena @kriterijus eilutė nustato loginę ARBA sąlygą.
Jei @kriterijus nurodo daugiau nei vieną stulpelį, @duomenų_bazė duomenys turi atitikti visas stulpelių iškeltas sąlygas. Techniškai kalbant, kiekvienas @kriterijus stulpelis nustato loginę IR sąlygą.

@EXAMPLES=
Tarkime, kad sritis A1:C7 saugo žemiau nurodytą informaciją:
Vardas    Amžius     Alga
Jonas    34      54342
Bilas    35      22343
Klarkas   29      34323
Bobas     43      47242
Suzana   37      42932
Jilė    45      45324

Tuo tarpu laukai A9:B11 saugo žemiau nurodytas reikšmes:
Amžius     Alga
<30
>40     >46000

DAVERAGE(A1:C7, "Alga", A9:A11) lygu 42296.3333.
DAVERAGE(A1:C7, "Amžius", A9:A11) lygu 39.
DAVERAGE(A1:C7, "Alga", A9:B11) lygu 40782.5.
DAVERAGE(A1:C7, "Amžius", A9:B11) lygu 36.

@SEEALSO=DCOUNT @FUNCTION=DAY
@SYNTAX=DAY (date)
@DESCRIPTION=DAY verčia serijinį datos numerį į dieną.

* Pastaba. Gnumeric pervers paprastą tekstinę eilutę į serijinį numerį automatiškai, todėl datą galima vesti ir tekstine forma.
* Ši funkcija yra suderinama su Excel.

@EXAMPLES=
DAY("10/24/1968") equals 24.

@SEEALSO=MONTH, TIME, NOW, YEAR @FUNCTION=DAYS360 
@SYNTAX=DAYS360 (data1,data2,metodas)
@DESCRIPTION=DAYS360 išveda dienų skaičių nuo @data1 iki @data2 laikydamasi 360 dienų kalendoriaus, kuris visus mėnesius prilygina 30 dienų.

* Jei @metodas yra 1, bus naudojamas europinis metodas. Šis metodas visas 31 dienas prilygina 30 dienai.
* Jei @metodas yra 0 arba nenurodytas, naudojamas XL JAV metodas. Tai sudėtingas pramoninis metodas, kuris paskutine vasario mėnesio diena laiko 30 dieną, taiko tai tik pirmai datai.
* Jei @metodas yra 2, naudojamas protingesnis JAV metodo variantas, kuris abi vasario datas apdoroja vienodai.
* Pastaba. Gnumeric pervers paprastą tekstinę eilutę į serijinį numerį automatiškai, todėl datą galima vesti ir tekstine forma.
* Ši funkcija yra suderinama su Excel.

@EXAMPLES=
DAYS360(DATE(2003, 2, 3), DATE(2007, 4, 2)) lygu 1499.

@SEEALSO=MONTH, TIME, NOW, YEAR @FUNCTION=DCOUNT
@SYNTAX=DCOUNT(duomenų_bazė,laukas,kriterijus)
@DESCRIPTION=DCOUNT funkcija apskaičiuoja kiekį reikšmių, saugomų sąraše arba duomenų bazėje ir atitinkančių nurodytus kriterijus.

@duomenų_bazė nustato laukelių sritį saugančią apdorojamą informaciją. Kiekviena eilutė yra atskiras įrašas. Kiekvienas stulpelis yra laukas. Pirma eilutėsaugo kiekvieno stulpelio žymes. 

@laukas nustato funkcijos apdorojamą stulpelį. Jei @laukas nurodo sveiką skaičių, naudojamas atitinkamas duomenų stulpelis. Pavyzdžiui, 2 reiškia antrą duomenų stulpelį. Laukas gali nurodyti ir stulpelio žymes. Pavyzdžiui, „Amžius“ reikšmė nurodo, kad reikia naudoti @duomenų_bazė srityje esantį stulpelį su „Amžius“ žyme.

@kriterijus yra laukelių sritis, kuri nustato atrinkimo sąlygas. Pirma @kriterijus nurodytos srities eilutė turi saugoti laukų žymes. Žemiau esantys laukeliai nustato sąlygas.Pavyzdžiui, „>3“ arba „<9“. Sutapimo sąlygos yra nurodomos reikšmėmis be sąlygų. Pavyzdžiui, „3“' arba „Jonas“.
Kiekviena @kriterijus eilutė nustato atskirą sąlygą. Jei @duomenų_bazė eilutė atitinka @kriterijus eilutė, ji yra naudojama. Techniškai kalbant, kiekviena @kriterijus eilutė nustato loginę ARBA sąlygą.
Jei @kriterijus nurodo daugiau nei vieną stulpelį, @duomenų_bazė duomenys turi atitikti visas stulpelių iškeltas sąlygas. Techniškai kalbant, kiekvienas @kriterijus stulpelis nustato loginę IR sąlygą.

@EXAMPLES=
Tarkime, kad sritis A1:C7 saugo žemiau nurodytą informaciją:
Vardas    Amžius     Alga
Jonas    34      54342
Bilas    35      22343
Klarkas   29      34323
Bobas     43      47242
Suzana   37      42932
Jilė    45      45324

Tuo tarpu laukai A9:B11 saugo žemiau nurodytas reikšmes:
Amžius     Alga
<30
>40     >46000

DCOUNT(A1:C7, "Alga", A9:A11) lygu 3.
DCOUNT(A1:C7, "Alga", A9:B11) lygu 2.
DCOUNT(A1:C7, "Vardas", A9:B11) lygu 0.

@SEEALSO=DAVERAGE @FUNCTION=DEC2BIN
@SYNTAX=DEC2BIN(number[,places])
@DESCRIPTION=DEC2BIN funkcija konvertuoja dešimtainį skaičių į dvejetainį.@places yra papildomas parametras, kuris nustato kiek skaitmenų turi turėti rezultatas. Jei skaitmenų yra mažiau, priekyje pridedami nuliai.

* Jei @places yra per mažas arba neigiamas, išvedama #NUM! klaida.
* Ši funkcija suderinama su Excel.

@EXAMPLES=
DEC2BIN(42) lygu 101010.

@SEEALSO=BIN2DEC, DEC2OCT, DEC2HEX @FUNCTION=DEC2HEX
@SYNTAX=DEC2HEX(number[,places])
@DESCRIPTION=DEC2HEX funkcija paverčia dešimtainį skaičių į šešioliktainį. @places yra papildomaas atributas, kuris nurodo šešioliktainio skaičiaus skaitmenų kiekį.

* Jei @places yra per mažas arba neigiamas - funkcija išveda #NUM! klaidos pranešimą.
* Ši funkcija yra suderinama su Excel.

@EXAMPLES=
DEC2HEX(42) lygu 2A.

@SEEALSO=HEX2DEC, DEC2BIN, DEC2OCT @FUNCTION=DEC2OCT
@SYNTAX=DEC2OCT(number[,places])
@DESCRIPTION=DEC2OCT unkcija konvertuoja dešimtainį skaičių į aštuntainį.@places yra papildomas parametras, kuris nustato kiek skaitmenų turi turėti rezultatas. Jei skaitmenų yra mažiau, priekyje pridedami nuliai.

* Jei @places yra per mažas arba neigiamas, išvedama #NUM! klaida.
* Ši funkcija suderinama su Excel.

@EXAMPLES=
DEC2OCT(42) lygu 52.

@SEEALSO=OCT2DEC, DEC2BIN, DEC2HEX @FUNCTION=DECIMAL
@SYNTAX=DECIMAL(text,base)
@DESCRIPTION=DECIMAL funkcija konvertuoja skaičių iš @base nurodytos skaičiavimo sistemos į dešimtainę sistemą.

* @base turi būti sveikas skaičius tarp 2 ir 36.
* Ši funkcija suderinama su OpenOffice.Org.

@EXAMPLES=
DECIMAL("A1",16) lygu 161.

@SEEALSO=BASE @FUNCTION=EDATE
@SYNTAX=EDATE(data,mėnesiai)
@DESCRIPTION=EDATE išveda datos, kuri skiriasi nuo nurodytos datos pernurodytu mėnesių dydžiu, serijinį numerį.  @data nustato pradinės datos serijinį numerį, o @mėnesiai - mėnesių kiekį iki (neigiama vertė) arba po (teigiama vertė) pradinės datos.

* Jei @mėnesiai nėra sveikas skaičius, jis bus suapvalintas.
* Ši funkcija suderinama su Excel.

@EXAMPLES=
EDATE(DATE(2001,12,30),2) išveda 'Feb 28, 2002'.

@SEEALSO=DATE @FUNCTION=EOMONTH
@SYNTAX=EOMONTH (start_date,months)
@DESCRIPTION=EOMONTH išveda mėnesio, kuris yra po @months mėnesių nuo @start_date, paskutinę dieną.

* EOMONTH išveda #NUM!, jei @start_date arba @months reikšmės yra klaidingos.
* Ši funkcija yra suderinama su Excel.

@EXAMPLES=
Jei A1 saugo 2000-12-21, tada EOMONTH(A1,0)=2000-12-31, EOMONTH(A1,5)=2001-05-31, o EOMONTH(A1,2)=2001-02-28

@SEEALSO=MONTH @FUNCTION=ERROR
@SYNTAX=ERROR(text)
@DESCRIPTION=ERROR išveda nurodytą klaidą.

@EXAMPLES=
ERROR("#NUOSAVA KLAIDA").

@SEEALSO=ISERROR @FUNCTION=ERROR.TYPE
@SYNTAX=ERROR.TYPE(value)
@DESCRIPTION=ERROR.TYPE išveda klaidos numerį atitinkantį nurodytą klaidos reikšmę. Galimos klaidų reikšmės yra:

	#DIV/0!  		2
	#VALUE!  	3
	#REF!    		4
	#NAME?   	5
	#NUM!    		6
	#N/A     		7

* Ši funkcija yra suderinama su Excel.

@EXAMPLES=
ERROR.TYPE(NA()) lygu 7.

@SEEALSO=ISERROR @FUNCTION=EURO
@SYNTAX=EURO(currency)
@DESCRIPTION=EURO konvertuoja vieną Euro į pasirinktą Eurozonos nacionalinę valiutą.

@currency gali būti viena iš žemiau nurodytų reikšmių:

    ATS	(Austrija)
    BEF	(Belgija)
    DEM	(Vokietija)
    ESP	(Ispanija)
    EUR	(Euro)
    FIM	(Suomija)
    FRF	(Prancūzija)
    GRD	(Graikija)
    IEP	(Airija)
    ITL	(Italija)
    LUF	(Liuksemburgas)
    NLG	(Olandija)
    PTE	(Portugalija)

* Jei @currency nurodoma kita reikšmė, EURO išveda #NUM! klaidą.

@EXAMPLES=
EURO("DEM") lygu 1.95583.
@SEEALSO=EUROCONVERT @FUNCTION=EUROCONVERT
@SYNTAX=EUROCONVERT(n,source,target)
@DESCRIPTION=EUROCONVERT konvertuoja piniginę @n reiškmę iš @source valiutos į @target nurodytą valiutą. Valiutos nurodomos trijų ženklų ISO kodais. Galimos valiutųreikšmės yra:

 ···ATS	(Austrija)
····BEF	(Belgija)
····DEM	(Vokietija)
····ESP	(Ispanija)
····EUR	(Euro)
····FIM	(Suomija)
····FRF	(Prancūzija)
····GRD	(Graikija)
····IEP	(Airija)
····ITL	(Italija)
····LUF	(Liuksemburgas)
····NLG	(Olandija)
····PTE	(Portugalija)

* Jei @source ar @target yra nurodyta kita reikšmė, EUROCONVERT išveda #VALUE! klaidą.

@EXAMPLES=
EUROCONVERT(2.1,"DEM","EUR") lygu 1.07.
@SEEALSO=EURO @FUNCTION=EXECSQL
@SYNTAX=EXECSQL(dsn,vartotojas,slaptažodis,sql)
@DESCRIPTION=EXECSQL funkcija leidžia Jums įvykdyti komandą duomenųbazės serveryje ir padoryti rezultatus aktyvioje lentelėje. Priėjimui prie duomenųbazės naudomos libgda bibliotekos.
Prieš panaudojant funkciją reikia sukurti libgda duomenų šaltinį.
@EXAMPLES=
Norėdami gauti duomenis iš "Klientai" lentelės saugomos "manoduomenys" GDA duomenų šaltinyje, Jūs turėtumėte naudoti:
EXECSQL("manoduomenys","vartotojas","slaptažodis","SELECT * FROM Klientai")
@SEEALSO=READDBTABLE @FUNCTION=EXPRESSION
@SYNTAX=EXPRESSION(cell)
@DESCRIPTION=EXPRESSION išveda tekstinę @cell nurodytame laukelyje esančios formulės išraišką arba tuščią eilutę, jei laukelis saugo ne formulę.
@EXAMPLES=
įvedus '=EXPRESSION(A3)' tarp A2 = tuščia (jei nieko nėra tarp A3).
įvedus '=EXPRESSION(A2)' tarp A1 = 'EXPRESSION(A3)'.

@SEEALSO=TEXT @FUNCTION=FALSE
@SYNTAX=FALSE()
@DESCRIPTION=FALSE išveda loginę neigiamą reikšmę.

* Ši·funkcija·yra·suderinama·su·Excel..

@EXAMPLES=
FALSE() lygu FALSE.

@SEEALSO=TRUE @FUNCTION=GETENV
@SYNTAX=GETENV(string)
@DESCRIPTION=GETENV išveda reikšmę iš programos aplinkos.

* Jei kintamasis nurodytas tarp @string neegzistuoja, išvedama #N/A! klaida. Atkreipkite dėmesį į tai, kad kintamųjų vardai priklauso nuo raidžiųregistro.
@EXAMPLES=

@SEEALSO= @FUNCTION=HEX2BIN
@SYNTAX=HEX2BIN(number[,places])
@DESCRIPTION=HEX2BIN funkcija·konvertuoja·šešioliktainį·skaičių·į·dvejetainį.@places·yra·papildomas·parametras,·kuris·nustato·kiek·skaitmenų·turi·turėti·rezultatas.·Jei·skaitmenų·yra·mažiau,·priekyje·pridedami·nuliai.

*·Jei·@places·yra·per·mažas·arba·neigiamas,·išvedama·#NUM!·klaida.
*·Ši·funkcija·suderinama·su·Excel.

@EXAMPLES=
HEX2BIN("2A") lygu 101010.

@SEEALSO=BIN2HEX, HEX2OCT, HEX2DEC @FUNCTION=HEX2DEC
@SYNTAX=HEX2DEC(x)
@DESCRIPTION=HEX2DEC funkcija konvertuoja šešioliktainį skaičių į dešimtainę sistemą.

* Ši funkcija suderinama su Excel.

@EXAMPLES=
HEX2DEC("2A") lygu 42.

@SEEALSO=DEC2HEX, HEX2BIN, HEX2OCT @FUNCTION=HEX2OCT
@SYNTAX=HEX2OCT(number[,places])
@DESCRIPTION=HEX2OCT funkcija·konvertuoja·šešioliktainį·skaičių·į·aštuntainį.@places·yra·papildomas·parametras,·kuris·nustato·kiek·skaitmenų·turi·turėti·rezultatas.·Jei·skaitmenų·yra·mažiau,·priekyje·pridedami·nuliai.

*·Jei·@places·yra·per·mažas·arba·neigiamas,·išvedama·#NUM!·klaida.
*·Ši·funkcija·suderinama·su·Excel.

@EXAMPLES=
HEX2OCT("2A") lygu 52.

@SEEALSO=OCT2HEX, HEX2BIN, HEX2DEC @FUNCTION=HOUR
@SYNTAX=HOUR (data)
@DESCRIPTION=HOUR verčia serijinį datos numerį į valandą. Valanda išvedama kaip sveikasis skaičius nuo 0 (vidurnaktis) iki 23 (23 valanda).

* Pastaba. Gnumeric pervers paprastą tekstinę eilutę į serijinį numerį automatiškai, todėl datą galima vesti ir tekstine forma.
* Ši funkcija yra suderinama su Excel.

@EXAMPLES=
HOUR(0.128472) lygi 3.

@SEEALSO=MINUTE, NOW, TIME, SECOND @FUNCTION=INFO
@SYNTAX=INFO(type)
@DESCRIPTION=INFO išveda informaciją apie esamą operacinę sistemą. 

@type nustato norimos gauti informacijos tipą:

  memavail 	Išveda prieinamą atminties kiekį baitais.
  memused  	Išveda panaudotos atminties kiekį baitais.
  numfile  		Išveda aktyvių darbo knygų kiekį.
  osversion		Išveda operacinės sistemos versiją.
  recalc   		Išveda perskaičiavimo režimą (automatinis).
  release  		Išveda tekstinę Gnumeric versiją.
  system   		Išveda aplinkos pavadinimą.
  totmem   		Išveda bendra atminties kiekį.

* Ši funkcija suderinama su Excel, tačiau katalogo tipo ir kilmės tipai yra nepalaikomi.

@EXAMPLES=
INFO("system") išveda "Linux" ant Linux sistemų.

@SEEALSO= @FUNCTION=ISBLANK
@SYNTAX=ISBLANK(value)
@DESCRIPTION=ISBLANK išveda TRUE, jei nurodyta reikšmė yra tuščia.

* Ši funkcija yra suderinama su Excel.

@EXAMPLES=
ISBLANK(A1).

@SEEALSO= @FUNCTION=ISERR
@SYNTAX=ISERR(value)
@DESCRIPTION=ISERR išveda TRUE, jei parametras saugo bet kokį klaidos kodą, išskyrus #N/A.

* Ši funkcija yra suderinama su Excel. 
@EXAMPLES=
ISERR(NA()) lygu FALSE.

@SEEALSO=ISERROR @FUNCTION=ISERROR
@SYNTAX=ISERROR(value)
@DESCRIPTION=ISERROR išveda TRUE reikšmę, jei formulėje yra klaida.

* Ši funkcija suderinama su Excel.

@EXAMPLES=
ISERROR(NA()) lygu TRUE.

@SEEALSO=ERROR @FUNCTION=ISEVEN
@SYNTAX=ISEVEN(value)
@DESCRIPTION=ISEVEN išveda TRUE, jei skaičius yra lyginis.

* Ši funkcija yra suderinama su Excel.

@EXAMPLES=
ISEVEN(4) lygu TRUE.

@SEEALSO=ISODD @FUNCTION=ISLOGICAL
@SYNTAX=ISLOGICAL(value)
@DESCRIPTION=ISLOGICAL išveda TRUE, jei reikšmė yra loginis kintamasis.

* Ši funkcija yra suderinama su Excel.

@EXAMPLES=
ISLOGICAL(A1).

@SEEALSO= @FUNCTION=ISNA
@SYNTAX=ISNA(value)
@DESCRIPTION=ISNA išveda TRUE, jei parametras saugo #N/A klaidos kodą.

* Ši funkcija suderinama su Excel.

@EXAMPLES=
ISNA(NA()) lygu TRUE.

@SEEALSO=NA @FUNCTION=ISNONTEXT
@SYNTAX=ISNONTEXT(value)
@DESCRIPTION=ISNONTEXT išveda TRUE, jei reikšmė yra ne tekstinė.

* Ši funkcija yra suderinama su Excel.

@EXAMPLES=
ISNONTEXT("tekstas") lygu FALSE.

@SEEALSO=ISTEXT @FUNCTION=ISNUMBER
@SYNTAX=ISNUMBER(value)
@DESCRIPTION=ISNUMBER išveda TRUE, jei reikšmė yra skaičius.

* Ši funkcija yra suderinama su Excel.

@EXAMPLES=
ISNUMBER("tekstas") lygu FALSE.

@SEEALSO= @FUNCTION=ISODD
@SYNTAX=ISODD(value)
@DESCRIPTION=ISODD išveda TRUE, jei skaičius yra nelyginis.

* Ši funkcija yra suderinama su Excel.

@EXAMPLES=
ISODD(3) lygu TRUE.

@SEEALSO=ISEVEN @FUNCTION=ISOWEEKNUM
@SYNTAX=ISOWEEKNUM (data)
@DESCRIPTION=ISOWEEKNUM išveda ISO 8601 savaitės numerį @data nurodytai datai.

ISO 8601 savaitė prasideda pirmadienį. Savaitės yra numeruojamos nuo 1. Savaitėpriklausanti dviem skirtingiems metams yra priskiriama metams, kuriuose ji turi daugiau dienų . Tai reiškia, kad gruodžio 31 gali priklausyti pirmai savaitei metuose, o sausio 1 gali būti ankstesnių metų 52 ar 53 savaitės dalis. ISOWEEKNUM išveda savaitės numerį.

* ISOWEEKNUM išveda #NUM! jei data yra klaidinga.

@EXAMPLES=
Jei A1 saugo 12/21/00 tada ISOWEEKNUM(A1)=51
@SEEALSO=WEEKNUM, ISOYEAR @FUNCTION=ISOYEAR
@SYNTAX=ISOYEAR (data)
@DESCRIPTION=ISOYEAR išveda ISO 8601 savaitės metus @data nurodytai datai.

ISO·8601·savaitė·prasideda·pirmadienį.·Savaitės·yra·numeruojamos·nuo·1.·Savaitėpriklausanti·dviem·skirtingiems·metams·yra·priskiriama·metams,·kuriuose·ji·turi·daugiau·dienų·.·Tai·reiškia,·kad·gruodžio·31·gali·priklausyti·pirmai·savaitei·metuose,·o·sausio·1·gali·būti·ankstesnių·metų·52·ar·53·savaitės·dalis.·ISOYEAR išveda metus, kuriems priskiriama savaitė.

* ISOYEAR išveda #NUM! jei data yra klaidinga.
@EXAMPLES=
Jei A1 saugo 12/31/2001 tada ISOYEAR(A1)=2002
@SEEALSO=ISOWEEKNUM @FUNCTION=ISPRIME
@SYNTAX=ISPRIME(i)
@DESCRIPTION=ISPRIME funkcija išveda TRUE, jei @i yra pirminis skaičius ir FALSE,jei skaičius nėra pirminis.

@SEEALSO=ITHPRIME, NT_D, NT_SIGMA @FUNCTION=ISREF
@SYNTAX=ISREF(value)
@DESCRIPTION=ISREF išveda TRUE, jei reikšmė yra nuoroda.

* Ši funkcija yra suderinama su Excel.

@EXAMPLES=
ISREF(A1) lygu TRUE.

@SEEALSO= @FUNCTION=ISTEXT
@SYNTAX=ISTEXT(value)
@DESCRIPTION=ISTEXT išveda TRUE, jei reikšmė yra tekstinė.

* Ši funkcija yra suderinama su Excel.

@EXAMPLES=
ISTEXT("tekstas") lygu TRUE.

@SEEALSO=ISNONTEXT @FUNCTION=ITHPRIME
@SYNTAX=ITHPRIME(i)
@DESCRIPTION=ITHPRIME funkcija išveda @i'ą pirminį skaičių.

@EXAMPLES=
@SEEALSO=NT_D, NT_SIGMA @FUNCTION=MINUTE
@SYNTAX=MINUTE (data)
@DESCRIPTION=MINUTE verčia serijinį datos numerį į minutes. Minutės išvedamos kaip sveikasis skaičius nuo 0 iki 59.

* Pastaba. Gnumeric pervers paprastą tekstinę eilutę į serijinį numerį automatiškai, todėl datą galima vesti ir tekstine forma.
* Ši funkcija yra suderinama su Excel.

@EXAMPLES=
MINUTE(0.128472) lygu 5.

@SEEALSO=HOUR, NOW, TIME, SECOND @FUNCTION=MONTH
@SYNTAX=MONTH (date)
@DESCRIPTION=MONTH verčia serijinį datos numerį į mėnesius.

* Pastaba. Gnumeric pervers paprastą tekstinę eilutę į serijinį numerį automatiškai, todėl datą galima vesti ir tekstine forma.
* Ši funkcija yra suderinama su Excel.

@EXAMPLES=
MONTH(DATE(2003, 4, 30)) equals 4.

@SEEALSO=DAY, TIME, NOW, YEAR @FUNCTION=N
@SYNTAX=N(value)
@DESCRIPTION=N išveda reikšmę konvertuotą į skaičių. Reikšmės su tekstu yra konvertuojamos į nulines vertes.

* Ši funkcija yra suderinama su Excel.

@EXAMPLES=
N("42") lygu 42.

@SEEALSO= @FUNCTION=NA
@SYNTAX=NA()
@DESCRIPTION=NA išveda #N/A klaidos reikšmę.

* Ši funkcija yra suderinama su Excel.

@EXAMPLES=
NA() lygu #N/A klaida.

@SEEALSO=ISNA @FUNCTION=NETWORKDAYS
@SYNTAX=NETWORKDAYS (start_date,end_date[,holidays])
@DESCRIPTION=NETWORKDAYS išveda nešventinių ir neatostoginių dienų kiekį tarp @start_date ir @end_date įskaitant pradinę ir galinę datą. Atostogos nurodomos@holidays parametru.

* NETWORKDAYS išveda #NUM! jei @start_date arba @end_date yra klaidingi.
* Ši funkcija yra suderinama su Excel.

@EXAMPLES=
NETWORKDAYS(DATE(2001,1,2),DATE(2001,2,15)) lygu 33.

@SEEALSO=WORKDAY @FUNCTION=NOW
@SYNTAX=NOW ()
@DESCRIPTION=NOW išveda esamos dienos bei laiko serijinį datos numerį.

Gnumeric serijinius datos numeris atvaizduoja pagal šias taisykles:
  Sveikoji skaičiaus dalis rodo dienų skaičių nuo 1900 metų sausio 1 dienos.
  Dešimtainė dalis rodo valandas, minutes ir sekundes kaip dienos dalįPavyzdžiui: .0 reiškia dienos pradžia, o 0,5 reiškia vidurdienį.

* Ši funkcija suderinama su Excel.

@EXAMPLES=
NOW().

@SEEALSO=TODAY @FUNCTION=NT_PI
@SYNTAX=NT_PI(n)
@DESCRIPTION=NT_PI funkciją išveda pirminių skaičių, ne didesnių už @n, kiekį.

@EXAMPLES=
@SEEALSO=ITHPRIME,·NT_PHI,·NT_D,·NT_SIGMA @FUNCTION=OCT2BIN
@SYNTAX=OCT2BIN(number[,places])
@DESCRIPTION=OCT2BIN funkcija·konvertuoja·aštuntainį·skaičių·į·dvejetainį.@places·yra·papildomas·parametras,·kuris·nustato·kiek·skaitmenų·turi·turėti·rezultatas.·Jei·skaitmenų·yra·mažiau,·priekyje·pridedami·nuliai.

*·Jei·@places·yra·per·mažas·arba·neigiamas,·išvedama·#NUM!·klaida.
*·Ši·funkcija·suderinama·su·Excel.

@EXAMPLES=
OCT2BIN("213") lygu 10001011.

@SEEALSO=BIN2OCT, OCT2DEC, OCT2HEX @FUNCTION=OCT2DEC
@SYNTAX=OCT2DEC(x)
@DESCRIPTION=OCT2DEC funkcija aštuntainį skaičių paverčia į jo dešimtainį atitikmenį.

* Ši funkcija yra suderinama su Excel.

@EXAMPLES=
OCT2DEC("124") lygu 84.

@SEEALSO=DEC2OCT, OCT2BIN, OCT2HEX @FUNCTION=OCT2HEX
@SYNTAX=OCT2HEX(number[,places])
@DESCRIPTION=OCT2HEX funkcija·konvertuoja·aštuntainį·skaičių·į·šešioliktainį.@places·yra·papildomas·parametras,·kuris·nustato·kiek·skaitmenų·turi·turėti·rezultatas.·Jei·skaitmenų·yra·mažiau,·priekyje·pridedami·nuliai.

*·Jei·@places·yra·per·mažas·arba·neigiamas,·išvedama·#NUM!·klaida.
*·Ši·funkcija·suderinama·su·Excel.

@EXAMPLES=
OCT2HEX(132) lygu 5A.

@SEEALSO=HEX2OCT, OCT2BIN, OCT2DEC @FUNCTION=SECOND
@SYNTAX=SECOND (date)
@DESCRIPTION=SECOND verčia serijinį datos numerį į sekundes. Sekundės išvedamos kaip sveikasis skaičius nuo 0 iki 59.

* Pastaba. Gnumeric pervers paprastą tekstinę eilutę į serijinį numerį automatiškai, todėl datą galima vesti ir tekstine forma.
* Ši funkcija yra suderinama su Excel.

@EXAMPLES=
SECOND(0.600613) lygu 53.

@SEEALSO=HOUR, MINUTE, NOW, TIME @FUNCTION=TIME
@SYNTAX=TIME (valandos,minutės,sekundės)
@DESCRIPTION=TIME išveda trupmeną, rodančią laiką.

* Ši funkcija suderinama su Excel.

@EXAMPLES=
TIME(3, 5, 23) lygi 3 valandai 5 minutėms ir 23 sekundėms.

@SEEALSO=HOUR @FUNCTION=TIMEVALUE
@SYNTAX=TIMEVALUE (laiko_eilutė)
@DESCRIPTION=TIMEVALUE išveda trupmeną rodančią laiką kaip dienos dalį, skaičių tarp 0 ir 1.

* Ši funkcija yra suderinama su Excel.

@EXAMPLES=
TIMEVALUE("3:05") lygi 0.128472.
TIMEVALUE("2:24:53 PM") lygi 0.600613.

@SEEALSO=HOUR,MINUTE @FUNCTION=TODAY
@SYNTAX=TODAY()
@DESCRIPTION=TODAY išveda esamos dienos serijinį numerį (dienų kiekį nuo 1900 sausio 1 dienos iki šiandienos).

* Ši funkcija suderinama su Excel.

@EXAMPLES=
TODAY() išveda 2001 metų lapkričio 6 dienos data būtent tą dieną.
 
@SEEALSO=NOW @FUNCTION=TRUE
@SYNTAX=TRUE()
@DESCRIPTION=TRUE išveda loginę teigiamą reikšmę.

* Ši funkcija suderinama su Excel.

@EXAMPLES=
TRUE() lygu TRUE.

@SEEALSO=FALSE @FUNCTION=TYPE
@SYNTAX=TYPE(value)
@DESCRIPTION=TYPE išveda skaičių, nurodantį argumento duomenų tipą.

1  == skaičius
2  == tekstas
4  == loginis
16 == klaida
64 == masyvas
* Ši funkcija yra suderinama su Excel.

@EXAMPLES=
TYPE(3) lygu 1.
TYPE("tekstas") lygu 2.

@SEEALSO= @FUNCTION=UNIX2DATE
@SYNTAX=UNIX2DATE(unix laikas)
@DESCRIPTION=UNIX2DATE konvertuoja unix laiko vienetus į įprastą skaičiuoklės datos ir lako formatą.

Unix laikas yra skaičius nurodantis sekunčių kiekį nuo 1970 metų sausio 1 dienos vidurnakčio.

@EXAMPLES=

@SEEALSO=NOW, DATE, DATE2UNIX @FUNCTION=WEEKDAY
@SYNTAX=WEEKDAY (data[, metodas])
@DESCRIPTION=WEEKDAY verčia serijinį datos numerį į savaitės dieną.

Funkcija išveda sveiką skaičių rodantį savaitės dieną.
@METHOD rodo skaičiavimo sistemą. Pagal nutylėjimą galioja 1.

  Jei @METHOD=1: Sekmadienis yra 1, Pirmadienis yra 2 ir t.t.
  Jei @METHOD=2: Pirmadienis yra 1, Antradienis yra 2 ir t.t.
  Jei @METHOD=3: Pirmadienis yra 0, Antradienis yra 1 ir t.t.

* Pastaba. Gnumeric pervers paprastą tekstinę eilutę į serijinį numerį automatiškai, todėl datą galima vesti ir tekstine forma.
* Ši funkcija yra suderinama su Excel.

@EXAMPLES=
WEEKDAY("10/24/1968") lygu 5 (Ketvirtadienis).

@SEEALSO=DAY, MONTH, TIME, NOW, YEAR @FUNCTION=WEEKNUM
@SYNTAX=WEEKNUM (data[,metodas])
@DESCRIPTION=WEEKNUM išveda savaitės numerį apskaičiuotą @data nurodytaidatai pagal @metodas nurodytą metodą.

@metodas standartinė reikšmė yra 1.

  Jei @metodas=1, savaitė prasideda sekmadienį, o dienos prieš pirmą sekmadienį priklauso savaitei 0.
  Jei @metodas=2, savaitė prasideda pirmadienį, o dienos prieš pirmą pirmadienį priklauso savaitei 0.
  Jei @metodas=150, skaičiuojamas ISO 8601 savaitės numeris.

* WEEKNUM išveda #NUM! jei @date arba @metodas yra klaidingi.
* Ši funkcija yra suderinama su Excel, tačiau Excel nepalaiko ISO 8601 savaičiųskaičiavimo metodo.

@EXAMPLES=
Jei A1 saugo 12/21/00 tada WEEKNUM(A1,2)=51
@SEEALSO=ISOWEEKNUM @FUNCTION=WORKDAY
@SYNTAX=WORKDAY (start_date,days[,holidays])
@DESCRIPTION=WORKDAY išveda datą, kuri yra po @days darbo dienų nuo @start_date. Funkcija atsižvelgia į savaitgalius ir švenčių dienas, nurodytas @holidays.

* WORKDAY išveda #NUM!, jei @start_date arba @days yra klaidinga.
* Ši funkcija yra suderinama su Excel.

@EXAMPLES=
DAY(WORKDAY(DATE(2001,1,5),30)) lygu 16, o
MONTH(WORKDAY(DATE(2001,1,5),30)) lygu 2.

@SEEALSO=NETWORKDAYS @FUNCTION=YEAR
@SYNTAX=YEAR (date)
@DESCRIPTION=YEAR verčia serijinį datos numerį į metus.

* Pastaba. Gnumeric pervers paprastą tekstinę eilutę į serijinį numerį automatiškai, todėl datą galima vesti ir tekstine forma.
* Ši funkcija yra suderinama su Excel.

@EXAMPLES=
YEAR(DATE(2003, 4, 30)) lygu 2003.

@SEEALSO=DAY, MONTH, TIME, NOW @FUNCTION=YEARFRAC
@SYNTAX=YEARFRAC (start_date, end_date [,basis])
@DESCRIPTION=YEARFRAC išveda tarp @start_date ir @end_date esančių pilnų dienų skaičių pagal @basis.

@EXAMPLES=

@SEEALSO=DATEDIF x:reikšmė. 