/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.pad;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import org.jgraph.pad.GraphModelProvider;
import org.jgraph.pad.GraphModelProviderRegistry;
import org.jgraph.pad.resources.Translator;
import org.jgraph.utils.Utilities;

public class GPSelectProvider
extends JDialog {
    JPanel pnlMain = new JPanel(new BorderLayout());
    JList lstGraphModelProviders = new JList();
    JScrollPane paneScroll = new JScrollPane(this.lstGraphModelProviders);
    JButton cmdOk = new JButton(Translator.getString("OK"));
    public static final int OPTION_OK = 0;
    public static final int OPTION_CANCEL = 1;
    int answer = 0;

    protected void init() {
        this.setTitle(Translator.getString("GPSelectProvider.Title"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GPSelectProvider.this.answer = 1;
            }
        });
        this.lstGraphModelProviders.setCellRenderer(new GraphModelProviderRenderer());
        this.lstGraphModelProviders.setPreferredSize(new Dimension(300, 200));
        GraphModelProvider[] graphModelProviderArray = GraphModelProviderRegistry.getGraphModelProviders();
        if (graphModelProviderArray.length == 0) {
            JOptionPane.showMessageDialog(this, Translator.getString("Error.No_GraphModelProvider_available"), Translator.getString("Error"), 0);
        }
        this.lstGraphModelProviders.setListData(graphModelProviderArray);
        this.lstGraphModelProviders.setSelectedIndex(0);
        this.pnlMain.add((Component)this.paneScroll, "Center");
        this.paneScroll.setAutoscrolls(true);
        this.pnlMain.add((Component)this.cmdOk, "South");
        this.cmdOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GPSelectProvider.this.setVisible(false);
            }
        });
        this.getContentPane().add(this.pnlMain);
        this.pack();
        Utilities.center(this);
    }

    public GPSelectProvider(Frame frame) throws HeadlessException {
        super(frame, true);
        this.init();
    }

    public GraphModelProvider getSelectedGraphModelProvider() {
        if (this.lstGraphModelProviders.getModel().getSize() == 0) {
            return null;
        }
        return (GraphModelProvider)this.lstGraphModelProviders.getSelectedValue();
    }

    public GPSelectProvider(Dialog dialog) throws HeadlessException {
        super(dialog, true);
        this.init();
    }

    public int getAnswer() {
        return this.answer;
    }

    public void show() {
        if (this.lstGraphModelProviders.getModel().getSize() <= 1) {
            return;
        }
        super.show();
    }

    class GraphModelProviderRenderer
    extends JLabel
    implements ListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            GraphModelProvider graphModelProvider = (GraphModelProvider)object;
            this.setText(graphModelProvider.getPresentationName());
            this.setOpaque(true);
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            return this;
        }
    }
}

