/*
 * Decompiled with CFR 0.152.
 */
package br.arca.morcego.run;

import br.arca.morcego.Config;
import br.arca.morcego.Morcego;
import br.arca.morcego.physics.PunctualBody;
import br.arca.morcego.physics.Vector3D;
import br.arca.morcego.structure.Graph;
import br.arca.morcego.structure.Link;
import br.arca.morcego.structure.Node;
import java.util.Enumeration;
import java.util.Vector;

public class Balancer
implements Runnable {
    private boolean balancing = true;
    private boolean balancingLock = false;
    private Graph graph;
    private int balancedCount;
    private boolean implementsHierarchy;

    public Balancer(Graph g) {
        this.graph = g;
        this.balancedCount = 0;
    }

    public void stop() {
        if (!this.balancingLock) {
            this.balancing = false;
        }
    }

    public void lockBalance() {
        this.balancingLock = true;
    }

    public void unlockBalance() {
        this.balancingLock = false;
    }

    public void awake() {
        this.balancing = true;
        Balancer balancer = this;
        synchronized (balancer) {
            this.notify();
        }
    }

    public void forceToLevel(Node node) {
        PunctualBody body = node.getBody();
        Vector3D orientation = this.graph.getOrientation();
        float x = body.getSpeed().getX();
        float y = body.getSpeed().getY();
        float z = body.getSpeed().getZ();
        float a = orientation.getX();
        float b = orientation.getY();
        float c = orientation.getZ();
        Vector3D newSpeed = new Vector3D(b * b * x + c * c * x - a * b * y - a * c * z, -b * a * x + a * a * y + c * c * y - b * c * z, -c * a * x - c * b * y + a * a * z + b * b * z);
        Node center = this.graph.getCenterNode();
        Vector3D speed = new Vector3D(a, b, c);
        int relativeHierarchy = 0;
        try {
            relativeHierarchy = (Integer)center.getProperty("hierarchy") - (Integer)node.getProperty("hierarchy");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        speed.resize((float)(100 * relativeHierarchy) / speed.module());
        speed.add(new Vector3D(-body.getX(), -body.getY(), -body.getZ()));
    }

    public void run() {
        Thread.currentThread().setPriority(1);
        try {
            int cycleCount = 0;
            while (true) {
                this.waitUntilBalancingIsNeeded();
                this.runBalancingEngine();
                this.finishedBalancing();
                if (cycleCount % 20 == 0) {
                    cycleCount = 0;
                    this.checkSystemStability();
                }
                ++cycleCount;
            }
        }
        catch (InterruptedException e) {
            System.out.println("Balancing interrupted");
            return;
        }
    }

    public void runBalancingEngine() {
        this.checkAllForces();
        this.balance();
        Morcego.getCamera().adjustPosition(this.graph);
    }

    private void finishedBalancing() throws InterruptedException {
        if (this.balancing) {
            this.balancedCount = 0;
        }
        Morcego.notifyRenderer();
        Thread.sleep(Config.getInteger("morcego.balancingStepInterval"));
    }

    private void balance() {
        Enumeration en = this.getNodes().elements();
        while (en.hasMoreElements()) {
            Node node = (Node)en.nextElement();
            node.move();
        }
    }

    private void checkSystemStability() {
        Enumeration en = this.getNodes().elements();
        boolean stable = true;
        while (stable && en.hasMoreElements()) {
            Node node = (Node)en.nextElement();
            if (!(node.getBody().getSpeed().module() > 1.0f)) continue;
            stable = false;
        }
        if (stable) {
            this.stop();
        }
    }

    private void checkAllForces() {
        this.implementsHierarchy = Config.getBoolean("morcego._implementsHierarchy");
        int j = 0;
        while (j < this.getNodes().size()) {
            Node node1 = (Node)this.getNodes().elementAt(j);
            if (this.implementsHierarchy) {
                this.forceToLevel(node1);
            }
            int k = j + 1;
            while (k < this.getNodes().size()) {
                Node node2 = (Node)this.getNodes().elementAt(k);
                Vector3D force = node1.getBody().repel(node2.getBody());
                node1.getBody().getInstantForce().add(force);
                node2.getBody().getInstantForce().add(force.opposite());
                ++k;
            }
            ++j;
        }
        j = 0;
        while (j < this.getLinks().size()) {
            Link link = (Link)this.getLinks().elementAt(j);
            Vector3D force = link.getSpring().strech();
            link.getNode1().getBody().getInstantForce().add(force);
            link.getNode2().getBody().getInstantForce().add(force.opposite());
            ++j;
        }
        j = 0;
        while (j < this.getNodes().size()) {
            ((Node)this.getNodes().elementAt(j)).getBody().applyForce();
            ++j;
        }
    }

    private Vector getNodes() {
        return this.graph.getNodes();
    }

    private Vector getLinks() {
        return this.graph.getLinks();
    }

    private void waitUntilBalancingIsNeeded() throws InterruptedException {
        while (!this.balancing) {
            Balancer balancer = this;
            synchronized (balancer) {
                this.wait();
            }
        }
    }

    public void notifyBalanced(Node node) {
        ++this.balancedCount;
        if (this.balancedCount == this.graph.getNodes().size()) {
            this.stop();
        }
    }
}

