<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 2158 $
 * $Id: PolicyGroupFactory.class.php 2158 2008-09-15 23:26:15Z ipso $
 * $Date: 2008-09-15 16:26:15 -0700 (Mon, 15 Sep 2008) $
 */

/**
 * @package Module_Policy
 */
class PolicyGroupFactory extends Factory {
	protected $table = 'policy_group';
	protected $pk_sequence_name = 'policy_group_id_seq'; //PK Sequence name

	protected $company_obj = NULL;
	function getCompanyObject() {
		if ( is_object($this->company_obj) ) {
			return $this->company_obj;
		} else {
			$clf = new CompanyListFactory();
			$this->company_obj = $clf->getById( $this->getCompany() )->getCurrent();

			return $this->company_obj;
		}
	}

	function getCompany() {
		if ( isset($this->data['company_id']) ) {
			return $this->data['company_id'];
		}

		return FALSE;
	}
	function setCompany($id) {
		$id = trim($id);

		Debug::Text('Company ID: '. $id, __FILE__, __LINE__, __METHOD__,10);
		$clf = new CompanyListFactory();

		if ( $this->Validator->isResultSetWithRows(	'company',
													$clf->getByID($id),
													TTi18n::gettext('Company is invalid')
													) ) {

			$this->data['company_id'] = $id;

			return TRUE;
		}

		return FALSE;
	}

	function getName() {
		if ( isset($this->data['name']) ) {
			return $this->data['name'];
		}

		return FALSE;
	}
	function setName($name) {
		$name = trim($name);
		if (	$this->Validator->isLength(	'name',
											$name,
											TTi18n::gettext('Name is invalid'),
											2,50)
						) {

			$this->data['name'] = $name;

			return TRUE;
		}

		return FALSE;
	}

	function getUser() {
		$pgulf = new PolicyGroupUserListFactory();
		$pgulf->getByPolicyGroupId( $this->getId() );
		foreach ($pgulf as $obj) {
			$list[] = $obj->getUser();
		}

		if ( isset($list) ) {
			return $list;
		}

		return FALSE;
	}
	function setUser($ids) {
		Debug::text('Setting User IDs : ', __FILE__, __LINE__, __METHOD__, 10);
		if ( is_array($ids) ) {
			if ( !$this->isNew() ) {
				//If needed, delete mappings first.
				$pgulf = new PolicyGroupUserListFactory();
				$pgulf->getByPolicyGroupId( $this->getId() );

				$tmp_ids = array();
				foreach ($pgulf as $obj) {
					$id = $obj->getUser();
					Debug::text('Policy ID: '. $obj->getPolicyGroup() .' ID: '. $id, __FILE__, __LINE__, __METHOD__, 10);

					//Delete users that are not selected.
					if ( !in_array($id, $ids) ) {
						Debug::text('Deleting: '. $id, __FILE__, __LINE__, __METHOD__, 10);
						$obj->Delete();
					} else {
						//Save ID's that need to be updated.
						Debug::text('NOT Deleting : '. $id, __FILE__, __LINE__, __METHOD__, 10);
						$tmp_ids[] = $id;
					}
				}
				unset($id, $obj);
			}

			//Insert new mappings.
			$ulf = new UserListFactory();

			foreach ($ids as $id) {
				if ( isset($ids) AND !in_array($id, $tmp_ids) ) {
					$pguf = new PolicyGroupUserFactory();
					$pguf->setPolicyGroup( $this->getId() );
					$pguf->setUser( $id );

					$ulf->getById( $id );
					if ( $ulf->getRecordCount() > 0 ) {
						$obj = $ulf->getCurrent();

						if ($this->Validator->isTrue(		'user',
															$pguf->Validator->isValid(),
															TTi18n::gettext('Selected employee is invalid or already assigned to another policy group ').' ('. $obj->getFullName() .')' )) {
							$pguf->save();
						}
					}
				}
			}

			return TRUE;
		}

		Debug::text('No User IDs to set.', __FILE__, __LINE__, __METHOD__, 10);
		return FALSE;
	}

	function getOverTimePolicy() {
		$pgotplf = new PolicyGroupOverTimePolicyListFactory();
		$pgotplf->getByPolicyGroupId( $this->getId() );
		foreach ($pgotplf as $obj) {
			$list[] = $obj->getOverTimePolicy();
		}

		if ( isset($list) ) {
			return $list;
		}

		return FALSE;
	}
	function setOverTimePolicy($ids) {
		Debug::text('Setting OTP IDs : ', __FILE__, __LINE__, __METHOD__, 10);
		if ( is_array($ids) ) {
			if ( !$this->isNew() ) {
				//If needed, delete mappings first.
				$pgotplf = new PolicyGroupOverTimePolicyListFactory();
				$pgotplf->getByPolicyGroupId( $this->getId() );

				$tmp_ids = array();
				foreach ($pgotplf as $obj) {
					$id = $obj->getOverTimePolicy();
					Debug::text('Policy ID: '. $obj->getPolicyGroup() .' ID: '. $id, __FILE__, __LINE__, __METHOD__, 10);

					//Delete users that are not selected.
					if ( !in_array($id, $ids) ) {
						Debug::text('Deleting: '. $id, __FILE__, __LINE__, __METHOD__, 10);
						$obj->Delete();
					} else {
						//Save ID's that need to be updated.
						Debug::text('NOT Deleting : '. $id, __FILE__, __LINE__, __METHOD__, 10);
						$tmp_ids[] = $id;
					}
				}
				unset($id, $obj);
			}

			//Insert new mappings.
			$otplf = new OverTimePolicyListFactory();

			foreach ($ids as $id) {
				if ( isset($ids) AND !in_array($id, $tmp_ids) ) {
					$pgotpf = new PolicyGroupOverTimePolicyFactory();
					$pgotpf->setPolicyGroup( $this->getId() );
					$pgotpf->setOverTimePolicy( $id );

					$obj = $otplf->getById( $id )->getCurrent();

					if ($this->Validator->isTrue(		'over_time_policy',
														$pgotpf->Validator->isValid(),
														TTi18n::gettext('Selected Overtime Policy is invalid').' ('. $obj->getName() .')' )) {
						$pgotpf->save();
					}
				}
			}

			return TRUE;
		}

		Debug::text('No OTP IDs to set.', __FILE__, __LINE__, __METHOD__, 10);
		return FALSE;
	}

	function getPremiumPolicy() {
		$pgpplf = new PolicyGroupPremiumPolicyListFactory();
		$pgpplf->getByPolicyGroupId( $this->getId() );
		foreach ($pgpplf as $obj) {
			$list[] = $obj->getPremiumPolicy();
		}

		if ( isset($list) ) {
			return $list;
		}

		return FALSE;
	}
	function setPremiumPolicy($ids) {
		Debug::text('Setting OTP IDs : ', __FILE__, __LINE__, __METHOD__, 10);
		if (is_array($ids) ) {
			if ( !$this->isNew() ) {
				//If needed, delete mappings first.
				$pgpplf = new PolicyGroupPremiumPolicyListFactory();
				$pgpplf->getByPolicyGroupId( $this->getId() );

				$tmp_ids = array();
				foreach ($pgpplf as $obj) {
					$id = $obj->getPremiumPolicy();
					Debug::text('Policy ID: '. $obj->getPolicyGroup() .' ID: '. $id, __FILE__, __LINE__, __METHOD__, 10);

					//Delete users that are not selected.
					if ( !in_array($id, $ids) ) {
						Debug::text('Deleting: '. $id, __FILE__, __LINE__, __METHOD__, 10);
						$obj->Delete();
					} else {
						//Save ID's that need to be updated.
						Debug::text('NOT Deleting : '. $id, __FILE__, __LINE__, __METHOD__, 10);
						$tmp_ids[] = $id;
					}
				}
				unset($id, $obj);
			}

			//Insert new mappings.
			$pplf = new PremiumPolicyListFactory();

			foreach ($ids as $id) {
				if ( isset($ids) AND !in_array($id, $tmp_ids) ) {
					$pgppf = new PolicyGroupPremiumPolicyFactory();
					$pgppf->setPolicyGroup( $this->getId() );
					$pgppf->setPremiumPolicy( $id );

					$obj = $pplf->getById( $id )->getCurrent();

					if ($this->Validator->isTrue(		'premium_policy',
														$pgppf->Validator->isValid(),
														TTi18n::gettext('Selected Premium Policy is invalid').' ('. $obj->getName() .')' )) {
						$pgppf->save();
					}
				}
			}

			return TRUE;
		}

		Debug::text('No OTP IDs to set.', __FILE__, __LINE__, __METHOD__, 10);
		return FALSE;
	}

	function getRoundIntervalPolicy() {
		$pgriplf = new PolicyGroupRoundIntervalPolicyListFactory();
		$pgriplf->getByPolicyGroupId( $this->getId() );
		foreach ($pgriplf as $obj) {
			$list[] = $obj->getRoundIntervalPolicy();
		}

		if ( isset($list) ) {
			return $list;
		}

		return FALSE;
	}
	function setRoundIntervalPolicy($ids) {
		Debug::text('Setting RIP IDs : ', __FILE__, __LINE__, __METHOD__, 10);
		if (is_array($ids) ) {
			if ( !$this->isNew() ) {
				//If needed, delete mappings first.
				$pgriplf = new PolicyGroupRoundIntervalPolicyListFactory();
				$pgriplf->getByPolicyGroupId( $this->getId() );

				$tmp_ids = array();
				foreach ($pgriplf as $obj) {
					$id = $obj->getRoundIntervalPolicy();
					Debug::text('Policy ID: '. $obj->getPolicyGroup() .' ID: '. $id, __FILE__, __LINE__, __METHOD__, 10);

					//Delete users that are not selected.
					if ( !in_array($id, $ids) ) {
						Debug::text('Deleting: '. $id, __FILE__, __LINE__, __METHOD__, 10);
						$obj->Delete();
					} else {
						//Save ID's that need to be updated.
						Debug::text('NOT Deleting : '. $id, __FILE__, __LINE__, __METHOD__, 10);
						$tmp_ids[] = $id;
					}
				}
				unset($id, $obj);
			}

			//Insert new mappings.
			$riplf = new RoundIntervalPolicyListFactory();

			foreach ($ids as $id) {
				if ( isset($ids) AND !in_array($id, $tmp_ids) ) {
					$pgripf = new PolicyGroupRoundIntervalPolicyFactory();
					$pgripf->setPolicyGroup( $this->getId() );
					$pgripf->setRoundIntervalPolicy( $id );

					$obj = $riplf->getById( $id )->getCurrent();

					if ($this->Validator->isTrue(		'round_interval_policy',
														$pgripf->Validator->isValid(),
														TTi18n::gettext('Selected Interval Rounding Policy is invalid').' ('. $obj->getName() .')' )) {
						$pgripf->save();
					}
				}
			}

			return TRUE;
		}

		Debug::text('No OTP IDs to set.', __FILE__, __LINE__, __METHOD__, 10);
		return FALSE;
	}

	function getAccrualPolicy() {
		$pgaplf = new PolicyGroupAccrualPolicyListFactory();
		$pgaplf->getByPolicyGroupId( $this->getId() );
		foreach ($pgaplf as $obj) {
			$list[] = $obj->getAccrualPolicy();
		}

		if ( isset($list) ) {
			return $list;
		}

		return FALSE;
	}
	function setAccrualPolicy($ids) {
		Debug::text('Setting Accrual Policy IDs : ', __FILE__, __LINE__, __METHOD__, 10);
		if ( is_array($ids) ) {
			if ( !$this->isNew() ) {
				//If needed, delete mappings first.
				$pgaplf = new PolicyGroupAccrualPolicyListFactory();
				$pgaplf->getByPolicyGroupId( $this->getId() );

				$tmp_ids = array();
				foreach ($pgaplf as $obj) {
					$id = $obj->getAccrualPolicy();
					Debug::text('Policy ID: '. $obj->getPolicyGroup() .' ID: '. $id, __FILE__, __LINE__, __METHOD__, 10);

					//Delete users that are not selected.
					if ( !in_array($id, $ids) ) {
						Debug::text('Deleting: '. $id, __FILE__, __LINE__, __METHOD__, 10);
						$obj->Delete();
					} else {
						//Save ID's that need to be updated.
						Debug::text('NOT Deleting : '. $id, __FILE__, __LINE__, __METHOD__, 10);
						$tmp_ids[] = $id;
					}
				}
				unset($id, $obj);
			}

			//Insert new mappings.
			$aplf = new AccrualPolicyListFactory();

			foreach ($ids as $id) {
				if ( isset($ids) AND !in_array($id, $tmp_ids) ) {
					$pgapf = new PolicyGroupAccrualPolicyFactory();
					$pgapf->setPolicyGroup( $this->getId() );
					$pgapf->setAccrualPolicy( $id );

					$obj = $aplf->getById( $id )->getCurrent();

					if ($this->Validator->isTrue(		'accrual_policy',
														$pgapf->Validator->isValid(),
														TTi18n::gettext('Selected Accrual Policy is invalid').' ('. $obj->getName() .')' )) {
						$pgapf->save();
					}
				}
			}

			return TRUE;
		}

		Debug::text('No Accrual Policy IDs to set.', __FILE__, __LINE__, __METHOD__, 10);
		return FALSE;
	}

	function getMealPolicyID() {
		if ( isset($this->data['meal_policy_id']) ) {
			return $this->data['meal_policy_id'];
		}

		return FALSE;
	}
	function setMealPolicyID($id) {
		$id = trim($id);

		if ( $id == '' OR empty($id) ) {
			$id = NULL;
		}

		$mplf = new MealPolicyListFactory();

		if ( $id == NULL
				OR
				$this->Validator->isResultSetWithRows(	'meal_policy',
														$mplf->getByID($id),
														TTi18n::gettext('Meal Policy is invalid')
													) ) {

			$this->data['meal_policy_id'] = $id;

			return TRUE;
		}

		return FALSE;
	}

	function getExceptionPolicyControlID() {
		if ( isset($this->data['exception_policy_control_id']) ) {
			return $this->data['exception_policy_control_id'];
		}

		return FALSE;
	}
	function setExceptionPolicyControlID($id) {
		$id = trim($id);

		if ( $id == '' OR empty($id) ) {
			$id = NULL;
		}

		$epclf = new ExceptionPolicyControlListFactory();

		if ( $id == NULL
				OR
				$this->Validator->isResultSetWithRows(	'exception_policy',
														$epclf->getByID($id),
														TTi18n::gettext('Exception Policy is invalid')
													) ) {

			$this->data['exception_policy_control_id'] = $id;

			return TRUE;
		}

		return FALSE;
	}

	function getHolidayPolicyID() {
		if ( isset($this->data['holiday_policy_id']) ) {
			return $this->data['holiday_policy_id'];
		}

		return FALSE;
	}
	function setHolidayPolicyID($id) {
		$id = trim($id);

		if ( $id == '' OR empty($id) ) {
			$id = NULL;
		}

		$hplf = new HolidayPolicyListFactory();

		if ( $id == NULL
				OR
				$this->Validator->isResultSetWithRows(	'holiday_policy',
														$hplf->getByID($id),
														TTi18n::gettext('Holiday Policy is invalid')
													) ) {

			$this->data['holiday_policy_id'] = $id;

			return TRUE;
		}

		return FALSE;
	}

/*
	//
	//No longer used now that AccrualPolicy() has been added.
	//
	function getAccrualPolicyID() {
		if ( isset($this->data['accrual_policy_id']) ) {
			return $this->data['accrual_policy_id'];
		}

		return FALSE;
	}
	function setAccrualPolicyID($id) {
		$id = trim($id);

		if ( $id == '' OR empty($id) ) {
			$id = NULL;
		}

		$aplf = new AccrualPolicyListFactory();

		if ( $id == NULL
				OR
				$this->Validator->isResultSetWithRows(	'accrual_policy',
														$aplf->getByID($id),
														TTi18n::gettext('Selected Accrual Policy is invalid')
													) ) {

			$this->data['accrual_policy_id'] = $id;

			return TRUE;
		}

		return FALSE;
	}
*/
	function Validate() {
		return TRUE;
	}

	function preSave() {
		return TRUE;
	}

	function postSave() {
		return TRUE;
	}

	function addLog( $log_action ) {
		return TTLog::addEntry( $this->getId(), $log_action,  TTi18n::getText('Policy Group'), NULL, $this->getTable() );
	}
}
?>
