<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1246 $
 * $Id: EditUserAccrual.php 1246 2007-09-14 23:47:42Z ipso $
 * $Date: 2007-09-14 16:47:42 -0700 (Fri, 14 Sep 2007) $
 */
require_once('../../includes/global.inc.php');
require_once(Environment::getBasePath() .'includes/Interface.inc.php');

if ( !$permission->Check('accrual','enabled')
		OR !( $permission->Check('accrual','edit') OR $permission->Check('accrual','edit_own') OR $permission->Check('accrual','edit_child') ) ) {
	$permission->Redirect( FALSE ); //Redirect
}

//Debug::setVerbosity( 11 );

$smarty->assign('title', TTi18n::gettext($title = 'Edit Accrual')); // See index.php

/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'id',
												'user_id',
												'filter_user_id',
												'accrual_policy_id',
												'data'
												) ) );

if ( isset($data) ) {
	$data['time_stamp'] = TTDate::parseDateTime($data['time_stamp']);
	$data['amount'] = TTDate::parseTimeUnit( $data['amount'] );
}

$af = new AccrualFactory();

$action = Misc::findSubmitButton();
$action = strtolower($action);
switch ($action) {
	case 'submit':
		Debug::Text('Submit!', __FILE__, __LINE__, __METHOD__,10);

		$af->setId( $data['id'] );
		$af->setUser( $data['user_id'] );
		$af->setType( $data['type_id'] );
		$af->setAccrualPolicyID( $data['accrual_policy_id'] );
		$af->setAmount( $data['amount'] );
		$af->setTimeStamp( $data['time_stamp'] );
		$af->setEnableCalcBalance( TRUE );

		if ( $af->isValid() ) {
			$af->Save();

			Redirect::Page( URLBuilder::getURL( array('filter_user_id' => $data['user_id']) , 'UserAccrualBalanceList.php') );

			break;
		}

	default:
		if ( isset($id) ) {
			BreadCrumb::setCrumb($title);

			$alf = new AccrualListFactory();
			$alf->getById($id);

			foreach ($alf as $a_obj) {
				//Debug::Arr($station,'Department', __FILE__, __LINE__, __METHOD__,10);

				$data = array(
									'id' => $a_obj->getId(),
									'user_id' => $a_obj->getUser(),
									'accrual_policy_id' => $a_obj->getAccrualPolicyID(),
									'type_id' => $a_obj->getType(),
									'amount' => $a_obj->getAmount(),
									'time_stamp' => $a_obj->getTimeStamp(),
									'user_date_total_id' => $a_obj->getUserDateTotalID(),
									'created_date' => $a_obj->getCreatedDate(),
									'created_by' => $a_obj->getCreatedBy(),
									'updated_date' => $a_obj->getUpdatedDate(),
									'updated_by' => $a_obj->getUpdatedBy(),
									'deleted_date' => $a_obj->getDeletedDate(),
									'deleted_by' => $a_obj->getDeletedBy()
								);
			}
		} elseif ( $action != 'submit' ) {
			if ( $user_id == '' ) {
				$user_id = $filter_user_id;
			}
			$data = array(
						'user_id' => $user_id,
						'accrual_policy_id' => $accrual_policy_id,
						'amount' => 0,
						'time_stamp' => TTDate::getTime()
						);
		}

		$aplf = new AccrualPolicyListFactory();
		$accrual_options = $aplf->getByCompanyIDArray( $current_company->getId(), TRUE );

		$ulf = new UserListFactory();
		$user_options = $ulf->getByCompanyIDArray( $current_company->getId(), TRUE );

		//Select box options;
		$data['type_options'] = $af->getOptions('type');
		$data['user_options'] = $user_options;
		$data['accrual_policy_options'] = $accrual_options;

		$smarty->assign_by_ref('data', $data);

		break;
}

$smarty->assign_by_ref('af', $af);

$smarty->display('accrual/EditUserAccrual.tpl');
?>