<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1969 $
 * $Id: EditAbsencePolicy.php 1969 2008-07-10 14:55:56Z ipso $
 * $Date: 2008-07-10 07:55:56 -0700 (Thu, 10 Jul 2008) $
 */
require_once('../../includes/global.inc.php');
require_once(Environment::getBasePath() .'includes/Interface.inc.php');

if ( !$permission->Check('absence_policy','enabled')
		OR !( $permission->Check('absence_policy','edit') OR $permission->Check('absence_policy','edit_own') ) ) {

	$permission->Redirect( FALSE ); //Redirect

}

$smarty->assign('title', TTi18n::gettext($title = 'Edit Absence Policy')); // See index.php

/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'id',
												'data'
												) ) );

$apf = new AbsencePolicyFactory();

$action = Misc::findSubmitButton();
$action = strtolower($action);
switch ($action) {
	case 'submit':
		Debug::Text('Submit!', __FILE__, __LINE__, __METHOD__,10);

		$apf->setId( $data['id'] );
		$apf->setCompany( $current_company->getId() );
		$apf->setName( $data['name'] );
		$apf->setType( $data['type_id'] );
		$apf->setAccrualPolicyID( $data['accrual_policy_id'] );
		$apf->setPayStubEntryAccountID( $data['pay_stub_entry_account_id'] );

		if ( $apf->isValid() ) {
			$apf->Save();

			Redirect::Page( URLBuilder::getURL( NULL, 'AbsencePolicyList.php') );

			break;
		}

	default:
		if ( isset($id) ) {
			BreadCrumb::setCrumb($title);

			$aplf = new AbsencePolicyListFactory();
			$aplf->getById($id);

			foreach ($aplf as $ap_obj) {
				//Debug::Arr($station,'Department', __FILE__, __LINE__, __METHOD__,10);

				$data = array(
									'id' => $ap_obj->getId(),
									'name' => $ap_obj->getName(),
									'type_id' => $ap_obj->getType(),
									'accrual_policy_id' => $ap_obj->getAccrualPolicyID(),
									'pay_stub_entry_account_id' => $ap_obj->getPayStubEntryAccountID(),
									'created_date' => $ap_obj->getCreatedDate(),
									'created_by' => $ap_obj->getCreatedBy(),
									'updated_date' => $ap_obj->getUpdatedDate(),
									'updated_by' => $ap_obj->getUpdatedBy(),
									'deleted_date' => $ap_obj->getDeletedDate(),
									'deleted_by' => $ap_obj->getDeletedBy()
								);
			}
		}

		$aplf = new AccrualPolicyListFactory();
		$accrual_options = $aplf->getByCompanyIDArray( $current_company->getId(), TRUE );

		$psealf = new PayStubEntryAccountListFactory();
		$pay_stub_entry_options = $psealf->getByCompanyIdAndStatusIdAndTypeIdArray( $current_company->getId(), 10, array(10,20,30,50) );

		//Select box options;
		$data['type_options'] = $apf->getOptions('type');
		$data['accrual_options'] = $accrual_options;
		$data['pay_stub_entry_options'] = $pay_stub_entry_options;

		$smarty->assign_by_ref('data', $data);

		break;
}

$smarty->assign_by_ref('apf', $apf);

$smarty->display('policy/EditAbsencePolicy.tpl');
?>