<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1246 $
 * $Id: EditRoundIntervalPolicy.php 1246 2007-09-14 23:47:42Z ipso $
 * $Date: 2007-09-14 16:47:42 -0700 (Fri, 14 Sep 2007) $
 */
require_once('../../includes/global.inc.php');
require_once(Environment::getBasePath() .'includes/Interface.inc.php');

if ( !$permission->Check('round_policy','enabled')
		OR !( $permission->Check('round_policy','edit') OR $permission->Check('round_policy','edit_own') ) ) {

	$permission->Redirect( FALSE ); //Redirect

}

$smarty->assign('title', TTi18n::gettext($title = 'Edit Rounding Policy')); // See index.php

/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'id',
												'data'
												) ) );

if ( isset($data['interval'] ) ) {
	$data['interval'] = TTDate::parseTimeUnit($data['interval']);
	$data['grace'] = TTDate::parseTimeUnit($data['grace']);
}


$ripf = new RoundIntervalPolicyFactory();

$action = Misc::findSubmitButton();
$action = strtolower($action);
switch ($action) {
	case 'submit':
		Debug::Text('Submit!', __FILE__, __LINE__, __METHOD__,10);

		$ripf->setId( $data['id'] );
		$ripf->setCompany( $current_company->getId() );
		$ripf->setName( $data['name'] );
		$ripf->setPunchType( $data['punch_type_id'] );
		$ripf->setRoundType( $data['round_type_id'] );
		$ripf->setInterval( $data['interval'] );
		$ripf->setGrace( $data['grace'] );
		if ( isset($data['strict'] ) ) {
			$ripf->setStrict( TRUE );
		} else {
			$ripf->setStrict( FALSE );
		}

		if ( $ripf->isValid() ) {
			$ripf->Save();

			Redirect::Page( URLBuilder::getURL( NULL, 'RoundIntervalPolicyList.php') );

			break;
		}

	default:
		if ( isset($id) ) {
			BreadCrumb::setCrumb($title);

			$riplf = new RoundIntervalPolicyListFactory();
			$riplf->getById($id);

			foreach ($riplf as $rip_obj) {
				//Debug::Arr($station,'Department', __FILE__, __LINE__, __METHOD__,10);

				$data = array(
									'id' => $rip_obj->getId(),
									'name' => $rip_obj->getName(),
									'punch_type_id' => $rip_obj->getPunchType(),
									'round_type_id' => $rip_obj->getRoundType(),
									'interval' => $rip_obj->getInterval(),
									'grace' => $rip_obj->getGrace(),
									'strict' => $rip_obj->getStrict(),
									'created_date' => $rip_obj->getCreatedDate(),
									'created_by' => $rip_obj->getCreatedBy(),
									'updated_date' => $rip_obj->getUpdatedDate(),
									'updated_by' => $rip_obj->getUpdatedBy(),
									'deleted_date' => $rip_obj->getDeletedDate(),
									'deleted_by' => $rip_obj->getDeletedBy()
								);
			}
		} elseif ( $action != 'submit' ) {
			$data = array(
							'interval' => 900,
							'grace' => 0
							);
		}

		//Select box options;
		$data['punch_type_options'] = $ripf->getOptions('punch_type');
		$data['round_type_options'] = $ripf->getOptions('round_type');

		$smarty->assign_by_ref('data', $data);

		break;
}

$smarty->assign_by_ref('ripf', $ripf);

$smarty->display('policy/EditRoundIntervalPolicy.tpl');
?>