/* valaobjecttypesymbol.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 * Copyright (C) 2008  Philip Van Hoof
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Philip Van Hoof <pvanhoof@gnome.org>
 */

#ifndef __VALA_VALAOBJECTTYPESYMBOL_H__
#define __VALA_VALAOBJECTTYPESYMBOL_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee/list.h>
#include <vala/valatypesymbol.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_OBJECT_TYPE_SYMBOL (vala_object_type_symbol_get_type ())
#define VALA_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))
#define VALA_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))
#define VALA_IS_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_IS_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_OBJECT_TYPE_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))

typedef struct _ValaObjectTypeSymbolPrivate ValaObjectTypeSymbolPrivate;

/**
 * Represents a runtime data type for objects and interfaces. This data type may
 * be defined in Vala source code or imported from an external library with a 
 * Vala API file.
 */
struct _ValaObjectTypeSymbol {
	ValaTypeSymbol parent_instance;
	ValaObjectTypeSymbolPrivate * priv;
};

struct _ValaObjectTypeSymbolClass {
	ValaTypeSymbolClass parent_class;
	GeeList* (*get_methods) (ValaObjectTypeSymbol* self);
	GeeList* (*get_signals) (ValaObjectTypeSymbol* self);
	GeeList* (*get_properties) (ValaObjectTypeSymbol* self);
};


ValaObjectTypeSymbol* vala_object_type_symbol_construct (GType object_type, const char* name, ValaSourceReference* source_reference);
ValaObjectTypeSymbol* vala_object_type_symbol_new (const char* name, ValaSourceReference* source_reference);
GeeList* vala_object_type_symbol_get_methods (ValaObjectTypeSymbol* self);
GeeList* vala_object_type_symbol_get_signals (ValaObjectTypeSymbol* self);
GeeList* vala_object_type_symbol_get_properties (ValaObjectTypeSymbol* self);
void vala_object_type_symbol_add_type_parameter (ValaObjectTypeSymbol* self, ValaTypeParameter* p);
GeeList* vala_object_type_symbol_get_type_parameters (ValaObjectTypeSymbol* self);
GType vala_object_type_symbol_get_type (void);


G_END_DECLS

#endif
