# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.

from elisa.core.tests.elisa_test_case import ElisaTestCase
from elisa.core.utils import dist

from distutils.errors import DistutilsSetupError


class TestDist(ElisaTestCase):

    def test_assert_list_of_string_tuples_or_none(self):
        # Test None
        assert_none = dist.assert_list_of_string_tuples_or_none(None, None,
                                                                None)
        self.failUnlessEqual(assert_none, None)
        # Test a valid list of tuples of strings
        strings = [tuple(map(str, range(i))) for i in range(10)]
        assert_strings = dist.assert_list_of_string_tuples_or_none(None, None,
                                                                   strings)
        self.failUnlessEqual(assert_strings, None)
        # Test an invalid list
        self.failUnlessRaises(DistutilsSetupError,
                              dist.assert_list_of_string_tuples_or_none,
                              None, None, range(10))
