/*
 * Decompiled with CFR 0.152.
 */
package clojure.asm.commons;

import clojure.asm.Label;
import clojure.asm.MethodAdapter;
import clojure.asm.MethodVisitor;
import clojure.asm.Opcodes;
import clojure.asm.Type;

public class LocalVariablesSorter
extends MethodAdapter {
    private static final Type OBJECT_TYPE = Type.getObjectType("java/lang/Object");
    private int[] mapping = new int[40];
    private Object[] newLocals = new Object[20];
    protected final int firstLocal;
    protected int nextLocal;
    private boolean changed;

    public LocalVariablesSorter(int access, String desc, MethodVisitor mv) {
        super(mv);
        Type[] args = Type.getArgumentTypes(desc);
        this.nextLocal = (8 & access) != 0 ? 0 : 1;
        for (int i = 0; i < args.length; ++i) {
            this.nextLocal += args[i].getSize();
        }
        this.firstLocal = this.nextLocal;
    }

    public void visitVarInsn(int opcode, int var) {
        Type type2;
        switch (opcode) {
            case 22: 
            case 55: {
                type2 = Type.LONG_TYPE;
                break;
            }
            case 24: 
            case 57: {
                type2 = Type.DOUBLE_TYPE;
                break;
            }
            case 23: 
            case 56: {
                type2 = Type.FLOAT_TYPE;
                break;
            }
            case 21: 
            case 54: {
                type2 = Type.INT_TYPE;
                break;
            }
            case 25: 
            case 58: {
                type2 = OBJECT_TYPE;
                break;
            }
            default: {
                type2 = Type.VOID_TYPE;
            }
        }
        this.mv.visitVarInsn(opcode, this.remap(var, type2));
    }

    public void visitIincInsn(int var, int increment) {
        this.mv.visitIincInsn(this.remap(var, Type.INT_TYPE), increment);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        this.mv.visitMaxs(maxStack, this.nextLocal);
    }

    public void visitLocalVariable(String name2, String desc, String signature, Label start, Label end, int index2) {
        int size = "J".equals(desc) || "D".equals(desc) ? 2 : 1;
        int newIndex = this.remap(index2, size);
        this.mv.visitLocalVariable(name2, desc, signature, start, end, newIndex);
    }

    public void visitFrame(int type2, int nLocal, Object[] local, int nStack, Object[] stack) {
        int number;
        if (type2 != -1) {
            throw new IllegalStateException("ClassReader.accept() should be called with EXPAND_FRAMES flag");
        }
        if (!this.changed) {
            this.mv.visitFrame(type2, nLocal, local, nStack, stack);
            return;
        }
        Object[] oldLocals = new Object[this.newLocals.length];
        System.arraycopy(this.newLocals, 0, oldLocals, 0, oldLocals.length);
        int index2 = 0;
        for (number = 0; number < nLocal; ++number) {
            int size;
            Object t = local[number];
            int n = size = t == Opcodes.LONG || t == Opcodes.DOUBLE ? 2 : 1;
            if (t != Opcodes.TOP) {
                this.setFrameLocal(this.remap(index2, size), t);
            }
            index2 += size;
        }
        index2 = 0;
        number = 0;
        int i = 0;
        while (index2 < this.newLocals.length) {
            Object t;
            if ((t = this.newLocals[index2++]) != null && t != Opcodes.TOP) {
                this.newLocals[i] = t;
                number = i + 1;
                if (t == Opcodes.LONG || t == Opcodes.DOUBLE) {
                    ++index2;
                }
            } else {
                this.newLocals[i] = Opcodes.TOP;
            }
            ++i;
        }
        this.mv.visitFrame(type2, number, this.newLocals, nStack, stack);
        this.newLocals = oldLocals;
    }

    public int newLocal(Type type2) {
        Object t;
        switch (type2.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                t = Opcodes.INTEGER;
                break;
            }
            case 6: {
                t = Opcodes.FLOAT;
                break;
            }
            case 7: {
                t = Opcodes.LONG;
                break;
            }
            case 8: {
                t = Opcodes.DOUBLE;
                break;
            }
            case 9: {
                t = type2.getDescriptor();
                break;
            }
            default: {
                t = type2.getInternalName();
            }
        }
        int local = this.nextLocal;
        this.setLocalType(local, type2);
        this.setFrameLocal(local, t);
        this.nextLocal += type2.getSize();
        return local;
    }

    protected void setLocalType(int local, Type type2) {
    }

    private void setFrameLocal(int local, Object type2) {
        int l = this.newLocals.length;
        if (local >= l) {
            Object[] a = new Object[Math.max(2 * l, local + 1)];
            System.arraycopy(this.newLocals, 0, a, 0, l);
            this.newLocals = a;
        }
        this.newLocals[local] = type2;
    }

    private int remap(int var, Type type2) {
        int value;
        int size;
        if (var < this.firstLocal) {
            return var;
        }
        int key2 = 2 * var + type2.getSize() - 1;
        if (key2 >= (size = this.mapping.length)) {
            int[] newMapping = new int[Math.max(2 * size, key2 + 1)];
            System.arraycopy(this.mapping, 0, newMapping, 0, size);
            this.mapping = newMapping;
        }
        if ((value = this.mapping[key2]) == 0) {
            this.mapping[key2] = value = this.nextLocal + 1;
            this.setLocalType(this.nextLocal, type2);
            this.nextLocal += type2.getSize();
        }
        if (value - 1 != var) {
            this.changed = true;
        }
        return value - 1;
    }

    private int remap(int var, int size) {
        int value;
        if (var < this.firstLocal || !this.changed) {
            return var;
        }
        int key2 = 2 * var + size - 1;
        int n = value = key2 < this.mapping.length ? this.mapping[key2] : 0;
        if (value == 0) {
            throw new IllegalStateException("Unknown local variable " + var);
        }
        return value - 1;
    }
}

