/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.varparser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.epic.debug.PerlDebugPlugin;
import org.epic.debug.varparser.PerlDebugValue;
import org.epic.debug.varparser.PerlDebugVar;

public class TokenVarParser {
    private final IDebugTarget target;
    private final Stack varStack;
    private final HashMap varMap;
    private final ILog log;
    private int scope;
    private int pos;
    private List vars;
    private char[] chars;

    public TokenVarParser(IDebugTarget target, ILog log) {
        this.target = target;
        this.log = log;
        this.varStack = new Stack();
        this.varMap = new HashMap();
    }

    public List parseVars(String text, int scope) {
        return this.parseVars(text, scope, new ArrayList());
    }

    public List parseVars(String text, int scope, List vars) {
        this.reset(text, scope, vars);
        this.readVars();
        return vars;
    }

    private void addVar(String name, String value) {
        PerlDebugVar var = new PerlDebugVar(this.target, this.scope, name, new PerlDebugValue(this.target, " ", value));
        if (!this.varStack.empty()) {
            ((PerlDebugVar)((Object)this.varStack.peek())).getPdValue().addVar(var);
        }
        this.varStack.push(var);
        int pos = value.indexOf(41);
        if (pos > 0) {
            this.varMap.put(value.substring(0, pos + 1), var);
        }
    }

    private void linkVar(String name, String value) throws ParseException {
        try {
            PerlDebugValue val;
            PerlDebugVar referencedVar = (PerlDebugVar)((Object)this.varMap.get(value));
            if (referencedVar == null && value.startsWith("REF") && value.indexOf("-> ") != -1) {
                value = value.substring(value.indexOf("-> ") + 3);
                referencedVar = (PerlDebugVar)((Object)this.varMap.get(value));
            }
            if (referencedVar != null) {
                PerlDebugValue referencedVal = referencedVar.getPdValue();
                val = new PerlDebugValue(this.target, " ", referencedVal.getValueString());
            } else {
                this.log.log((IStatus)new Status(2, PerlDebugPlugin.getUniqueIdentifier(), 0, "Unresolved reference {" + value + "} for variable {" + name + "}. " + "Contents of the Variables view may be inaccurate. ", null));
                val = new PerlDebugValue(this.target, " ", "<unresolved reference>");
            }
            PerlDebugVar var = new PerlDebugVar(this.target, this.scope, name, val);
            if (!this.varStack.empty()) {
                ((PerlDebugVar)((Object)this.varStack.peek())).getPdValue().addVar(var);
            }
            this.varStack.push(var);
        }
        catch (DebugException e) {
            throw new ParseException("linkVar failed for name={" + name + "}, value={" + value + "}", true, e);
        }
    }

    private String readString() throws ParseException {
        if (this.chars[this.pos] != 'S') {
            throw new ParseException("expected token S missing @" + this.pos, true);
        }
        try {
            ++this.pos;
            String temp = new String(this.chars, this.pos, 8);
            int length = Integer.parseInt(temp, 16);
            this.pos += 8;
            temp = new String(this.chars, this.pos, length);
            this.pos += length;
            return temp;
        }
        catch (Exception e) {
            throw new ParseException("could not parse string @" + this.pos, true, e);
        }
    }

    private String readStrings() throws ParseException {
        StringBuffer buf = new StringBuffer(this.readString());
        while (this.pos < this.chars.length && this.chars[this.pos] == 'S') {
            buf.append(this.readString());
        }
        return buf.toString();
    }

    private boolean readVar() throws ParseException {
        if (this.pos >= this.chars.length) {
            throw new ParseException("unexpected end of stream", false);
        }
        if (this.chars[this.pos] == 'E') {
            return false;
        }
        if (this.chars[this.pos] != 'N') {
            throw new ParseException("expected token N missing @" + this.pos, true);
        }
        ++this.pos;
        String name = this.readString();
        String value = this.readStrings();
        if (this.chars[this.pos] == 'R') {
            ++this.pos;
            this.linkVar(name, value);
        } else {
            this.addVar(name, value);
        }
        if (this.chars[this.pos] == 'I') {
            ++this.pos;
            this.readVars();
        }
        PerlDebugVar var = (PerlDebugVar)((Object)this.varStack.pop());
        if (this.varStack.empty()) {
            this.vars.add(var);
        }
        if (this.chars[this.pos] == 'O') {
            ++this.pos;
            return false;
        }
        return true;
    }

    private void readVars() {
        while (true) {
            boolean hasErrors = false;
            try {
                if (this.readVar()) continue;
            }
            catch (ParseException e) {
                if (!hasErrors) {
                    hasErrors = true;
                    this.log.log((IStatus)new Status(4, PerlDebugPlugin.getUniqueIdentifier(), 0, "An error occurred while parsing debugger variables; contents of the Variables view may be inaccurate. Failure caused by string: {" + String.valueOf(this.chars) + "}", (Throwable)e));
                }
                if (!e.canRecover()) break;
                this.recover();
                continue;
            }
            break;
        }
    }

    private void recover() {
        while (this.pos < this.chars.length && this.chars[this.pos] != 'N' && this.chars[this.pos] != 'E') {
            ++this.pos;
        }
    }

    private void reset(String text, int scope, List vars) {
        this.varMap.clear();
        this.varStack.clear();
        this.chars = text.toCharArray();
        this.scope = scope;
        this.vars = vars;
        this.pos = 0;
    }

    private static class ParseException
    extends Exception {
        private final boolean canRecover;

        public ParseException(String msg, boolean canRecover) {
            this(msg, canRecover, null);
        }

        public ParseException(String msg, boolean canRecover, Throwable cause) {
            super(msg, cause);
            this.canRecover = canRecover;
        }

        public boolean canRecover() {
            return this.canRecover;
        }
    }
}

