/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.repository.vfs;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.params.HttpParams;

class IvyWebdavConnectionManager
implements HttpConnectionManager {
    protected ThreadLocal localHttpConnection = new ThreadLocal(){

        protected Object initialValue() {
            return new Entry();
        }
    };
    private HttpConnectionManagerParams params = new HttpConnectionManagerParams();

    static void finishLastResponse(HttpConnection conn) {
        InputStream lastResponse = conn.getLastResponseInputStream();
        if (lastResponse != null) {
            conn.setLastResponseInputStream(null);
            try {
                lastResponse.close();
            }
            catch (IOException ioe) {
                conn.close();
            }
        }
    }

    public void releaseLocalConnection() {
        if (this.getLocalHttpConnection() != null) {
            this.releaseConnection(this.getLocalHttpConnection());
        }
    }

    protected HttpConnection getLocalHttpConnection() {
        return ((Entry)this.localHttpConnection.get()).conn;
    }

    protected void setLocalHttpConnection(HttpConnection conn) {
        ((Entry)this.localHttpConnection.get()).conn = conn;
    }

    protected long getIdleStartTime() {
        return ((Entry)this.localHttpConnection.get()).idleStartTime;
    }

    protected void setIdleStartTime(long idleStartTime) {
        ((Entry)this.localHttpConnection.get()).idleStartTime = idleStartTime;
    }

    public HttpConnection getConnection(HostConfiguration hostConfiguration) {
        return this.getConnection(hostConfiguration, 0L);
    }

    public boolean isConnectionStaleCheckingEnabled() {
        return this.params.isStaleCheckingEnabled();
    }

    public void setConnectionStaleCheckingEnabled(boolean connectionStaleCheckingEnabled) {
        this.params.setStaleCheckingEnabled(connectionStaleCheckingEnabled);
    }

    public HttpConnection getConnectionWithTimeout(HostConfiguration hostConfiguration, long timeout) {
        HttpConnection httpConnection = this.getLocalHttpConnection();
        if (httpConnection == null) {
            httpConnection = new HttpConnection(hostConfiguration);
            this.setLocalHttpConnection(httpConnection);
            httpConnection.setHttpConnectionManager((HttpConnectionManager)this);
            httpConnection.getParams().setDefaults((HttpParams)this.params);
        } else if (!hostConfiguration.hostEquals(httpConnection) || !hostConfiguration.proxyEquals(httpConnection)) {
            if (httpConnection.isOpen()) {
                httpConnection.close();
            }
            httpConnection.setHost(hostConfiguration.getHost());
            httpConnection.setPort(hostConfiguration.getPort());
            httpConnection.setProtocol(hostConfiguration.getProtocol());
            httpConnection.setLocalAddress(hostConfiguration.getLocalAddress());
            httpConnection.setProxyHost(hostConfiguration.getProxyHost());
            httpConnection.setProxyPort(hostConfiguration.getProxyPort());
        } else {
            IvyWebdavConnectionManager.finishLastResponse(httpConnection);
        }
        this.setIdleStartTime(Long.MAX_VALUE);
        return httpConnection;
    }

    public HttpConnection getConnection(HostConfiguration hostConfiguration, long timeout) {
        return this.getConnectionWithTimeout(hostConfiguration, timeout);
    }

    public void releaseConnection(HttpConnection conn) {
        if (conn != this.getLocalHttpConnection()) {
            throw new IllegalStateException("Unexpected release of an unknown connection.");
        }
        IvyWebdavConnectionManager.finishLastResponse(this.getLocalHttpConnection());
        this.setIdleStartTime(System.currentTimeMillis());
    }

    public void closeIdleConnections(long idleTimeout) {
        long maxIdleTime = System.currentTimeMillis() - idleTimeout;
        if (this.getIdleStartTime() <= maxIdleTime) {
            this.getLocalHttpConnection().close();
        }
    }

    public HttpConnectionManagerParams getParams() {
        return this.params;
    }

    public void setParams(HttpConnectionManagerParams params) {
        this.params = params;
    }

    private static class Entry {
        private HttpConnection conn = null;
        private long idleStartTime = Long.MAX_VALUE;

        private Entry() {
        }
    }
}

