/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.resourcesview;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.views.navigator.ResourceNavigator;
import org.eclipse.ui.views.navigator.ResourceNavigatorActionGroup;
import org.rubypeople.rdt.internal.ui.RubyViewerFilter;
import org.rubypeople.rdt.internal.ui.resourcesview.RubyFilterActionGroup;

public class RubyResourcesView
extends ResourceNavigator {
    private static String IS_RUBY_FILES_ONLY_MEMENTO_KEY = "isRubyFilesOnlyFilterActivated";
    private boolean isRubyFilesOnlyFilterActivated = false;

    public void createPartControl(Composite composite) {
        super.createPartControl(composite);
        RubyViewerFilter rubyViewerFilter = new RubyViewerFilter(this);
        this.getViewer().addFilter((ViewerFilter)rubyViewerFilter);
    }

    protected void makeActions() {
        this.setActionGroup((ResourceNavigatorActionGroup)new RubyFilterActionGroup(this));
    }

    protected void restoreRubyFilesOnlyFilterActivated(IMemento iMemento) {
        Integer n = iMemento.getInteger(IS_RUBY_FILES_ONLY_MEMENTO_KEY);
        if (n != null) {
            this.isRubyFilesOnlyFilterActivated = n == 1;
        }
    }

    public void saveState(IMemento iMemento) {
        super.saveState(iMemento);
        iMemento.putInteger(IS_RUBY_FILES_ONLY_MEMENTO_KEY, this.isRubyFilesOnlyFilterActivated ? 1 : 0);
    }

    public boolean isRubyFilesOnlyFilterActivated() {
        return this.isRubyFilesOnlyFilterActivated;
    }

    public void setRubyFilesOnlyFilterActivated(boolean bl) {
        this.isRubyFilesOnlyFilterActivated = bl;
    }

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        super.init(iViewSite, iMemento);
        if (iMemento != null) {
            this.restoreRubyFilesOnlyFilterActivated(iMemento);
        }
    }

    protected void editorActivated(IEditorPart iEditorPart) {
        IFileEditorInput iFileEditorInput;
        IFile iFile;
        if (!this.isLinkingEnabled()) {
            return;
        }
        IEditorInput iEditorInput = iEditorPart.getEditorInput();
        if (iEditorInput instanceof IFileEditorInput && (iFile = (iFileEditorInput = (IFileEditorInput)iEditorInput).getFile()) == null) {
            return;
        }
        super.editorActivated(iEditorPart);
    }
}

