/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.design.editparts;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDBaseAdapter;
import org.eclipse.wst.xsd.ui.internal.adt.design.IAnnotationProvider;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.BaseFieldEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.figures.IFieldFigure;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IField;
import org.eclipse.wst.xsd.ui.internal.common.util.XSDCommonUIUtils;
import org.eclipse.wst.xsd.ui.internal.design.editpolicies.DragAndDropEditPolicy;
import org.eclipse.wst.xsd.ui.internal.design.editpolicies.SelectionHandlesEditPolicyImpl;
import org.eclipse.xsd.XSDConcreteComponent;

public class XSDBaseFieldEditPart
extends BaseFieldEditPart {
    protected SelectionHandlesEditPolicyImpl selectionHandlesEditPolicy = new SelectionHandlesEditPolicyImpl();

    protected void refreshVisuals() {
        IFieldFigure figure = this.getFieldFigure();
        IField field = (IField)this.getModel();
        figure.getNameLabel().setText(field.getName());
        figure.getTypeLabel().setText(field.getTypeName());
        figure.refreshVisuals(this.getModel());
        if (field.isReadOnly()) {
            figure.setForegroundColor(ColorConstants.darkGray);
        } else {
            figure.setForegroundColor(ColorConstants.black);
        }
        String occurrenceDescription = "";
        if (field instanceof IAnnotationProvider) {
            occurrenceDescription = ((IAnnotationProvider)((Object)field)).getNameAnnotationString();
        }
        this.refreshIcon();
        figure.getNameAnnotationLabel().setText(occurrenceDescription);
        figure.recomputeLayout();
        if (this.getRoot() != null) {
            ((GraphicalEditPart)this.getRoot()).getFigure().invalidateTree();
        }
    }

    protected void refreshIcon() {
        IFieldFigure figure = this.getFieldFigure();
        if (this.getModel() instanceof XSDBaseAdapter) {
            Image image = ((XSDBaseAdapter)this.getModel()).getImage();
            boolean isReadOnly = ((XSDBaseAdapter)this.getModel()).isReadOnly();
            figure.getNameLabel().setIcon(image);
            if (image != null) {
                XSDConcreteComponent comp = (XSDConcreteComponent)((XSDBaseAdapter)this.getModel()).getTarget();
                figure.getNameLabel().setIcon(XSDCommonUIUtils.getUpdatedImage(comp, image, isReadOnly));
            }
        }
    }

    public void addNotify() {
        super.addNotify();
        this.getFieldFigure().editPartAttached((EditPart)this);
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("Selection Feedback", (EditPolicy)this.selectionHandlesEditPolicy);
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new DragAndDropEditPolicy(this.getViewer(), this.selectionHandlesEditPolicy));
    }
}

