/*
 * Decompiled with CFR 0.152.
 */
package org.uddi4j.datatype.business;

import java.util.Vector;
import org.uddi4j.UDDIElement;
import org.uddi4j.UDDIException;
import org.uddi4j.datatype.Description;
import org.uddi4j.datatype.business.Address;
import org.uddi4j.datatype.business.Email;
import org.uddi4j.datatype.business.PersonName;
import org.uddi4j.datatype.business.Phone;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Contact
extends UDDIElement {
    public static final String UDDI_TAG = "contact";
    protected Element base = null;
    String useType = null;
    PersonName personName = null;
    Vector description = new Vector();
    Vector phone = new Vector();
    Vector email = new Vector();
    Vector address = new Vector();

    public Contact() {
    }

    public Contact(String personName) {
        this.personName = new PersonName(personName);
    }

    public Contact(Element base) throws UDDIException {
        super(base);
        int i;
        this.useType = this.getAttr(base, "useType");
        NodeList nl = null;
        nl = this.getChildElementsByTagName(base, "personName");
        if (nl.getLength() > 0) {
            this.personName = new PersonName((Element)nl.item(0));
        }
        nl = this.getChildElementsByTagName(base, "description");
        for (i = 0; i < nl.getLength(); ++i) {
            this.description.addElement(new Description((Element)nl.item(i)));
        }
        nl = this.getChildElementsByTagName(base, "phone");
        for (i = 0; i < nl.getLength(); ++i) {
            this.phone.addElement(new Phone((Element)nl.item(i)));
        }
        nl = this.getChildElementsByTagName(base, "email");
        for (i = 0; i < nl.getLength(); ++i) {
            this.email.addElement(new Email((Element)nl.item(i)));
        }
        nl = this.getChildElementsByTagName(base, "address");
        for (i = 0; i < nl.getLength(); ++i) {
            this.address.addElement(new Address((Element)nl.item(i)));
        }
    }

    private String getAttr(Element base, String attrname) {
        if (base.getAttributeNode(attrname) != null && base.getAttributeNode(attrname).getSpecified()) {
            return base.getAttribute(attrname);
        }
        return null;
    }

    public void setUseType(String s) {
        this.useType = s;
    }

    public void setPersonName(PersonName s) {
        this.personName = s;
    }

    public void setPersonName(String s) {
        this.personName = new PersonName();
        this.personName.setText(s);
    }

    public void setDescriptionVector(Vector s) {
        this.description = s;
    }

    public void setDefaultDescriptionString(String s) {
        if (this.description.size() > 0) {
            this.description.setElementAt(new Description(s), 0);
        } else {
            this.description.addElement(new Description(s));
        }
    }

    public void setPhoneVector(Vector s) {
        this.phone = s;
    }

    public void setEmailVector(Vector s) {
        this.email = s;
    }

    public void setAddressVector(Vector s) {
        this.address = s;
    }

    public String getUseType() {
        return this.useType;
    }

    public PersonName getPersonName() {
        return this.personName;
    }

    public String getPersonNameString() {
        return this.personName.getText();
    }

    public Vector getDescriptionVector() {
        return this.description;
    }

    public String getDefaultDescriptionString() {
        if (this.description.size() > 0) {
            Description t = (Description)this.description.elementAt(0);
            return t.getText();
        }
        return null;
    }

    public Vector getPhoneVector() {
        return this.phone;
    }

    public Vector getEmailVector() {
        return this.email;
    }

    public Vector getAddressVector() {
        return this.address;
    }

    public void saveToXML(Element parent) {
        int i;
        this.base = parent.getOwnerDocument().createElementNS(UDDIElement.XMLNS, UDDIElement.XMLNS_PREFIX + UDDI_TAG);
        if (this.useType != null) {
            this.base.setAttribute("useType", this.useType);
        }
        if (this.description != null) {
            for (i = 0; i < this.description.size(); ++i) {
                ((Description)this.description.elementAt(i)).saveToXML(this.base);
            }
        }
        if (this.personName != null) {
            this.personName.saveToXML(this.base);
        }
        if (this.phone != null) {
            for (i = 0; i < this.phone.size(); ++i) {
                ((Phone)this.phone.elementAt(i)).saveToXML(this.base);
            }
        }
        if (this.email != null) {
            for (i = 0; i < this.email.size(); ++i) {
                ((Email)this.email.elementAt(i)).saveToXML(this.base);
            }
        }
        if (this.address != null) {
            for (i = 0; i < this.address.size(); ++i) {
                ((Address)this.address.elementAt(i)).saveToXML(this.base);
            }
        }
        parent.appendChild(this.base);
    }
}

