/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.commands;

import java.util.Iterator;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Types;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.XSDSchemaExtensibilityElement;
import org.eclipse.wst.wsdl.ui.internal.commands.AddTypesCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.AddXSDSchemaCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.WSDLElementCommand;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;

public final class AddXSDTypeDefinitionCommand
extends WSDLElementCommand {
    private Definition definition;
    private String targetNamespace;
    private String typeName;
    private XSDSchema schema;
    private XSDTypeDefinition xsdType;
    private boolean isComplexType = true;

    public AddXSDTypeDefinitionCommand(Definition definition, String typeName) {
        this.definition = definition;
        this.targetNamespace = definition.getTargetNamespace();
        this.typeName = typeName;
    }

    public AddXSDTypeDefinitionCommand(Definition definition, String typeName, boolean isComplexType) {
        this(definition, typeName);
        this.isComplexType = isComplexType;
    }

    public AddXSDTypeDefinitionCommand(Definition definition, String targetNamespace, String typeName) {
        this.definition = definition;
        this.targetNamespace = targetNamespace;
        this.typeName = typeName;
    }

    public void run() {
        XSDSchema xsdSchema = this.getSchema();
        Object typeDef = this.isComplexType ? XSDFactory.eINSTANCE.createXSDComplexTypeDefinition() : XSDFactory.eINSTANCE.createXSDSimpleTypeDefinition();
        typeDef.setName(this.typeName);
        xsdSchema.getContents().add(typeDef);
        this.xsdType = typeDef;
    }

    public void run(String newTypeName) {
        this.typeName = newTypeName;
        this.run();
    }

    public void isComplexType(boolean isComplexType) {
        this.isComplexType = isComplexType;
    }

    public void setSchema(XSDSchema schema) {
        this.schema = schema;
    }

    public XSDSchema getSchema() {
        if (this.schema == null) {
            return this.getXSDSchema(this.targetNamespace);
        }
        return this.schema;
    }

    private XSDSchema getXSDSchema(String targetNamespace) {
        Iterator iterator = this.getTypes().getSchemas(targetNamespace).iterator();
        if (iterator.hasNext()) {
            XSDSchema xsdSchema = (XSDSchema)iterator.next();
            return xsdSchema;
        }
        AddXSDSchemaCommand command = new AddXSDSchemaCommand(this.definition, targetNamespace);
        command.run();
        return ((XSDSchemaExtensibilityElement)command.getWSDLElement()).getSchema();
    }

    private Types getTypes() {
        Types types = (Types)this.definition.getTypes();
        if (types != null) {
            return types;
        }
        AddTypesCommand command = new AddTypesCommand(this.definition);
        command.run();
        return (Types)command.getWSDLElement();
    }

    public WSDLElement getWSDLElement() {
        return null;
    }

    public XSDTypeDefinition getXSDElement() {
        return this.xsdType;
    }
}

