/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.emf.event.impl;

import com.ibm.etools.emf.event.Event;
import com.ibm.etools.emf.event.FeatureKind;
import com.ibm.etools.emf.event.NotifierKind;
import com.ibm.etools.emf.event.impl.EventAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

public abstract class EventHelper {
    public static final String copyright = "(c) Copyright IBM Corporation 2001.";
    Notifier topNotifier;
    ResourceSet defaultResourceSet;
    static final String EVENT_ID_PREFIX = "event:";

    protected EventHelper(Notifier topNotifier, ResourceSet defaultResourceSet) {
        this.topNotifier = topNotifier;
        this.defaultResourceSet = defaultResourceSet;
    }

    protected Notifier getTopNotifier() {
        return this.topNotifier;
    }

    protected boolean isContainedInTopNotifier(EObject eObj) {
        if (this.topNotifier instanceof EObject) {
            return EcoreUtil.isAncestor((EObject)((EObject)this.topNotifier), (EObject)eObj);
        }
        return EcoreUtil.isAncestor((Resource)((Resource)this.topNotifier), (EObject)eObj);
    }

    protected EObject getEObjectFromURI(String id) {
        if (id == null || id.length() == 0) {
            return null;
        }
        int index = id.indexOf("#");
        if (index == -1) {
            return null;
        }
        if (index == 0) {
            if (this.topNotifier instanceof Resource) {
                Resource r = (Resource)this.topNotifier;
                return r.getEObject(id.substring(index + 1));
            }
            EObject obj = this.getEObject(id.substring(index + 1));
            return obj;
        }
        URI uri = URI.createURI((String)id.substring(0, index));
        Resource res = this.defaultResourceSet.getResource(uri, true);
        if (res != null) {
            EObject obj = res.getEObject(id.substring(index + 1));
            return obj;
        }
        return null;
    }

    public FeatureKind getFeatureKind(Event e) {
        if (this.getNotifierKind(e) == NotifierKind.RESOURCE_LITERAL) {
            return FeatureKind.REFERENCE_LITERAL;
        }
        EStructuralFeature f = this.getFeature(e);
        if (f instanceof EAttribute) {
            return FeatureKind.ATTRIBUTE_LITERAL;
        }
        return FeatureKind.REFERENCE_LITERAL;
    }

    public Notifier getNotifier(Event e) {
        if (e.getNotifierURI() == null || e.getNotifierURI().length() == 0) {
            return this.topNotifier;
        }
        return this.getEObjectFromURI(e.getNotifierURI());
    }

    public EStructuralFeature getFeature(Event e) {
        if (this.getNotifierKind(e) == NotifierKind.EOBJECT_LITERAL) {
            EClass c = ((EObject)this.getNotifier(e)).eClass();
            return c.getEStructuralFeature(e.getFeatureName());
        }
        return null;
    }

    public NotifierKind getNotifierKind(Event e) {
        String uri = e.getNotifierURI();
        if (uri == null || uri.length() == 0 || uri.indexOf("#") == -1) {
            return this.topNotifier instanceof Resource ? NotifierKind.RESOURCE_LITERAL : NotifierKind.EOBJECT_LITERAL;
        }
        return NotifierKind.EOBJECT_LITERAL;
    }

    protected static void copyAttributes(EObject target, EObject source) {
        EClass c2;
        EClass c1 = target.eClass();
        if (c1 != (c2 = source.eClass())) {
            return;
        }
        EList attributes = c1.getEAllAttributes();
        int a = 0;
        int size = attributes.size();
        while (a < size) {
            EAttribute attr = (EAttribute)attributes.get(a);
            if (source.eIsSet((EStructuralFeature)attr)) {
                if (attr.isMany()) {
                    EList lSource = (EList)source.eGet((EStructuralFeature)attr);
                    EList lTarget = (EList)target.eGet((EStructuralFeature)attr);
                    lTarget.clear();
                    lTarget.addAll((Collection)lSource);
                } else {
                    target.eSet((EStructuralFeature)attr, source.eGet((EStructuralFeature)attr));
                }
            } else if (!attr.isID()) {
                target.eUnset((EStructuralFeature)attr);
            }
            ++a;
        }
    }

    protected static boolean identicalAttributes(EObject o1, EObject o2) {
        EClass c2;
        if (o1 == null || o2 == null) {
            return o1 == o2;
        }
        EClass c1 = o1.eClass();
        if (c1 != (c2 = o2.eClass())) {
            return false;
        }
        EList attributes = c1.getEAllAttributes();
        int a = 0;
        int size = attributes.size();
        while (a < size) {
            EAttribute attr = (EAttribute)attributes.get(a);
            if (attr.isMany()) {
                EList l1 = (EList)o1.eGet((EStructuralFeature)attr);
                EList l2 = (EList)o2.eGet((EStructuralFeature)attr);
                if (l1.size() != l2.size()) {
                    return false;
                }
                int v = 0;
                while (v < l1.size()) {
                    if (l1.get(v) != l2.get(v)) {
                        return false;
                    }
                    ++v;
                }
            } else if (o1.eGet((EStructuralFeature)attr) != o2.eGet((EStructuralFeature)attr)) {
                return false;
            }
            ++a;
        }
        return true;
    }

    public EList getNotifierContents(Event e) {
        Notifier n = this.getNotifier(e);
        EList list = null;
        if (this.getNotifierKind(e) == NotifierKind.RESOURCE_LITERAL) {
            list = ((Resource)this.topNotifier).getContents();
        } else {
            EStructuralFeature f = this.getFeature(e);
            if (f.isMany()) {
                list = (EList)((EObject)n).eGet(f);
            }
        }
        return list;
    }

    protected boolean isEventId(String value) {
        return value.startsWith(EVENT_ID_PREFIX);
    }

    protected String removeResourceFromURIString(String value) {
        int index = value.indexOf("#");
        if (index != -1) {
            return value.substring(index, value.length());
        }
        return value;
    }

    public String getURIString(Object object) {
        if (object == null) {
            return null;
        }
        if (object.equals(this.topNotifier)) {
            if (object instanceof Resource) {
                return null;
            }
            return "#";
        }
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            if (!this.isContainedInTopNotifier(eObject)) {
                Resource r = eObject.eResource();
                return String.valueOf(r.getURI().toFileString()) + "#" + r.getURIFragment(eObject);
            }
            if (this.topNotifier instanceof Resource) {
                Resource r = (Resource)this.topNotifier;
                return "#" + r.getURIFragment(eObject);
            }
            return this.getURIFragment(eObject);
        }
        Resource r = (Resource)object;
        return r.getURI().toString();
    }

    public String getURIFragment(EObject eObject) {
        EObject topObject = eObject;
        ArrayList<String> uriFragmentPath = new ArrayList<String>();
        EObject container = topObject.eContainer();
        while (container != null) {
            uriFragmentPath.add(((InternalEObject)container).eURIFragmentSegment((EStructuralFeature)topObject.eContainmentFeature(), topObject));
            topObject = container;
            container = topObject.eContainer();
        }
        Resource res = eObject.eResource();
        if (this.topNotifier.equals(topObject) || this.topNotifier.equals(res)) {
            StringBuffer result = new StringBuffer("#");
            if (this.topNotifier.equals(res)) {
                result.append('/');
                result.append(Integer.toString(res.getContents().indexOf((Object)topObject)));
            }
            ListIterator i = uriFragmentPath.listIterator(uriFragmentPath.size());
            while (i.hasPrevious()) {
                result.append('/');
                result.append((String)i.previous());
            }
            return result.toString();
        }
        String fragment = res.getURIFragment(eObject);
        String value = res.getURI().appendFragment(fragment).toString();
        return value;
    }

    public EObject getEObject(String uriFragment) {
        if (uriFragment.startsWith("//")) {
            ArrayList<String> uriFragmentPath = new ArrayList<String>();
            uriFragmentPath.add("");
            StringTokenizer stringTokenizer = new StringTokenizer(uriFragment.substring(2), "/");
            while (stringTokenizer.hasMoreTokens()) {
                uriFragmentPath.add(stringTokenizer.nextToken());
            }
            return this.getEObject(uriFragmentPath);
        }
        if (uriFragment.startsWith("/")) {
            ArrayList<String> uriFragmentPath = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(uriFragment, "/");
            while (stringTokenizer.hasMoreTokens()) {
                uriFragmentPath.add(stringTokenizer.nextToken());
            }
            return this.getEObject(uriFragmentPath);
        }
        return null;
    }

    protected EObject getEObject(List uriFragmentPath) {
        Iterator fragments = uriFragmentPath.iterator();
        EObject eObject = this.getEObjectForURIFragmentRootSegment(!fragments.hasNext() ? "" : (String)fragments.next());
        while (fragments.hasNext() && eObject != null) {
            eObject = ((InternalEObject)eObject).eObjectForURIFragmentSegment((String)fragments.next());
        }
        return eObject;
    }

    protected EObject getEObjectForURIFragmentRootSegment(String uriFragmentRootSegment) {
        if (this.topNotifier instanceof EObject) {
            return ((InternalEObject)this.topNotifier).eObjectForURIFragmentSegment(uriFragmentRootSegment);
        }
        Resource res = (Resource)this.topNotifier;
        int position = 0;
        if (uriFragmentRootSegment.length() > 0) {
            try {
                position = Integer.parseInt(uriFragmentRootSegment);
            }
            catch (NumberFormatException exception) {
                throw new WrappedException((Exception)exception);
            }
        }
        if (position < res.getContents().size()) {
            return (EObject)res.getContents().get(position);
        }
        return null;
    }

    public static String objectToString(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof EObject) {
            EObject eObj = (EObject)o;
            StringBuffer result = new StringBuffer();
            EClass c = eObj.eClass();
            EList attributes = c.getEAllAttributes();
            result.append(String.valueOf(o.getClass().getName()) + " (");
            boolean first = true;
            int a = 0;
            int size = attributes.size();
            while (a < size) {
                EAttribute attrib = (EAttribute)attributes.get(a);
                if (eObj.eIsSet((EStructuralFeature)attrib)) {
                    if (!first) {
                        result.append(", ");
                    }
                    first = false;
                    String aName = attrib.getName();
                    Object oVal = eObj.eGet((EStructuralFeature)attrib);
                    String aVal = oVal == null ? "null" : oVal.toString();
                    result.append(String.valueOf(aName) + ": " + aVal);
                }
                ++a;
            }
            result.append(")");
            return result.toString();
        }
        if (o instanceof EList) {
            EList list = (EList)o;
            StringBuffer result = new StringBuffer();
            result.append("[");
            boolean first = true;
            int i = 0;
            int size = list.size();
            while (i < size) {
                Object val = list.get(i);
                if (!first) {
                    result.append(", ");
                }
                first = false;
                result.append(EventHelper.objectToString(val));
                ++i;
            }
            result.append("]");
            return result.toString();
        }
        if (o instanceof Resource) {
            StringBuffer result = new StringBuffer();
            Resource r = (Resource)o;
            result.append(String.valueOf(r.getClass().getName()) + " uri='" + r.getURI() + "'");
            return result.toString();
        }
        return o.toString();
    }

    public EventAdapter getEventAdapter() {
        return (EventAdapter)EcoreUtil.getAdapter((List)this.topNotifier.eAdapters(), (Object)EventAdapter.EVENT_ADAPTER);
    }

    public void attachEventAdapter(List eventsList) {
        EventAdapter adapter = new EventAdapter(this.topNotifier, eventsList, this.defaultResourceSet);
        this.topNotifier.eAdapters().add((Object)adapter);
    }
}

