/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.server.internal.ui.explorer.actions.popup;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IConnectionNode;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IKnownConnectionNode;
import org.eclipse.wst.rdb.server.internal.ui.wizards.EditConnectionWizard;

/**
 * @author ledunnel
 */
public class EditConnectionAction extends AbstractAction
{
    private ISelection selection;
	
    protected void setSelection(ISelection selection)
    {
        this.selection = selection;
    }

    protected ISelection getSelection()
    {
        return this.selection;
    }

    public void run(IAction action)
    {
        EditConnectionWizard wizard = new EditConnectionWizard((IConnectionNode) ((IStructuredSelection) selection).getFirstElement());  
        WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), wizard);
        dialog.create();
        dialog.open();
    }
    
    public void selectionChanged (IAction action, ISelection sel)
	{
        if (sel instanceof IStructuredSelection && action != null)
        {
            if (((IStructuredSelection)sel).size() == 1)
            {
	            Object current = ((IStructuredSelection)sel).getFirstElement();
	            if (current instanceof IKnownConnectionNode || current instanceof IConnectionNode && isDiscoveredConnection (current))
	            {
	                action.setEnabled(false);
	            }
	            else
	            {
	                action.setEnabled(true);
	            }
            }
            else
            {
                action.setEnabled(false);
            }
        }
		setSelection (sel);
	}
    
    private boolean isDiscoveredConnection(Object current)
    {
        IConnectionNode connectionNode = (IConnectionNode) current;
        return connectionNode.getConnectionInfo().isDiscoverDatabaseDefinitionWhenConnectEnabled();
    }
}
