/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings.specific;

import org.jcodings.IntHolder;
import org.jcodings.ascii.AsciiTables;
import org.jcodings.unicode.FixedWidthUnicodeEncoding;

public final class UTF32LEEncoding
extends FixedWidthUnicodeEncoding {
    public static UTF32LEEncoding INSTANCE = new UTF32LEEncoding();

    protected UTF32LEEncoding() {
        super("UTF-32LE", 4);
    }

    public boolean isNewLine(byte[] bytes2, int p2, int end2) {
        return p2 + 3 < end2 && bytes2[p2] == 10 && bytes2[p2 + 1] == 0 && bytes2[p2 + 2] == 0 && bytes2[p2 + 3] == 0;
    }

    public int mbcToCode(byte[] bytes2, int p2, int end2) {
        return (((bytes2[p2 + 3] & 0xFF) * 256 + (bytes2[p2 + 2] & 0xFF)) * 256 + (bytes2[p2 + 1] & 0xFF)) * 256 + (bytes2[p2] & 0xFF);
    }

    public int codeToMbc(int code, byte[] bytes2, int p2) {
        int p_ = p2;
        bytes2[p_++] = (byte)(code & 0xFF);
        bytes2[p_++] = (byte)((code & 0xFF00) >>> 8);
        bytes2[p_++] = (byte)((code & 0xFF0000) >>> 16);
        bytes2[p_++] = (byte)((code & 0xFF000000) >>> 24);
        return 4;
    }

    public int mbcCaseFold(int flag, byte[] bytes2, IntHolder pp, int end2, byte[] fold) {
        int p2 = pp.value;
        int foldP = 0;
        if (UTF32LEEncoding.isAscii(bytes2[p2] & 0xFF) && bytes2[p2 + 1] == 0 && bytes2[p2 + 2] == 0 && bytes2[p2 + 3] == 0) {
            fold[foldP++] = AsciiTables.ToLowerCaseTable[bytes2[p2] & 0xFF];
            fold[foldP++] = 0;
            fold[foldP++] = 0;
            fold[foldP] = 0;
            pp.value += 4;
            return 4;
        }
        return super.mbcCaseFold(flag, bytes2, pp, end2, fold);
    }
}

