/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyException;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.internal.runtime.ThreadService;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.backtrace.BacktraceData;
import org.jruby.runtime.backtrace.TraceType;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.NoFunctionalitySignalFacade;
import org.jruby.util.SignalFacade;

@JRubyModule(name={"Signal"})
public class RubySignal {
    private static final SignalFacade SIGNALS = RubySignal.getSignalFacade();
    public static final String[] NAMES = new String[]{"EXIT", "HUP", "INT", "QUIT", "ILL", "TRAP", "ABRT", "EMT", "FPE", "KILL", "BUS", "SEGV", "SYS", "PIPE", "ALRM", "TERM", "URG", "STOP", "TSTP", "CONT", "CHLD", "TTIN", "TTOU", "IO", "XCPU", "XFSZ", "VTALRM", "PROF", "WINCH", "INFO", "USR1", "USR2"};

    private static final SignalFacade getSignalFacade() {
        try {
            Class<?> realFacadeClass = Class.forName("org.jruby.util.SunSignalFacade");
            return (SignalFacade)realFacadeClass.newInstance();
        }
        catch (Throwable e) {
            return new NoFunctionalitySignalFacade();
        }
    }

    public static void createSignal(Ruby runtime2) {
        RubyModule mSignal = runtime2.defineModule("Signal");
        mSignal.defineAnnotatedMethods(RubySignal.class);
    }

    @JRubyMethod(required=1, optional=1, module=true)
    public static IRubyObject trap(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Ruby runtime2 = recv2.getRuntime();
        runtime2.getLoadService().require("jsignal_internal");
        return RuntimeHelpers.invoke(context, (IRubyObject)runtime2.getKernel(), "__jtrap", args2, block);
    }

    @JRubyMethod(module=true)
    public static IRubyObject list(ThreadContext context, IRubyObject recv2) {
        Ruby runtime2 = recv2.getRuntime();
        RubyHash names2 = RubyHash.newHash(runtime2);
        for (int i2 = 0; i2 < NAMES.length; ++i2) {
            names2.op_aset(context, runtime2.newString(NAMES[i2]), runtime2.newFixnum(i2));
        }
        names2.op_aset(context, runtime2.newString("IOT"), runtime2.newFixnum(6));
        names2.op_aset(context, runtime2.newString("CLD"), runtime2.newFixnum(20));
        return names2;
    }

    @JRubyMethod(name={"__jtrap_kernel"}, required=2, module=true)
    public static IRubyObject __jtrap_kernel(IRubyObject recv2, IRubyObject block, IRubyObject sig) {
        return SIGNALS.trap(recv2, block, sig);
    }

    private static void registerThreadDumpSignalHandler(final Ruby runtime2) {
        String threadDumpSignal = runtime2.getInstanceConfig().getThreadDumpSignal();
        if (threadDumpSignal != null && threadDumpSignal.length() > 0) {
            SIGNALS.trap(runtime2, new BlockCallback(){

                public IRubyObject call(ThreadContext context, IRubyObject[] args2, Block block) {
                    RubyThread[] thrs;
                    System.err.println("Ruby Thread Dump");
                    ThreadService threadService = runtime2.getThreadService();
                    for (RubyThread th : thrs = threadService.getActiveRubyThreads()) {
                        System.err.println("\n" + th);
                        RubyException exc = new RubyException(runtime2, runtime2.getRuntimeError(), "");
                        ThreadContext tc = threadService.getThreadContextForThread(th);
                        if (tc != null) {
                            exc.setBacktraceData(new BacktraceData(th.javaBacktrace(), tc.createBacktrace2(0, false), false, false, TraceType.Gather.NORMAL));
                            exc.printBacktrace(System.err);
                            continue;
                        }
                        System.err.println("    [no longer alive]");
                    }
                    return runtime2.getNil();
                }
            }, threadDumpSignal);
        }
    }
}

