/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalVarNode
extends Node
implements INameNode {
    private String name;

    public GlobalVarNode(ISourcePosition position, String name2) {
        super(position);
        this.name = name2;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.GLOBALVARNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitGlobalVarNode(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    @Override
    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        return runtime2.getGlobalVariables().get(this.name);
    }

    @Override
    public ByteList definition(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        return runtime2.getGlobalVariables().isDefined(this.name) ? GLOBAL_VARIABLE_BYTELIST : null;
    }
}

