/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.operands;

import java.util.List;
import java.util.Map;
import org.jruby.compiler.ir.operands.Array;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.Range;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.InlinerInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Splat
extends Operand {
    Operand _array;

    public Splat(Operand a) {
        this._array = a;
    }

    @Override
    public boolean isConstant() {
        return this._array.isConstant();
    }

    public String toString() {
        return "*" + this._array;
    }

    @Override
    public boolean isNonAtomicValue() {
        return true;
    }

    @Override
    public Operand getSimplifiedOperand(Map<Operand, Operand> valueMap) {
        this._array = this._array.getSimplifiedOperand(valueMap);
        if (this._array instanceof Variable) {
            this._array = ((Variable)this._array).getValue(valueMap);
        }
        return this;
    }

    @Override
    public Operand fetchCompileTimeArrayElement(int argIndex, boolean getSubArray) {
        if (this._array instanceof Array) {
            return ((Array)this._array).fetchCompileTimeArrayElement(argIndex, getSubArray);
        }
        if (this._array instanceof Range) {
            return ((Range)this._array).fetchCompileTimeArrayElement(argIndex, getSubArray);
        }
        return null;
    }

    @Override
    public void addUsedVariables(List<Variable> l) {
        this._array.addUsedVariables(l);
    }

    @Override
    public Operand cloneForInlining(InlinerInfo ii) {
        return this.isConstant() ? this : new Splat(this._array.cloneForInlining(ii));
    }
}

