/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.Function;
import com.kenai.jffi.HeapInvocationBuffer;
import com.kenai.jffi.InvocationBuffer;
import org.jruby.RubyModule;
import org.jruby.ext.ffi.jffi.CallbackMarshaller;
import org.jruby.ext.ffi.jffi.FunctionInvoker;
import org.jruby.ext.ffi.jffi.Invocation;
import org.jruby.ext.ffi.jffi.ParameterMarshaller;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

final class CallbackMethodWithBlock
extends DynamicMethod {
    private final ParameterMarshaller[] marshallers;
    private final Function function;
    private final FunctionInvoker functionInvoker;
    private final int cbindex;

    public CallbackMethodWithBlock(RubyModule implementationClass, Function function, FunctionInvoker functionInvoker, ParameterMarshaller[] marshallers, int cbindex) {
        super(implementationClass, Visibility.PUBLIC, CallConfiguration.FrameFullScopeFull);
        this.function = function;
        this.functionInvoker = functionInvoker;
        this.marshallers = marshallers;
        this.cbindex = cbindex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        boolean blockGiven = block.isGiven();
        Arity.checkArgumentCount(context.getRuntime(), args2, this.marshallers.length - (blockGiven ? 1 : 0), this.marshallers.length);
        Invocation invocation = new Invocation(context, 0, 0);
        try {
            int i2;
            HeapInvocationBuffer buffer = new HeapInvocationBuffer(this.function);
            if (!blockGiven) {
                for (i2 = 0; i2 < args2.length; ++i2) {
                    this.marshallers[i2].marshal(invocation, (InvocationBuffer)buffer, args2[i2]);
                }
            } else {
                for (i2 = 0; i2 < this.cbindex; ++i2) {
                    this.marshallers[i2].marshal(invocation, (InvocationBuffer)buffer, args2[i2]);
                }
                ((CallbackMarshaller)this.marshallers[this.cbindex]).marshal(invocation, (InvocationBuffer)buffer, block);
                for (i2 = this.cbindex + 1; i2 < this.marshallers.length; ++i2) {
                    this.marshallers[i2].marshal(invocation, (InvocationBuffer)buffer, args2[i2 - 1]);
                }
            }
            IRubyObject iRubyObject = this.functionInvoker.invoke(context, this.function, buffer);
            Object var12_12 = null;
            invocation.finish();
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            invocation.finish();
            throw throwable;
        }
    }

    public DynamicMethod dup() {
        return this;
    }

    public Arity getArity() {
        return Arity.fixed(this.marshallers.length);
    }

    public boolean isNative() {
        return true;
    }
}

