/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2008, 2010 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2008 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Author: Tomas Holy
 */

#ifdef WIN32
#include <windows.h>
#include "nbexecloader.h"

#ifdef JRUBYW
const char *CON_ATTACH_MSG =
    "*WARNING*: The non-console JRubyW launcher is forced to attach to console.\n"
    "This may cause unexpected behavior of CMD console. Use:\n"
    "    start /wait jrubyw.exe -Xconsole attach [args]\n";
#endif  // JRUBYW
#else
#include "unixlauncher.h"
#endif  // WIN32

#include "utilsfuncs.h"

char JRUBY_PATH[] = "/usr/local/jruby/bin/jruby";

int main(int argc, char *argv[], char* envp[]) {
    argv[0] = JRUBY_PATH;
    checkLoggingArg(argc, argv, true);

#ifdef WIN32
#ifdef JRUBYW
    if (!isConsoleAttached()) {
        logMsg("Console is not attached, assume WINDOW mode");
        DWORD parentProcID = 0;
        if (!setupProcess(argc, argv, parentProcID, CON_ATTACH_MSG)) {
            return -1;
        }
    } else {
        logMsg("Console is not attached, assume CONSOLE mode");
    }
#endif  // JRUBYW

    NBExecLoader loader;
    return loader.start("jruby.dll", argc - 1, argv + 1, argv[0]);

#else  // !WIN32
    UnixLauncher launcher;
    return launcher.run(argc, argv, envp);
#endif  // WIN32
}
