/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.db;

import com.sun.star.awt.XWindow;
import com.sun.star.beans.Property;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.ContainerEvent;
import com.sun.star.container.XContainer;
import com.sun.star.container.XContainerListener;
import com.sun.star.container.XHierarchicalNameAccess;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sdbc.SQLException;
import com.sun.star.sdbcx.XAppend;
import com.sun.star.sdbcx.XColumnsSupplier;
import com.sun.star.sdbcx.XDataDescriptorFactory;
import com.sun.star.sdbcx.XDrop;
import com.sun.star.sdbcx.XKeysSupplier;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.Properties;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.db.ColumnPropertySet;
import com.sun.star.wizards.db.CommandMetaData;
import com.sun.star.wizards.db.CommandName;
import java.util.Vector;

public class TableDescriptor
extends CommandMetaData
implements XContainerListener {
    XDataDescriptorFactory xTableDataDescriptorFactory;
    XPropertySet xPropTableDataDescriptor;
    private XNameAccess xNameAccessColumns;
    private XIndexAccess xIndexAccessKeys;
    public XDataDescriptorFactory xColumnDataDescriptorFactory;
    XContainer xTableContainer;
    XAppend xTableAppend;
    XDrop xTableDrop;
    private XAppend xKeyAppend;
    private XDrop xKeyDrop;
    private String[] sTableFilters = null;
    private Vector columncontainer = new Vector();
    private Vector keycolumncontainer = new Vector();
    public XHierarchicalNameAccess xTableHierarchicalNameAccess;
    private CommandName ComposedTableName;
    private XAppend xKeyColAppend;
    private XColumnsSupplier xKeyColumnSupplier;
    private XPropertySet xKey;
    private boolean bIDFieldisInserted = false;
    private String IDFieldName = "";
    private String sColumnAlreadyExistsMessage = "";
    private XWindow xWindow;

    public TableDescriptor(XMultiServiceFactory xMultiServiceFactory, XWindow xWindow, String string) {
        super(xMultiServiceFactory);
        this.sColumnAlreadyExistsMessage = string;
        this.xWindow = xWindow;
    }

    public boolean getConnection(PropertyValue[] propertyValueArray) {
        if (super.getConnection(propertyValueArray)) {
            this.xTableAppend = (XAppend)UnoRuntime.queryInterface(XAppend.class, (Object)this.getTableNamesAsNameAccess());
            this.xTableDrop = (XDrop)UnoRuntime.queryInterface(XDrop.class, (Object)this.getTableNamesAsNameAccess());
            this.xTableDataDescriptorFactory = (XDataDescriptorFactory)UnoRuntime.queryInterface(XDataDescriptorFactory.class, (Object)this.getTableNamesAsNameAccess());
            this.xPropTableDataDescriptor = this.xTableDataDescriptorFactory.createDataDescriptor();
            XColumnsSupplier xColumnsSupplier = (XColumnsSupplier)UnoRuntime.queryInterface(XColumnsSupplier.class, (Object)this.xPropTableDataDescriptor);
            this.xNameAccessColumns = xColumnsSupplier.getColumns();
            this.xColumnDataDescriptorFactory = (XDataDescriptorFactory)UnoRuntime.queryInterface(XDataDescriptorFactory.class, (Object)this.xNameAccessColumns);
            try {
                this.createTypeInspector();
                this.sTableFilters = (String[])AnyConverter.toArray((Object)this.getDataSourcePropertySet().getPropertyValue("TableFilter"));
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
            }
            return true;
        }
        return false;
    }

    private void removePrimaryKeys() {
        if (this.keycolumncontainer.size() > 0) {
            for (int i = this.keycolumncontainer.size() - 1; i >= 0; --i) {
                this.keycolumncontainer.remove(i);
            }
        }
    }

    public boolean createPrimaryKeys(String[] stringArray, boolean bl) {
        try {
            XKeysSupplier xKeysSupplier = (XKeysSupplier)UnoRuntime.queryInterface(XKeysSupplier.class, (Object)this.xPropTableDataDescriptor);
            this.xIndexAccessKeys = xKeysSupplier.getKeys();
            XDataDescriptorFactory xDataDescriptorFactory = (XDataDescriptorFactory)UnoRuntime.queryInterface(XDataDescriptorFactory.class, (Object)this.xIndexAccessKeys);
            this.xKeyDrop = (XDrop)UnoRuntime.queryInterface(XDrop.class, (Object)this.xIndexAccessKeys);
            this.xKeyAppend = (XAppend)UnoRuntime.queryInterface(XAppend.class, (Object)xDataDescriptorFactory);
            this.xKey = xDataDescriptorFactory.createDataDescriptor();
            this.xKey.setPropertyValue("Type", (Object)new Integer(1));
            this.xKeyColumnSupplier = (XColumnsSupplier)UnoRuntime.queryInterface(XColumnsSupplier.class, (Object)this.xKey);
            XDataDescriptorFactory xDataDescriptorFactory2 = (XDataDescriptorFactory)UnoRuntime.queryInterface(XDataDescriptorFactory.class, (Object)this.xKeyColumnSupplier.getColumns());
            this.xKeyColAppend = (XAppend)UnoRuntime.queryInterface(XAppend.class, (Object)xDataDescriptorFactory2);
            this.removePrimaryKeys();
            for (int i = 0; i < stringArray.length; ++i) {
                int n;
                XPropertySet xPropertySet = xDataDescriptorFactory2.createDataDescriptor();
                xPropertySet.setPropertyValue(PropertyNames.PROPERTY_NAME, (Object)stringArray[i]);
                this.keycolumncontainer.add(xPropertySet);
                XPropertySet xPropertySet2 = null;
                xPropertySet2 = this.hasByName(stringArray[i]) ? this.getByName(stringArray[i]) : this.addPrimaryKeyColumn(stringArray[i]);
                xPropertySet2.setPropertyValue("IsNullable", (Object)new Integer(0));
                if (bl && (n = this.oTypeInspector.getAutoIncrementIndex(xPropertySet2)) != this.oTypeInspector.INVALID && xPropertySet2.getPropertySetInfo().hasPropertyByName("IsAutoIncrement")) {
                    xPropertySet2.setPropertyValue("Type", (Object)new Integer(n));
                    xPropertySet2.setPropertyValue("IsAutoIncrement", (Object)new Boolean(bl));
                }
                this.modifyColumn(stringArray[i], xPropertySet2);
            }
            return true;
        }
        catch (UnknownPropertyException unknownPropertyException) {
            unknownPropertyException.printStackTrace(System.out);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace(System.out);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace(System.out);
        }
        catch (WrappedTargetException wrappedTargetException) {
            wrappedTargetException.printStackTrace(System.out);
        }
        return false;
    }

    public boolean isColunnNameDuplicate(XNameAccess xNameAccess, XPropertySet xPropertySet) {
        try {
            String string = AnyConverter.toString((Object)xPropertySet.getPropertyValue(PropertyNames.PROPERTY_NAME));
            if (xNameAccess.hasByName(string)) {
                String string2 = JavaTools.replaceSubString(this.sColumnAlreadyExistsMessage, string, "%FIELDNAME");
                this.showMessageBox("ErrorBox", 0x400000, string2);
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
    }

    public boolean createTable(String string, String string2, String string3, String[] stringArray) {
        boolean bl = true;
        try {
            XPropertySet xPropertySet;
            int n;
            XAppend xAppend = (XAppend)UnoRuntime.queryInterface(XAppend.class, (Object)this.xNameAccessColumns);
            for (n = 0; n < this.columncontainer.size(); ++n) {
                xPropertySet = this.getByIndex(n);
                if (!this.isColunnNameDuplicate(this.xNameAccessColumns, xPropertySet)) {
                    xAppend.appendByDescriptor(xPropertySet);
                    continue;
                }
                bl = false;
            }
            if (bl) {
                this.assignTableProperty(PropertyNames.PROPERTY_NAME, string3);
                this.assignTableProperty("CatalogName", string);
                this.assignTableProperty("SchemaName", string2);
                this.xTableContainer = (XContainer)UnoRuntime.queryInterface(XContainer.class, (Object)this.getTableNamesAsNameAccess());
                this.xTableContainer.addContainerListener((XContainerListener)this);
                if (this.keycolumncontainer.size() > 0) {
                    for (n = 0; n < this.keycolumncontainer.size(); ++n) {
                        xPropertySet = (XPropertySet)this.keycolumncontainer.get(n);
                        if (!this.isColunnNameDuplicate(this.xKeyColumnSupplier.getColumns(), xPropertySet)) {
                            this.xKeyColAppend.appendByDescriptor(xPropertySet);
                            continue;
                        }
                        bl = false;
                    }
                    if (bl) {
                        this.xKeyAppend.appendByDescriptor(this.xKey);
                    }
                }
                if (bl) {
                    this.xTableAppend.appendByDescriptor(this.xPropTableDataDescriptor);
                }
            }
        }
        catch (SQLException sQLException) {
            super.callSQLErrorMessageDialog(sQLException, this.xWindow);
            bl = false;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            bl = false;
        }
        if (!bl) {
            this.removeAllColumnsFromDescriptor(string3);
            this.removePrimaryKeys();
        }
        return bl;
    }

    private boolean removeAllColumnsFromDescriptor(String string) {
        try {
            int n;
            int n2;
            this.xPropTableDataDescriptor.setPropertyValue(PropertyNames.PROPERTY_NAME, (Object)"");
            if (this.xKeyDrop != null && this.xIndexAccessKeys != null && (n2 = this.xIndexAccessKeys.getCount()) > 0) {
                for (n = this.xIndexAccessKeys.getCount() - 1; n >= 0; --n) {
                    this.xKeyDrop.dropByIndex(n);
                }
            }
            XDrop xDrop = (XDrop)UnoRuntime.queryInterface(XDrop.class, (Object)this.xNameAccessColumns);
            for (n = this.xNameAccessColumns.getElementNames().length - 1; n >= 0; --n) {
                xDrop.dropByIndex(n);
            }
            if (this.xTableDrop != null && this.getTableNamesAsNameAccess().hasByName(string)) {
                this.xTableDrop.dropByName(string);
            }
            if (this.bIDFieldisInserted) {
                this.dropColumnbyName(this.IDFieldName);
                this.bIDFieldisInserted = false;
            }
            return false;
        }
        catch (SQLException sQLException) {
            super.callSQLErrorMessageDialog(sQLException, this.xWindow);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        return false;
    }

    public boolean createTable(String string, String string2, String string3, String[] stringArray, boolean bl, String[] stringArray2) {
        if (this.createPrimaryKeys(stringArray, bl)) {
            return this.createTable(string, string2, string3, stringArray2);
        }
        return false;
    }

    private void assignTableProperty(String string, String string2) {
        if (string2 != null && !string2.equals("")) {
            try {
                this.xPropTableDataDescriptor.setPropertyValue(string, (Object)string2);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
            }
        }
    }

    public boolean modifyColumnName(String string, String string2) {
        try {
            return this.modifyColumn(string, PropertyNames.PROPERTY_NAME, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            this.showMessageBox("ErrorBox", 0x400000, exception.getMessage());
            return false;
        }
    }

    public boolean modifyColumn(String string, String string2, Object object) {
        try {
            if (this.columncontainer.size() > 0) {
                for (int i = 0; i < this.columncontainer.size(); ++i) {
                    ColumnDescriptor columnDescriptor = (ColumnDescriptor)this.columncontainer.get(i);
                    if (!columnDescriptor.Name.equals(string)) continue;
                    columnDescriptor.xColPropertySet.setPropertyValue(string2, object);
                    if (string2.equals(PropertyNames.PROPERTY_NAME)) {
                        columnDescriptor.Name = (String)object;
                    }
                    this.columncontainer.remove(i);
                    this.columncontainer.insertElementAt(columnDescriptor, i);
                    return true;
                }
            }
        }
        catch (UnknownPropertyException unknownPropertyException) {
            unknownPropertyException.printStackTrace(System.out);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace(System.out);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace(System.out);
        }
        catch (WrappedTargetException wrappedTargetException) {
            wrappedTargetException.printStackTrace(System.out);
        }
        return false;
    }

    public boolean modifyColumn(String string, XPropertySet xPropertySet) {
        try {
            if (this.columncontainer.size() > 0) {
                for (int i = 0; i < this.columncontainer.size(); ++i) {
                    ColumnDescriptor columnDescriptor = (ColumnDescriptor)this.columncontainer.get(i);
                    if (!columnDescriptor.Name.equals(string)) continue;
                    columnDescriptor.xColPropertySet = xPropertySet;
                    columnDescriptor.Name = (String)xPropertySet.getPropertyValue(PropertyNames.PROPERTY_NAME);
                    this.columncontainer.remove(i);
                    this.columncontainer.insertElementAt(columnDescriptor, i);
                    return true;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        return false;
    }

    public void dropColumnbyName(String string) {
        try {
            if (this.columncontainer.size() > 0) {
                for (int i = 0; i < this.columncontainer.size(); ++i) {
                    ColumnDescriptor columnDescriptor = (ColumnDescriptor)this.columncontainer.get(i);
                    if (columnDescriptor == null || !columnDescriptor.Name.equals(string)) continue;
                    this.columncontainer.remove(i);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public String[] getColumnNames() {
        if (this.columncontainer.size() > 0) {
            try {
                String[] stringArray = new String[this.columncontainer.size()];
                for (int i = 0; i < this.columncontainer.size(); ++i) {
                    ColumnDescriptor columnDescriptor = (ColumnDescriptor)this.columncontainer.get(i);
                    stringArray[i] = columnDescriptor.Name;
                }
                return stringArray;
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace(System.out);
            }
        }
        return new String[0];
    }

    private boolean hasByName(String string) {
        try {
            if (this.columncontainer.size() > 0) {
                for (int i = 0; i < this.columncontainer.size(); ++i) {
                    ColumnDescriptor columnDescriptor = (ColumnDescriptor)this.columncontainer.get(i);
                    if (!columnDescriptor.Name.equals(string)) continue;
                    return true;
                }
            }
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace(System.out);
        }
        return false;
    }

    private ColumnDescriptor getColumnDescriptorByName(String string) {
        try {
            if (this.columncontainer.size() > 0) {
                for (int i = 0; i < this.columncontainer.size(); ++i) {
                    ColumnDescriptor columnDescriptor = (ColumnDescriptor)this.columncontainer.get(i);
                    if (!columnDescriptor.Name.equals(string)) continue;
                    return columnDescriptor;
                }
            }
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace(System.out);
        }
        return null;
    }

    public XPropertySet getByName(String string) {
        ColumnDescriptor columnDescriptor = this.getColumnDescriptorByName(string);
        if (columnDescriptor != null) {
            return columnDescriptor.xColPropertySet;
        }
        return null;
    }

    private XPropertySet getByIndex(int n) {
        try {
            if (this.columncontainer.size() > n) {
                ColumnDescriptor columnDescriptor = (ColumnDescriptor)this.columncontainer.get(n);
                return columnDescriptor.xColPropertySet;
            }
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace(System.out);
        }
        return null;
    }

    public XPropertySet clonePropertySet(String string, XPropertySet xPropertySet) {
        XPropertySet xPropertySet2 = this.xColumnDataDescriptorFactory.createDataDescriptor();
        try {
            if (this.hasByName(string)) {
                XPropertySet xPropertySet3 = this.getByName(string);
                XPropertySet xPropertySet4 = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xPropertySet3);
                Property[] propertyArray = xPropertySet4.getPropertySetInfo().getProperties();
                for (int i = 0; i < propertyArray.length; ++i) {
                    String string2 = propertyArray[i].Name;
                    Object object = xPropertySet.getPropertyValue(string2);
                    xPropertySet2.setPropertyValue(string2, object);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        return xPropertySet2;
    }

    public boolean addColumn(PropertyValue[] propertyValueArray) {
        try {
            String string = (String)Properties.getPropertyValue(propertyValueArray, PropertyNames.PROPERTY_NAME);
            if (!this.hasByName(string)) {
                ColumnPropertySet columnPropertySet = new ColumnPropertySet(this.oTypeInspector, this.xColumnDataDescriptorFactory.createDataDescriptor());
                columnPropertySet.assignPropertyValues(propertyValueArray, true);
                ColumnDescriptor columnDescriptor = new ColumnDescriptor(columnPropertySet.xPropertySet, string);
                this.columncontainer.add(columnDescriptor);
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        return false;
    }

    public boolean moveColumn(int n, int n2) {
        try {
            ColumnDescriptor columnDescriptor = (ColumnDescriptor)this.columncontainer.get(n);
            this.columncontainer.remove(n);
            this.columncontainer.add(n2, columnDescriptor);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
    }

    public boolean addColumn(String string, XPropertySet xPropertySet) {
        try {
            if (!this.hasByName(string)) {
                if (string.equals("")) {
                    return false;
                }
                ColumnPropertySet columnPropertySet = new ColumnPropertySet(this.oTypeInspector, this.xColumnDataDescriptorFactory.createDataDescriptor());
                columnPropertySet.assignNewPropertySet(string, xPropertySet);
                ColumnDescriptor columnDescriptor = new ColumnDescriptor(columnPropertySet.xPropertySet, string);
                this.columncontainer.add(columnDescriptor);
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        return false;
    }

    public XPropertySet addPrimaryKeyColumn(String string) {
        try {
            if (!this.hasByName(string)) {
                try {
                    XPropertySet xPropertySet = this.xColumnDataDescriptorFactory.createDataDescriptor();
                    this.IDFieldName = Desktop.getUniqueName(this.getColumnNames(), string, "");
                    xPropertySet.setPropertyValue(PropertyNames.PROPERTY_NAME, (Object)this.IDFieldName);
                    int n = this.oTypeInspector.convertDataType(4);
                    xPropertySet.setPropertyValue("Type", (Object)new Integer(n));
                    xPropertySet.setPropertyValue("TypeName", (Object)this.oTypeInspector.getDefaultTypeName(n, null));
                    ColumnDescriptor columnDescriptor = new ColumnDescriptor(xPropertySet, this.IDFieldName);
                    this.columncontainer.add(0, columnDescriptor);
                    this.bIDFieldisInserted = true;
                    return xPropertySet;
                }
                catch (RuntimeException runtimeException) {
                    runtimeException.printStackTrace(System.out);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        return null;
    }

    public String[] getNonBinaryFieldNames() {
        Vector<String> vector = new Vector<String>();
        try {
            for (int i = 0; i < this.columncontainer.size(); ++i) {
                ColumnDescriptor columnDescriptor = (ColumnDescriptor)this.columncontainer.get(i);
                XPropertySet xPropertySet = this.getByName(columnDescriptor.Name);
                Property[] propertyArray = xPropertySet.getPropertySetInfo().getProperties();
                try {
                    int n = AnyConverter.toInt((Object)xPropertySet.getPropertyValue("Type"));
                    if (this.isBinaryDataType(n)) continue;
                    vector.addElement(columnDescriptor.Name);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.out);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace(System.out);
        }
        String[] stringArray = new String[vector.size()];
        vector.toArray(stringArray);
        return stringArray;
    }

    public String getComposedTableName(String string, String string2, String string3) {
        this.ComposedTableName = new CommandName(this, string, string2, string3, false);
        return this.ComposedTableName.getComposedName();
    }

    public String getComposedTableName() {
        if (this.ComposedTableName != null) {
            return this.ComposedTableName.getComposedName();
        }
        return null;
    }

    public void elementInserted(ContainerEvent containerEvent) {
        try {
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)containerEvent.Element);
            String string = AnyConverter.toString((Object)xPropertySet.getPropertyValue(PropertyNames.PROPERTY_NAME));
            String string2 = AnyConverter.toString((Object)this.xPropTableDataDescriptor.getPropertyValue("SchemaName"));
            String string3 = AnyConverter.toString((Object)this.xPropTableDataDescriptor.getPropertyValue("CatalogName"));
            this.ComposedTableName = new CommandName(this, string3, string2, string, false);
            this.appendTableNameToFilter(this.ComposedTableName.getComposedName());
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void elementRemoved(ContainerEvent containerEvent) {
    }

    public void elementReplaced(ContainerEvent containerEvent) {
    }

    public void disposing(EventObject eventObject) {
    }

    public boolean appendTableNameToFilter(String string) {
        boolean bl = true;
        for (int i = 0; i < this.sTableFilters.length; ++i) {
            if (this.sTableFilters[i].compareTo("%") > -1) {
                if (this.sTableFilters[i].endsWith("." + string)) {
                    bl = false;
                } else if (this.sTableFilters[i].length() == 1) {
                    bl = false;
                }
            } else if (this.sTableFilters[i].equals(string)) {
                bl = false;
            }
            if (!bl) break;
        }
        if (bl) {
            String[] stringArray = new String[this.sTableFilters.length + 1];
            System.arraycopy(this.sTableFilters, 0, stringArray, 0, this.sTableFilters.length);
            stringArray[this.sTableFilters.length] = string;
            this.sTableFilters = stringArray;
            try {
                this.getDataSourcePropertySet().setPropertyValue("TableFilter", (Object)this.sTableFilters);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
                bl = false;
            }
        }
        return bl;
    }

    private class ColumnDescriptor {
        String Name;
        XPropertySet xColPropertySet;

        public ColumnDescriptor(XPropertySet xPropertySet, String string) {
            this.Name = string;
            this.xColPropertySet = xPropertySet;
        }
    }
}

