/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.datetime;

import java.math.BigDecimal;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;
import org.pentaho.reporting.libraries.formula.util.NumberUtil;

public class MinuteFunction
implements Function {
    private static final BigDecimal MINUTES_PER_DAY = new BigDecimal(1440.0);
    private static final BigDecimal MINUTES = new BigDecimal(60.0);
    private static final BigDecimal HOURS = new BigDecimal(24.0);

    public String getCanonicalName() {
        return "MINUTE";
    }

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        if (parameters.getParameterCount() != 1) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = context.getTypeRegistry();
        Number n = typeRegistry.convertToNumber(parameters.getType(0), parameters.getValue(0));
        if (n == null) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        BigDecimal bd = NumberUtil.getAsBigDecimal(n);
        BigDecimal hours = bd.multiply(HOURS);
        BigDecimal dayAndHoursAsInt = new BigDecimal(NumberUtil.performIntRounding(hours).intValue());
        BigDecimal minutesFraction = hours.subtract(dayAndHoursAsInt);
        BigDecimal minutes = minutesFraction.multiply(MINUTES);
        BigDecimal minutesAsInt = minutes.setScale(0, 4);
        return new TypeValuePair(NumberType.GENERIC_NUMBER, minutesAsInt);
    }
}

