/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.normalizer.generator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.State;
import org.jfree.layouting.StateException;
import org.jfree.layouting.StatefullComponent;
import org.jfree.layouting.layouter.content.ContentToken;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.context.PageContext;
import org.jfree.layouting.normalizer.content.NormalizationException;
import org.jfree.layouting.normalizer.generator.ContentGenerator;
import org.jfree.layouting.renderer.Renderer;

public class PrintContentGenerator
implements ContentGenerator {
    private static final Log logger = LogFactory.getLog(PrintContentGenerator.class);
    private Renderer renderer;

    public PrintContentGenerator(LayoutProcess layoutProcess) {
        this.renderer = layoutProcess.getOutputProcessor().createRenderer(layoutProcess);
    }

    public PrintContentGenerator(Renderer renderer) {
        this.renderer = renderer;
    }

    public void startedDocument(PageContext pageContext) {
        logger.debug((Object)"<document>");
        this.renderer.startedDocument(pageContext);
    }

    public void startedFlow(LayoutContext layoutContext) throws NormalizationException {
        logger.debug((Object)("<flow tag='" + layoutContext.getTagName() + "'>"));
        this.renderer.startedFlow(layoutContext);
    }

    public void startedTable(LayoutContext layoutContext) throws NormalizationException {
        logger.debug((Object)"<table>");
        this.renderer.startedTable(layoutContext);
    }

    public void startedTableColumnGroup(LayoutContext layoutContext) throws NormalizationException {
        logger.debug((Object)"<table-col-group>");
        this.renderer.startedTableColumnGroup(layoutContext);
    }

    public void startedTableColumn(LayoutContext layoutContext) throws NormalizationException {
        logger.debug((Object)"<table-col>");
        this.renderer.startedTableColumn(layoutContext);
    }

    public void startedTableSection(LayoutContext layoutContext) throws NormalizationException {
        logger.debug((Object)"<table-section>");
        this.renderer.startedTableSection(layoutContext);
    }

    public void startedTableRow(LayoutContext layoutContext) throws NormalizationException {
        logger.debug((Object)"<table-row>");
        this.renderer.startedTableRow(layoutContext);
    }

    public void startedTableCell(LayoutContext layoutContext) throws NormalizationException {
        logger.debug((Object)"<table-cell>");
        this.renderer.startedTableCell(layoutContext);
    }

    public void startedBlock(LayoutContext layoutContext) throws NormalizationException {
        String string = layoutContext.getTagName();
        logger.debug((Object)("<block tag='" + string + "'>"));
        this.renderer.startedBlock(layoutContext);
    }

    public void startedRootInline(LayoutContext layoutContext) throws NormalizationException {
        String string = layoutContext.getTagName();
        logger.debug((Object)("<paragraph tag='" + string + "'>"));
        this.renderer.startedRootInline(layoutContext);
    }

    public void startedMarker(LayoutContext layoutContext) throws NormalizationException {
        logger.debug((Object)"<marker>");
        this.renderer.startedMarker(layoutContext);
    }

    public void startedInline(LayoutContext layoutContext) throws NormalizationException {
        String string = layoutContext.getTagName();
        logger.debug((Object)("<inline tag='" + string + "'>"));
        this.renderer.startedInline(layoutContext);
    }

    public void addContent(LayoutContext layoutContext, ContentToken contentToken) throws NormalizationException {
        logger.debug((Object)("<content>" + contentToken + "</content>"));
        this.renderer.addContent(layoutContext, contentToken);
    }

    public void finishedInline() throws NormalizationException {
        logger.debug((Object)"</inline>");
        this.renderer.finishedInline();
    }

    public void finishedMarker() throws NormalizationException {
        logger.debug((Object)"</marker>");
        this.renderer.finishedMarker();
    }

    public void finishedRootInline() throws NormalizationException {
        logger.debug((Object)"</paragraph>");
        this.renderer.finishedRootInline();
    }

    public void finishedBlock() throws NormalizationException {
        logger.debug((Object)"</block>");
        this.renderer.finishedBlock();
    }

    public void finishedTableCell() throws NormalizationException {
        logger.debug((Object)"</table-cell>");
        this.renderer.finishedTableCell();
    }

    public void finishedTableRow() throws NormalizationException {
        logger.debug((Object)"</table-row>");
        this.renderer.finishedTableRow();
    }

    public void finishedTableSection() throws NormalizationException {
        logger.debug((Object)"</table-section>");
        this.renderer.finishedTableSection();
    }

    public void finishedTableColumn() throws NormalizationException {
        logger.debug((Object)"</table-col>");
        this.renderer.finishedTableColumn();
    }

    public void finishedTableColumnGroup() throws NormalizationException {
        logger.debug((Object)"</table-col-group>");
        this.renderer.finishedTableColumnGroup();
    }

    public void finishedTable() throws NormalizationException {
        logger.debug((Object)"</table>");
        this.renderer.finishedTable();
    }

    public void finishedFlow() throws NormalizationException {
        logger.debug((Object)"</flow>");
        this.renderer.finishedFlow();
    }

    public void finishedDocument() throws NormalizationException {
        logger.debug((Object)"</document>");
        this.renderer.finishedDocument();
    }

    public State saveState() throws StateException {
        return new PrintContentGeneratorState(this.renderer.saveState());
    }

    public void handlePageBreak(PageContext pageContext) {
        this.renderer.handlePageBreak(pageContext);
    }

    public void startedPassThrough(LayoutContext layoutContext) throws NormalizationException {
        logger.debug((Object)"<pass-through>");
        this.renderer.startedPassThrough(layoutContext);
    }

    public void addPassThroughContent(LayoutContext layoutContext, ContentToken contentToken) throws NormalizationException {
        logger.debug((Object)("<pass-through-content>" + contentToken + "</pass-through-content>"));
        this.renderer.addPassThroughContent(layoutContext, contentToken);
    }

    public void finishedPassThrough() throws NormalizationException {
        logger.debug((Object)"</pass-through>");
        this.renderer.finishedPassThrough();
    }

    public void startedTableCaption(LayoutContext layoutContext) throws NormalizationException {
        logger.debug((Object)"<table-caption>");
        this.renderer.startedTableCaption(layoutContext);
    }

    public void finishedTableCaption() throws NormalizationException {
        logger.debug((Object)"</table-caption>");
        this.renderer.finishedTableCaption();
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    private static class PrintContentGeneratorState
    implements State {
        private State renderer;

        private PrintContentGeneratorState(State state) {
            this.renderer = state;
        }

        public StatefullComponent restore(LayoutProcess layoutProcess) throws StateException {
            Renderer renderer = (Renderer)this.renderer.restore(layoutProcess);
            return new PrintContentGenerator(renderer);
        }
    }
}

