/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.dxf;

import de.escape.quincunx.dxf.DrawLines;
import de.escape.quincunx.trafo.Matrix4D;
import de.escape.quincunx.trafo.Point3D;
import java.awt.Color;
import java.awt.Graphics;

public class DrawChar {
    Point3D[][] lines;
    float advance;
    int maxLineLen;
    int nrLines;

    public DrawChar(float[][][] charlines, float xadvance) {
        if (charlines != null && charlines.length > 0) {
            this.lines = new Point3D[charlines.length][];
            int l = 0;
            while (l < charlines.length) {
                this.lines[l] = new Point3D[charlines[l].length];
                int p = 0;
                while (p < charlines[l].length) {
                    this.lines[l][p] = new Point3D(charlines[l][p][0], charlines[l][p][1], 0.0f);
                    ++p;
                }
                if (p > this.maxLineLen) {
                    this.maxLineLen = p;
                }
                this.nrLines += p - 1;
                ++l;
            }
        }
        this.advance = xadvance;
    }

    public void draw(Graphics g, Matrix4D mat, Color color) {
        if (this.lines != null) {
            int[] px = new int[this.maxLineLen];
            int[] py = new int[this.maxLineLen];
            int[] pz = new int[this.maxLineLen];
            int l = 0;
            while (l < this.lines.length) {
                mat.transform(this.lines[l], px, py, pz, this.lines[l].length);
                DrawLines.drawPoly(g, this.lines[l].length, px, py, pz, color);
                ++l;
            }
        }
    }

    public int calcBB(Point3D min, Point3D max, Matrix4D mat) {
        int nrPoints = 0;
        if (this.lines != null) {
            int l = 0;
            while (l < this.lines.length) {
                nrPoints += this.lines.length;
                int i = 0;
                while (i < this.lines[l].length) {
                    Point3D p;
                    Point3D point3D = p = mat == null ? this.lines[l][i] : mat.mult(this.lines[l][i]);
                    if (p.x < min.x) {
                        min.x = p.x;
                    }
                    if (p.y < min.y) {
                        min.y = p.y;
                    }
                    if (p.z < min.z) {
                        min.z = p.z;
                    }
                    if (p.x > max.x) {
                        max.x = p.x;
                    }
                    if (p.y > max.y) {
                        max.y = p.y;
                    }
                    if (p.z > max.z) {
                        max.z = p.z;
                    }
                    ++i;
                }
                ++l;
            }
        }
        return nrPoints;
    }
}

