/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.dxf.dialogs;

import de.escape.quincunx.dxf.dialogs.PostScriptOutputInfo;
import de.escape.quincunx.gimmicks.Utility;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class PaperPreviewArea
extends Canvas
implements PropertyChangeListener {
    public static final int DEFAULT_NUMBER_PREVIEW_LINES = 2000;
    public static final int NUMBER_PREVIEW_LINES = Utility.getIntProperty("preview.reducelines", 2000);
    private PostScriptOutputInfo info;

    public PaperPreviewArea(PostScriptOutputInfo info) {
        this.info = info;
        info.addPropertyChangeListener(this);
        this.setBackground(Color.gray);
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    public void paint(Graphics g) {
        block9: {
            if (this.info == null) break block9;
            size = this.getSize();
            paper = this.info.getPaperFormat();
            paperWidth = paper.getWidth().getLength();
            verticalRatio = paperWidth / (double)size.width;
            paperRatio = verticalRatio > (horizontalRatio = (paperHeight = paper.getHeight().getLength()) / (double)size.height) ? verticalRatio : horizontalRatio;
            pDrawWidth = (int)(paperWidth / (paperRatio *= 1.1));
            pDrawHeight = (int)(paperHeight / paperRatio);
            px = (size.width - pDrawWidth) / 2;
            py = (size.height - pDrawHeight) / 2;
            delta = Math.min(px, py) / 2;
            g.setColor(Color.black);
            g.fillRect(px + delta, py + delta, pDrawWidth, pDrawHeight);
            g.setColor(new Color(240, 240, 240));
            g.fillRect(px, py, pDrawWidth, pDrawHeight);
            left = paper.getLeftMargin().getLength();
            right = paper.getRightMargin().getLength();
            top = paper.getTopMargin().getLength();
            bottom = paper.getBottomMargin().getLength();
            bx = px + (int)(left / paperRatio);
            by = py + (int)(top / paperRatio);
            innerWidth = paperWidth - left - right;
            innerHeight = paperHeight - top - bottom;
            bw = (int)(innerWidth / paperRatio);
            bh = (int)(innerHeight / paperRatio);
            rotated = this.info.isRotated();
            usedRatio = rotated != false ? 1.0 / this.info.getAspectRatio() : this.info.getAspectRatio();
            painter = this.info.getTemporaryPainter();
            g.setColor(Color.blue);
            dx = bx;
            dy = by;
            if (!(innerWidth / innerHeight < usedRatio)) ** GOTO lbl42
            dw = bw;
            dh = (int)((double)bw / usedRatio);
            switch (this.info.getVerticalAlignment()) {
                case 0: {
                    dy += (bh - dh) / 2;
                    break;
                }
                case 1: {
                    dy += bh - dh;
                    break;
                }
lbl42:
                // 1 sources

                dw = (int)((double)bh * usedRatio);
                dh = bh;
                switch (this.info.getHorizontalAlignment()) {
                    case 0: {
                        dx += (bw - dw) / 2;
                        break;
                    }
                    case 1: {
                        dx += bw - dw;
                    }
                }
                break;
            }
            g.setColor(Color.white);
            g.fillRect(dx, dy, dw, dh);
            if (painter == null || !painter.paintTemporary(g.create(dx, dy, dw, dh), new Dimension(dw, dh), this.info.isRotated(), true, this.info.isMonochrome(), PaperPreviewArea.NUMBER_PREVIEW_LINES)) {
                g.drawRect(dx, dy, dw, dh);
                g.drawLine(dx, dy, dx + dw, dy + dh);
                g.drawLine(dx + dw, dy, dx, dy + dh);
            }
            g.setColor(Color.green);
            g.drawRect(bx, by, bw, bh);
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(200, 200);
    }

    public void propertyChange(PropertyChangeEvent ev) {
        String propertyName = ev.getPropertyName();
        if (!(propertyName.equals("FILE") || propertyName.equals("COMMAND") || propertyName.equals("FILE/COMMAND"))) {
            this.repaint();
        }
    }

    public void finalize() throws Throwable {
        this.info.removePropertyChangeListener(this);
        super.finalize();
    }
}

