/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.i18n;

import de.escape.quincunx.i18n.I18n;
import de.escape.quincunx.i18n.Localizable;
import de.escape.quincunx.i18n.RMenuItem;
import java.awt.Menu;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.util.Locale;

public class RMenu
extends Menu
implements Localizable {
    protected Locale locale;
    protected String resTag;

    public RMenu(String tag) {
        this.setTag(tag);
    }

    public RMenu(String tag, MenuShortcut sc) {
        this.setTag(tag);
        this.setShortcut(sc);
    }

    public void setTag(String tag) {
        this.resTag = tag;
        this.setLabel(I18n.getString(this.resTag, this.getLocale()));
    }

    public void setLocale(Locale l) {
        this.locale = l;
        this.setLabel(I18n.getString(this.resTag, l));
        int i = this.getItemCount() - 1;
        while (i >= 0) {
            MenuItem m = this.getItem(i);
            if (m instanceof Localizable) {
                ((Localizable)((Object)m)).setLocale(l);
            }
            --i;
        }
    }

    public Locale getLocale() {
        MenuContainer m;
        if (this.locale == null && this.getParent() != null && (m = this.getParent()) instanceof Localizable) {
            return ((Localizable)((Object)m)).getLocale();
        }
        return this.locale;
    }

    public MenuItem add(MenuItem m) {
        Localizable l;
        if (m instanceof Localizable && (l = (Localizable)((Object)m)).getLocale() == null) {
            l.setLocale(this.getLocale());
        }
        return super.add(m);
    }

    public void insert(MenuItem m, int index) {
        Localizable l;
        if (m instanceof Localizable && (l = (Localizable)((Object)m)).getLocale() == null) {
            l.setLocale(this.getLocale());
        }
        super.insert(m, index);
    }

    public void insert(String m, int index) {
        super.insert(new RMenuItem(m, this.getLocale()), index);
    }
}

