/*
 * Decompiled with CFR 0.152.
 */
package processing.app.exec;

import java.util.Arrays;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessResult
implements Iterable<String> {
    private final String cmd;
    private final long time;
    private final String output;
    private final String error;
    private final int result;

    public ProcessResult(String cmd, int result, String output, String error, long time) {
        this.cmd = cmd;
        this.output = output;
        this.error = error;
        this.result = result;
        this.time = time;
    }

    @Override
    public Iterator<String> iterator() {
        return Arrays.asList(this.output.split("\r?\n")).iterator();
    }

    public String getCmd() {
        return this.cmd;
    }

    public int getResult() {
        return this.result;
    }

    public boolean succeeded() {
        return this.result == 0;
    }

    public String getStderr() {
        return this.error;
    }

    public String getStdout() {
        return this.output;
    }

    public long getTime() {
        return this.time;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.cmd).append("\n");
        sb.append("    status: ").append(this.result).append("\n");
        sb.append("    ").append(this.time).append("ms").append("\n");
        sb.append("    stdout:\n").append(this.output.trim()).append("\n");
        sb.append("    stderr:\n").append(this.error.trim());
        return sb.toString();
    }
}

