/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.codegenerator.generatedocstring;

import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.editor.correctionassist.docstrings.DocstringsPrefPage;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.Expr;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Str;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.plugin.StatusInfo;
import org.python.pydev.refactoring.ast.adapters.AbstractScopeNode;
import org.python.pydev.refactoring.core.RefactoringInfo;

public class GenerateDocstringOperation
implements IWorkspaceRunnable {
    private PyEdit edit;

    public GenerateDocstringOperation(PyEdit edit) {
        this.edit = edit;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        RefactoringInfo info;
        try {
            info = new RefactoringInfo((ITextEditor)this.edit, this.edit.getPythonNature());
        }
        catch (Throwable e) {
            StatusInfo status = new StatusInfo(4, e.getMessage());
            throw new CoreException((IStatus)status);
        }
        PySelection selection = new PySelection((ITextEditor)this.edit);
        this.selectDefinition(selection, info);
        boolean successful = this.selectEndOfDocstring(selection, info);
        if (successful) {
            return;
        }
        Tuple tuple = selection.getInsideParentesisToks(false);
        if (tuple == null) {
            return;
        }
        List params = (List)tuple.o1;
        int lineOfLastParam = selection.getLineOfOffset(((Integer)tuple.o2).intValue());
        String inAndIndent = this.getInAndIndent(selection);
        FastStringBuffer buf = new FastStringBuffer();
        String docStringMarker = DocstringsPrefPage.getDocstringMarker();
        buf.append(String.valueOf(inAndIndent) + docStringMarker);
        buf.append(inAndIndent);
        int relativeSelectionOffset = buf.length();
        if (selection.isInFunctionLine()) {
            Iterator iterator = params.iterator();
            while (iterator.hasNext()) {
                String paramName = (String)iterator.next();
                if (!PySelection.isIdentifier((String)paramName)) continue;
                buf.append(inAndIndent).append("@param ").append(paramName).append(":");
                if (!DocstringsPrefPage.getTypeTagShouldBeGenerated((String)paramName)) continue;
                buf.append(inAndIndent).append("@type ").append(paramName).append(":");
            }
        }
        buf.append(inAndIndent).append(docStringMarker);
        try {
            int insertOffset = selection.getEndLineOffset(lineOfLastParam);
            IDocument document = this.edit.getDocument();
            document.replace(insertOffset, 0, buf.toString());
            this.edit.setSelection(insertOffset + relativeSelectionOffset, 0);
        }
        catch (BadLocationException badLocationException) {
            return;
        }
    }

    private void selectDefinition(PySelection selection, RefactoringInfo info) {
        AbstractScopeNode<?> scope = info.getScopeAdapter();
        int firstLineInScope = scope.getNodeFirstLine();
        int definitionLine = firstLineInScope - 1;
        int offset = selection.getLineOffset(definitionLine);
        selection.setSelection(offset, offset);
    }

    private boolean selectEndOfDocstring(PySelection selection, RefactoringInfo info) {
        Str docstring = this.getDocstring(selection, info);
        if (docstring != null) {
            int line = docstring.beginLine - 1;
            int col = docstring.beginColumn;
            int offset = selection.getAbsoluteCursorOffset(line, col);
            Pattern p = Pattern.compile("\n?(\\t| )*\\z");
            Matcher m = p.matcher(docstring.s);
            m.find();
            offset += m.start();
            if (docstring.type == 1 || docstring.type == 2) {
                offset += 2;
            }
            this.edit.setSelection(offset, 0);
            return true;
        }
        return false;
    }

    private Str getDocstring(PySelection selection, RefactoringInfo info) {
        Str docstring = null;
        AbstractScopeNode<?> scope = info.getScopeAdapter();
        Object node = scope.getASTNode();
        if (node instanceof FunctionDef) {
            FunctionDef def = (FunctionDef)node;
            docstring = this.extractDocstring(def.body[0]);
        } else if (node instanceof ClassDef) {
            ClassDef def = (ClassDef)node;
            docstring = this.extractDocstring(def.body[0]);
        }
        return docstring;
    }

    private Str extractDocstring(stmtType statement) {
        if (statement instanceof Expr) {
            Expr expr = (Expr)statement;
            if (expr.value instanceof Str) {
                return (Str)expr.value;
            }
        }
        return null;
    }

    private String getInAndIndent(PySelection selection) {
        String initial = PySelection.getIndentationFromLine((String)selection.getCursorLineContents());
        String delimiter = PyAction.getDelimiter((IDocument)selection.getDoc());
        String indentation = PyAction.getStaticIndentationString((PyEdit)this.edit);
        String inAndIndent = String.valueOf(delimiter) + initial + indentation;
        return inAndIndent;
    }
}

