# -*- encoding: utf-8 -*-

Gem::Specification.new do |s|
  s.name = "sequel_pg"
  s.version = "1.2.0"

  s.required_rubygems_version = Gem::Requirement.new(">= 0") if s.respond_to? :required_rubygems_version=
  s.authors = ["Jeremy Evans"]
  s.date = "2011-11-01"
  s.description = "sequel_pg overwrites the inner loop of the Sequel postgres\nadapter row fetching code with a C version.  The C version\nis significantly faster (2-6x) than the pure ruby version\nthat Sequel uses by default.\n"
  s.email = "code@jeremyevans.net"
  s.extensions = ["ext/sequel_pg/extconf.rb"]
  s.extra_rdoc_files = ["README.rdoc", "CHANGELOG", "MIT-LICENSE"]
  s.files = ["README.rdoc", "CHANGELOG", "MIT-LICENSE", "ext/sequel_pg/extconf.rb"]
  s.homepage = "http://github.com/jeremyevans/sequel_pg"
  s.rdoc_options = ["--quiet", "--line-numbers", "--inline-source", "--title", "sequel_pg: Faster SELECTs when using Sequel with pg", "--main", "README.rdoc"]
  s.require_paths = ["lib"]
  s.required_ruby_version = Gem::Requirement.new(">= 1.8.6")
  s.rubygems_version = "1.8.11"
  s.summary = "Faster SELECTs when using Sequel with pg"

  if s.respond_to? :specification_version then
    s.specification_version = 3

    if Gem::Version.new(Gem::VERSION) >= Gem::Version.new('1.2.0') then
      s.add_runtime_dependency(%q<pg>, [">= 0.8.0"])
      s.add_runtime_dependency(%q<sequel>, [">= 3.29.0"])
    else
      s.add_dependency(%q<pg>, [">= 0.8.0"])
      s.add_dependency(%q<sequel>, [">= 3.29.0"])
    end
  else
    s.add_dependency(%q<pg>, [">= 0.8.0"])
    s.add_dependency(%q<sequel>, [">= 3.29.0"])
  end
end
