/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GtkBorder;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.Theme;

public class ButtonDrawData
extends DrawData {
    public ButtonDrawData() {
        this.state = new int[1];
    }

    void draw(Theme theme, GC gc, Rectangle bounds) {
        int state = this.state[0];
        int drawable = gc.getGCData().drawable;
        if ((this.style & 0x10) != 0) {
            int radioButtonHandle = theme.radioButtonHandle;
            int gtkStyle = OS.gtk_widget_get_style(radioButtonHandle);
            theme.transferClipping(gc, gtkStyle);
            int indicator_size = theme.getWidgetProperty(radioButtonHandle, "indicator-size");
            int indicator_spacing = theme.getWidgetProperty(radioButtonHandle, "indicator-spacing");
            int interior_focus = theme.getWidgetProperty(radioButtonHandle, "interior-focus");
            int focus_line_width = theme.getWidgetProperty(radioButtonHandle, "focus-line-width");
            int focus_padding = theme.getWidgetProperty(radioButtonHandle, "focus-padding");
            int border_width = OS.gtk_container_get_border_width(radioButtonHandle);
            int x = bounds.x + indicator_spacing + border_width;
            int y = bounds.y + (bounds.height - indicator_size) / 2;
            if (interior_focus == 0) {
                x += focus_line_width + focus_padding;
            }
            int shadow_type = (state & 0x100) != 0 ? 3 : ((state & 2) != 0 ? 1 : 2);
            byte[] detail = Converter.wcsToMbcs(null, "radiobutton", true);
            if ((state & 0x40) != 0) {
                int prelight_x = bounds.x + border_width;
                int prelight_y = bounds.y + border_width;
                int prelight_width = bounds.width - 2 * border_width;
                int prelight_height = bounds.height - 2 * border_width;
                OS.gtk_paint_flat_box(gtkStyle, drawable, 2, 4, null, radioButtonHandle, detail, prelight_x, prelight_y, prelight_width, prelight_height);
            }
            int state_type = this.getStateType(0);
            OS.gtk_paint_option(gtkStyle, drawable, state_type, shadow_type, null, radioButtonHandle, detail, x, y, indicator_size, indicator_size);
            if (this.clientArea != null) {
                this.clientArea.x = bounds.x + 2 * indicator_spacing + border_width + indicator_size;
                this.clientArea.y = bounds.y + border_width;
                this.clientArea.width = bounds.width - (2 * indicator_spacing + 2 * border_width + indicator_size);
                this.clientArea.height = bounds.height - 2 * border_width;
            }
            return;
        }
        if ((this.style & 0x20) != 0) {
            int checkButtonHandle = theme.checkButtonHandle;
            int gtkStyle = OS.gtk_widget_get_style(checkButtonHandle);
            theme.transferClipping(gc, gtkStyle);
            int indicator_size = theme.getWidgetProperty(checkButtonHandle, "indicator-size");
            int indicator_spacing = theme.getWidgetProperty(checkButtonHandle, "indicator-spacing");
            int interior_focus = theme.getWidgetProperty(checkButtonHandle, "interior-focus");
            int focus_line_width = theme.getWidgetProperty(checkButtonHandle, "focus-line-width");
            int focus_padding = theme.getWidgetProperty(checkButtonHandle, "focus-padding");
            int border_width = OS.gtk_container_get_border_width(checkButtonHandle);
            int x = bounds.x + indicator_spacing + border_width;
            int y = bounds.y + (bounds.height - indicator_size) / 2;
            if (interior_focus == 0) {
                x += focus_line_width + focus_padding;
            }
            int shadow_type = (state & 0x100) != 0 ? 3 : ((state & 2) != 0 ? 1 : 2);
            byte[] detail = Converter.wcsToMbcs(null, "checkbutton", true);
            if ((state & 0x40) != 0) {
                int prelight_x = bounds.x + border_width;
                int prelight_y = bounds.y + border_width;
                int prelight_width = bounds.width - 2 * border_width;
                int prelight_height = bounds.height - 2 * border_width;
                OS.gtk_paint_flat_box(gtkStyle, drawable, 2, 4, null, checkButtonHandle, detail, prelight_x, prelight_y, prelight_width, prelight_height);
            }
            int state_type = this.getStateType(0);
            OS.gtk_paint_check(gtkStyle, drawable, state_type, shadow_type, null, checkButtonHandle, detail, x, y, indicator_size, indicator_size);
            if (this.clientArea != null) {
                this.clientArea.x = bounds.x + 2 * indicator_spacing + border_width + indicator_size;
                this.clientArea.y = bounds.y + border_width;
                this.clientArea.width = bounds.width - (2 * indicator_spacing + 2 * border_width + indicator_size);
                this.clientArea.height = bounds.height - 2 * border_width;
            }
            return;
        }
        if ((this.style & 8) != 0) {
            int buttonHandle = theme.buttonHandle;
            int gtkStyle = OS.gtk_widget_get_style(buttonHandle);
            theme.transferClipping(gc, gtkStyle);
            int focus_line_width = theme.getWidgetProperty(buttonHandle, "focus-line-width");
            int focus_padding = theme.getWidgetProperty(buttonHandle, "focus-padding");
            int border_width = OS.gtk_container_get_border_width(buttonHandle);
            GtkBorder default_border = new GtkBorder();
            int default_border_ptr = theme.getWidgetProperty(buttonHandle, "default-border");
            if (default_border_ptr != 0) {
                OS.memmove(default_border, default_border_ptr, GdkRectangle.sizeof);
            } else {
                default_border.bottom = 1;
                default_border.top = 1;
                default_border.right = 1;
                default_border.left = 1;
            }
            GtkBorder default_outside_border = new GtkBorder();
            int default_outside_border_ptr = theme.getWidgetProperty(buttonHandle, "default-outside-border");
            if (default_outside_border_ptr != 0) {
                OS.memmove(default_outside_border, default_outside_border_ptr, GdkRectangle.sizeof);
            } else {
                default_outside_border.bottom = 0;
                default_outside_border.top = 0;
                default_outside_border.right = 0;
                default_outside_border.left = 0;
            }
            int x = bounds.x + border_width;
            int y = bounds.y + border_width;
            int width = bounds.width - border_width * 2;
            int height = bounds.height - border_width * 2;
            int relief = OS.gtk_button_get_relief(buttonHandle);
            byte[] detail = Converter.wcsToMbcs(null, (state & 0x80) != 0 ? "buttondefault" : "button", true);
            if ((state & 0x80) != 0 && relief == 0) {
                OS.gtk_paint_box(gtkStyle, drawable, 0, 1, null, buttonHandle, detail, x, y, width, height);
                x += default_border.left;
                y += default_border.top;
                width -= default_border.left + default_border.right;
                height -= default_border.top + default_border.bottom;
            } else if ((state & 0x80) != 0) {
                x += default_outside_border.left;
                y += default_outside_border.top;
                width -= default_outside_border.left + default_outside_border.right;
                height -= default_outside_border.top + default_outside_border.bottom;
            }
            int shadow_type = 2;
            if ((state & 0xA) != 0) {
                shadow_type = 1;
            }
            int state_type = this.getStateType(0);
            if (relief != 2 || (state & 0x48) != 0) {
                OS.gtk_paint_box(gtkStyle, drawable, state_type, shadow_type, null, buttonHandle, detail, x, y, width, height);
            }
            if ((state & 4) != 0) {
                int interior_focus;
                int child_displacement_y = theme.getWidgetProperty(buttonHandle, "child-displacement-y");
                int child_displacement_x = theme.getWidgetProperty(buttonHandle, "child-displacement-x");
                int displace_focus = 0;
                if (OS.GTK_VERSION >= OS.VERSION(2, 6, 0)) {
                    displace_focus = theme.getWidgetProperty(buttonHandle, "displace-focus");
                }
                if ((interior_focus = theme.getWidgetProperty(buttonHandle, "interior-focus")) != 0) {
                    int xthickness = OS.gtk_style_get_xthickness(gtkStyle);
                    int ythickness = OS.gtk_style_get_ythickness(gtkStyle);
                    x += xthickness + focus_padding;
                    y += ythickness + focus_padding;
                    width -= 2 * (xthickness + focus_padding);
                    height -= 2 * (ythickness + focus_padding);
                } else {
                    x -= focus_line_width + focus_padding;
                    y -= focus_line_width + focus_padding;
                    width += 2 * (focus_line_width + focus_padding);
                    height += 2 * (focus_line_width + focus_padding);
                }
                if ((state & 8) != 0 && displace_focus != 0) {
                    x += child_displacement_x;
                    y += child_displacement_y;
                }
                OS.gtk_paint_focus(gtkStyle, drawable, state_type, null, buttonHandle, detail, x, y, width, height);
            }
            if (this.clientArea != null) {
                this.clientArea.x = bounds.x + border_width;
                this.clientArea.y = bounds.y + border_width;
                this.clientArea.width = bounds.width - 2 * border_width;
                this.clientArea.height = bounds.height - 2 * border_width;
            }
            return;
        }
    }

    int hit(Theme theme, Point position, Rectangle bounds) {
        return bounds.contains(position) ? 0 : -1;
    }
}

