/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.autoupdate.UpdateUnitProviderFactory;
import org.netbeans.modules.autoupdate.ui.Containers;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalDownloadSupport {
    private static final FileFilter NBM_FILE_FILTER = new NbmFileFilter();
    private static String LOCAL_DOWNLOAD_DIRECTORY_KEY = "local-download-directory";
    private static String LOCAL_DOWNLOAD_FILES = "local-download-files";
    private static String LOCAL_DOWNLOAD_CHECKED_FILES = "local-download-checked-files";
    private FileList fileList = new FileList();
    private Logger err = Logger.getLogger(LocalDownloadSupport.class.getName());
    private Map<File, String> nbm2unitCodeName = null;
    private Map<String, UpdateUnit> codeName2unit = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean chooseNbmFiles() {
        Window window;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.addChoosableFileFilter(NBM_FILE_FILTER);
        jFileChooser.setFileFilter(NBM_FILE_FILTER);
        jFileChooser.setMultiSelectionEnabled(true);
        jFileChooser.setFileHidingEnabled(false);
        jFileChooser.setDialogTitle(LocalDownloadSupport.getBundle("CTL_FileChooser_Title", new String[0]));
        File file = LocalDownloadSupport.getDefaultDir();
        if (file != null && file.exists()) {
            jFileChooser.setCurrentDirectory(file);
        }
        if (jFileChooser.showOpenDialog(window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow()) == 0) {
            Class<LocalDownloadSupport> clazz = LocalDownloadSupport.class;
            synchronized (LocalDownloadSupport.class) {
                LocalDownloadSupport.getPreferences().put(LOCAL_DOWNLOAD_DIRECTORY_KEY, jFileChooser.getCurrentDirectory().getAbsolutePath());
                this.fileList.addFiles(jFileChooser.getSelectedFiles());
                this.addUpdateUnits(jFileChooser.getSelectedFiles());
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<UpdateUnit> getUpdateUnits() {
        LinkedList<UpdateUnit> linkedList = null;
        Class<LocalDownloadSupport> clazz = LocalDownloadSupport.class;
        synchronized (LocalDownloadSupport.class) {
            linkedList = new LinkedList<UpdateUnit>(this.getCodeName2Unit().values());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return linkedList;
        }
    }

    public void checkUnit(UpdateUnit updateUnit) {
        this.fileList.makePersistentCheckedFile(this.getNbm(updateUnit.getCodeName()));
    }

    public void uncheckUnit(UpdateUnit updateUnit) {
        this.fileList.makePersistentUncheckedFile(this.getNbm(updateUnit.getCodeName()));
    }

    public boolean isChecked(UpdateUnit updateUnit) {
        return this.fileList.isChecked(this.getNbm(updateUnit.getCodeName()));
    }

    private Collection<File> getAllFiles() {
        return this.fileList.getAllFiles();
    }

    private void addUpdateUnits(File ... fileArray) {
        HashSet<UpdateUnit> hashSet = new HashSet<UpdateUnit>();
        for (File file : fileArray) {
            Object object;
            UpdateUnit updateUnit = this.createUpdateUnitFromNBM(file, false);
            if (updateUnit != null) {
                if (updateUnit.getAvailableUpdates() == null || updateUnit.getAvailableUpdates().isEmpty()) {
                    hashSet.add(updateUnit);
                } else if (this.getCodeName2Unit().containsKey(updateUnit.getCodeName())) {
                    object = (UpdateElement)updateUnit.getAvailableUpdates().get(0);
                    UpdateElement updateElement = (UpdateElement)this.getCodeName2Unit().get(updateUnit.getCodeName()).getAvailableUpdates().get(0);
                    UpdateUnit updateUnit2 = null;
                    File file2 = null;
                    UpdateUnit updateUnit3 = null;
                    File file3 = null;
                    String string = LocalDownloadSupport.getBundle("NotificationPlugin", object.getDisplayName(), object.getSpecificationVersion());
                    String string2 = LocalDownloadSupport.getBundle("NotificationPlugin", updateElement.getDisplayName(), updateElement.getSpecificationVersion());
                    Object object2 = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)LocalDownloadSupport.getBundle("NotificationAlreadyPresent", string2, string), LocalDownloadSupport.getBundle("NotificationAlreadyPresentTitle", new String[0])));
                    if (NotifyDescriptor.YES_OPTION.equals(object2)) {
                        updateUnit2 = object.getUpdateUnit();
                        file2 = file;
                        updateUnit3 = updateElement.getUpdateUnit();
                        file3 = this.getNbm(updateUnit2.getCodeName());
                    } else {
                        if (!NotifyDescriptor.NO_OPTION.equals(object2)) break;
                        updateUnit2 = updateElement.getUpdateUnit();
                        file2 = this.getNbm(updateUnit2.getCodeName());
                        updateUnit3 = object.getUpdateUnit();
                        file3 = file;
                    }
                    this.getNbm2CodeName().remove(file3);
                    this.getCodeName2Unit().remove(updateUnit3.getCodeName());
                    this.getNbm2CodeName().put(file2, updateUnit2.getCodeName());
                    this.getCodeName2Unit().put(updateUnit2.getCodeName(), updateUnit2);
                    this.fileList.removeFile(file3);
                    Containers.forUpdateNbms().removeAll();
                    Containers.forAvailableNbms().removeAll();
                } else {
                    this.getNbm2CodeName().put(file, updateUnit.getCodeName());
                    this.getCodeName2Unit().put(updateUnit.getCodeName(), updateUnit);
                }
            } else {
                this.fileList.removeFile(file);
            }
            if (hashSet.isEmpty()) continue;
            object = null;
            object = hashSet.size() == 1 ? LocalDownloadSupport.getBundle("NotificationOneAlreadyInstalled", this.getDisplayNames(hashSet)) : LocalDownloadSupport.getBundle("NotificationMoreAlreadyInstalled", this.getDisplayNames(hashSet));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message(object, 1));
        }
    }

    private synchronized void initCodeName2Unit() {
        assert (this.nbm2unitCodeName == null) : "Cannot initialize nbm2unit twice!";
        this.nbm2unitCodeName = new HashMap<File, String>();
        this.codeName2unit = new HashMap<String, UpdateUnit>();
        Iterator<File> iterator = this.getAllFiles().iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            UpdateUnit updateUnit = this.createUpdateUnitFromNBM(file, true);
            if (updateUnit != null && !updateUnit.getAvailableUpdates().isEmpty()) {
                this.nbm2unitCodeName.put(file, updateUnit.getCodeName());
                this.codeName2unit.put(updateUnit.getCodeName(), updateUnit);
                continue;
            }
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<File, String> getNbm2CodeName() {
        Class<LocalDownloadSupport> clazz = LocalDownloadSupport.class;
        synchronized (LocalDownloadSupport.class) {
            if (this.nbm2unitCodeName == null) {
                this.initCodeName2Unit();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.nbm2unitCodeName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, UpdateUnit> getCodeName2Unit() {
        Class<LocalDownloadSupport> clazz = LocalDownloadSupport.class;
        synchronized (LocalDownloadSupport.class) {
            if (this.codeName2unit == null) {
                this.initCodeName2Unit();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.codeName2unit;
        }
    }

    private String getUnitCodeName(File file) {
        assert (file != null) : "Invalid file " + file;
        if (file != null) {
            return this.getNbm2CodeName().get(file);
        }
        return null;
    }

    private File getNbm(String string) {
        assert (string != null) : "Invalid code name " + string;
        if (string != null) {
            for (File file : this.getNbm2CodeName().keySet()) {
                if (!string.equals(this.getUnitCodeName(file))) continue;
                return file;
            }
        }
        return null;
    }

    private UpdateUnit createUpdateUnitFromNBM(File file, boolean bl) {
        List list;
        block4: {
            UpdateUnitProviderFactory updateUnitProviderFactory = UpdateUnitProviderFactory.getDefault();
            UpdateUnitProvider updateUnitProvider = updateUnitProviderFactory.create(file.getName(), new File[]{file});
            list = Collections.emptyList();
            try {
                list = updateUnitProvider.getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE});
            }
            catch (RuntimeException runtimeException) {
                if (bl) break block4;
                this.err.log(Level.INFO, runtimeException.getMessage(), runtimeException);
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Exception((Throwable)runtimeException, (Object)LocalDownloadSupport.getBundle("LocalDownloadSupport_BrokenNBM_Exception", file.getName(), runtimeException.getLocalizedMessage())));
                this.fileList.removeFile(file);
            }
        }
        if (list == null || list.size() == 0) {
            return null;
        }
        assert (list.size() == 1) : "Only once UpdateUnit for " + file + " but " + list;
        return (UpdateUnit)list.get(0);
    }

    public void removeInstalledUnit() {
        Iterator<UpdateUnit> iterator = this.getCodeName2Unit().values().iterator();
        while (iterator.hasNext()) {
            UpdateUnit updateUnit = iterator.next();
            if (updateUnit.getInstalled() == null || !updateUnit.getAvailableUpdates().isEmpty()) continue;
            iterator.remove();
            this.getNbm2CodeName().remove(this.getNbm(updateUnit.getCodeName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean remove(UpdateUnit updateUnit) {
        File file = this.getNbm(updateUnit.getCodeName());
        if (file != null) {
            this.fileList.removeFile(file);
            Class<LocalDownloadSupport> clazz = LocalDownloadSupport.class;
            // MONITORENTER : org.netbeans.modules.autoupdate.ui.LocalDownloadSupport.class
            File file2 = this.getNbm(updateUnit.getCodeName());
            this.getCodeName2Unit().remove(updateUnit.getCodeName());
            this.getNbm2CodeName().remove(file2);
            // MONITOREXIT : clazz
        }
        if (file == null) return false;
        return true;
    }

    private static File getDefaultDir() {
        File file = new File(LocalDownloadSupport.getPreferences().get(LOCAL_DOWNLOAD_DIRECTORY_KEY, System.getProperty("netbeans.user")));
        return file.exists() ? file : new File(System.getProperty("netbeans.user"));
    }

    public static String getBundle(String string, String ... stringArray) {
        return NbBundle.getMessage(LocalDownloadSupport.class, (String)string, (Object[])stringArray);
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(LocalDownloadSupport.class);
    }

    private String getDisplayNames(Collection<UpdateUnit> collection) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (UpdateUnit object : collection) {
            if (object.getInstalled() != null) {
                treeSet.add(object.getInstalled().getDisplayName());
                continue;
            }
            treeSet.add(((UpdateElement)object.getAvailableUpdates().get(0)).getDisplayName());
        }
        Object object = "";
        for (String string : treeSet) {
            object = (String)object + (((String)object).length() == 0 ? string : ", " + string);
        }
        return object;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileList {
        private Set<File> allFiles = null;
        private Set<File> checkedFiles = null;

        private FileList() {
        }

        Set<File> getAllFiles() {
            if (this.allFiles == null) {
                this.allFiles = new LinkedHashSet<File>();
                this.addFiles(this.loadPresistentState());
            }
            return this.allFiles;
        }

        Set<File> getCheckedFiles() {
            if (this.checkedFiles == null) {
                this.checkedFiles = new HashSet<File>();
                for (File file : this.getAllFiles()) {
                    if (!this.isChecked(file)) continue;
                    this.checkedFiles.add(file);
                }
            }
            return this.checkedFiles;
        }

        void addFiles(File[] fileArray) {
            this.addFiles(Arrays.asList(fileArray));
        }

        void addFiles(Collection<File> collection) {
            this.getAllFiles().addAll(collection);
            HashSet<String> hashSet = new HashSet<String>();
            for (File file : collection) {
                hashSet.add(file.getAbsolutePath());
            }
            this.allFiles = FileList.stripNoNBMs(FileList.stripNotExistingFiles(this.getAllFiles()));
            FileList.makePersistent(this.allFiles);
            this.makePersistentCheckedNames(hashSet);
        }

        void removeFile(File file) {
            this.removeFiles(Collections.singleton(file));
        }

        void removeFiles(Collection<File> collection) {
            this.getAllFiles().removeAll(collection);
            this.allFiles = FileList.stripNoNBMs(FileList.stripNotExistingFiles(this.getAllFiles()));
            FileList.makePersistent(this.allFiles);
            for (File file : collection) {
                this.makePersistentUncheckedFile(file);
            }
        }

        private Set<File> loadPresistentState() {
            HashSet<File> hashSet = new HashSet<File>();
            String string = LocalDownloadSupport.getPreferences().get(LOCAL_DOWNLOAD_FILES, null);
            if (string != null) {
                String[] stringArray;
                for (String string2 : stringArray = string.split(",")) {
                    hashSet.add(new File(string2));
                }
            }
            return hashSet;
        }

        private boolean isChecked(File file) {
            return this.getCheckedPaths().contains(file.getAbsolutePath());
        }

        private Collection<String> getCheckedPaths() {
            HashSet<String> hashSet = new HashSet<String>();
            String string = LocalDownloadSupport.getPreferences().get(LOCAL_DOWNLOAD_CHECKED_FILES, null);
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    hashSet.add(stringTokenizer.nextToken().trim());
                }
            }
            return hashSet;
        }

        private void makePersistentUncheckedFile(File file) {
            if (this.isChecked(file)) {
                Collection<String> collection = this.getCheckedPaths();
                collection.remove(file.getAbsolutePath());
                this.makePersistentCheckedNames(collection);
            }
        }

        private void makePersistentCheckedFile(File file) {
            if (!this.isChecked(file)) {
                Collection<String> collection = this.getCheckedPaths();
                collection.add(file.getAbsolutePath());
                this.makePersistentCheckedNames(collection);
            }
        }

        private void makePersistentCheckedNames(Collection<String> collection) {
            StringBuilder stringBuilder = null;
            if (!collection.isEmpty()) {
                for (String string : collection) {
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder(string);
                        continue;
                    }
                    stringBuilder.append(", ").append(string);
                }
            }
            if (stringBuilder == null) {
                LocalDownloadSupport.getPreferences().remove(LOCAL_DOWNLOAD_CHECKED_FILES);
            } else {
                LocalDownloadSupport.getPreferences().put(LOCAL_DOWNLOAD_CHECKED_FILES, stringBuilder.toString());
            }
        }

        private static void makePersistent(Set<File> set) {
            StringBuilder stringBuilder = null;
            if (!set.isEmpty()) {
                for (File file : set) {
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder(file.getAbsolutePath());
                        continue;
                    }
                    stringBuilder.append(',').append(file.getAbsolutePath());
                }
            }
            if (stringBuilder == null) {
                LocalDownloadSupport.getPreferences().remove(LOCAL_DOWNLOAD_FILES);
            } else {
                LocalDownloadSupport.getPreferences().put(LOCAL_DOWNLOAD_FILES, stringBuilder.toString());
            }
        }

        private static Set<File> stripNotExistingFiles(Set<File> set) {
            HashSet<File> hashSet = new HashSet<File>();
            for (File file : set) {
                if (!file.exists()) continue;
                hashSet.add(file);
            }
            return hashSet;
        }

        private static Set<File> stripNoNBMs(Set<File> set) {
            HashSet<File> hashSet = new HashSet<File>();
            for (File file : set) {
                if (!NBM_FILE_FILTER.accept(file)) continue;
                hashSet.add(file);
            }
            return hashSet;
        }
    }

    private static class NbmFileFilter
    extends FileFilter {
        private NbmFileFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(".nbm");
        }

        public String getDescription() {
            return LocalDownloadSupport.getBundle("CTL_FileFilterDescription", new String[0]);
        }
    }
}

