/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.balancer.rules;

import javax.servlet.http.HttpServletRequest;
import org.apache.webapp.balancer.rules.BaseRule;

public class RequestParameterRule
extends BaseRule {
    private String paramName;
    private String paramValue;

    public void setParamName(String theParamName) {
        if (theParamName == null) {
            throw new IllegalArgumentException("paramName cannot be null.");
        }
        this.paramName = theParamName;
    }

    protected String getParamName() {
        return this.paramName;
    }

    public void setParamValue(String theParamValue) {
        this.paramValue = theParamValue;
    }

    protected String getParamValue() {
        return this.paramValue;
    }

    public boolean matches(HttpServletRequest request) {
        String actualParamValue = request.getParameter(this.getParamName());
        if (actualParamValue == null) {
            return this.getParamValue() == null;
        }
        return actualParamValue.compareTo(this.getParamValue()) == 0;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        buffer.append(this.getClass().getName());
        buffer.append(": ");
        buffer.append("Target param name: ");
        buffer.append(this.getParamName());
        buffer.append(" / ");
        buffer.append("Target param value: ");
        buffer.append(this.getParamValue());
        buffer.append(" / ");
        buffer.append("Redirect URL: ");
        buffer.append(this.getRedirectUrl());
        buffer.append("]");
        return buffer.toString();
    }
}

