'''OpenGL extension SUN.mesh_array

Overview (from the spec)
	
	
	This extension defines a new mesh primitive.
	The primitive can only be used with vertex arrays and cannot be used in
	immediate mode. The application must arrange the vertices in row major format.
	For example if a quad mesh is 4 vertices wide the, vertices in the first
	row are the first 4 vertices and vertices in the second row are vertices 5
	through 8. 

The official definition of this extension is available here:
	http://oss.sgi.com/projects/ogl-sample/registry/SUN/mesh_array.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
EXTENSION_NAME = 'GL_SUN_mesh_array'
GL_QUAD_MESH_SUN = constant.Constant( 'GL_QUAD_MESH_SUN', 0x8614 )
GL_TRIANGLE_MESH_SUN = constant.Constant( 'GL_TRIANGLE_MESH_SUN', 0x8615 )
glDrawMeshArraysSUN = platform.createExtensionFunction( 
	'glDrawMeshArraysSUN', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLint, constants.GLsizei, constants.GLsizei,),
	doc = 'glDrawMeshArraysSUN( GLenum(mode), GLint(first), GLsizei(count), GLsizei(width) ) -> None',
	argNames = ('mode', 'first', 'count', 'width',),
)


def glInitMeshArraySUN():
	'''Return boolean indicating whether this extension is available'''
	return extensions.hasGLExtension( EXTENSION_NAME )
