# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.
#
# Author: Benjamin Kampmann <benjamin@fluendo.com>

from twisted.trial.unittest import TestCase, SkipTest
import platform

try:
    from elisa.plugins.avahi.avahi_resource_provider import AvahiResourceProvider
except:
    AvahiResourceProvider = None

from elisa.plugins.avahi.models import NetworkOverviewModel, DomainModel

from elisa.plugins.base.tests.resource_providers import GenericSetup, UriRegExpTester

from elisa.core.media_uri import MediaUri

class TestAvahiResourceProvider(GenericSetup, TestCase, UriRegExpTester):

    resource_class = AvahiResourceProvider
    working_uris = ['network://', 'lan://', 'network://local',
            'network://fluendo.lan']
    failing_uris = ['lan:///', 'network:///', 'network://local/',
            'network://local/test/', 'lan://local/']

    def test_get_network_overview(self):
        """
        test that we get the network overview model
        """
        uri = MediaUri('network://')
        model, dfr = self.resource.get(uri, None)
        self.assertTrue(isinstance(model, NetworkOverviewModel))

    def test_get_local_network(self):
        """
        lan:// is the same as network://local - right?
        """

        lan_uri = MediaUri('lan://')
        network_uri = MediaUri('network://local')

        lan_model, dfr = self.resource.get(lan_uri, None)

        network_model, dfr = self.resource.get(network_uri, None)

        self.assertTrue(lan_model is network_model)
        self.assertTrue(isinstance(lan_model, DomainModel))

    def test_get_other_network(self):
        """
        test to get another network
        """
        uri = MediaUri('network://elisa.lan')

        # fake it
        domain = DomainModel()
        domain.name = 'test_elisa._lan'
        self.resource._domains['elisa.lan'] = domain

        model, dfr = self.resource.get(uri, None)
        self.assertTrue(isinstance(model, DomainModel))
        self.assertEquals(model.name, 'test_elisa._lan')

