# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.

import gst
import platform

#FIXME: this stuff means we have to maintain two very different version of the
# slave pipeline code
if platform.system() == 'Windows':
    # Under windows, when using gstreamer in eggs, this file gets imported too
    # early and decodebin2 cannot be detected, but we *know* it's there in our
    # windows build. See https://bugs.launchpad.net/elisa/+bug/387249.
    from elisa.plugins.gstreamer.decodebin2_pipeline import *
else:
    default_registry = gst.registry_get_default()
    if default_registry.find_feature('decodebin2', gst.ElementFactory) is None:
        from elisa.plugins.gstreamer.old_pipeline import *
    else:
        from elisa.plugins.gstreamer.decodebin2_pipeline import *
