# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2007-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.

from twisted.trial.unittest import TestCase

from elisa.plugins.http_client import utils

import base64

class TestUtils(TestCase):

    def test_basic_auth_headers_generation(self):
        username = "phil"
        password = "foo"
        headers = utils.generate_basic_auth_headers(username, password)
        challenge = 'cGhpbDpmb28='
        self.assertEquals(headers,
                          {'Authorization': ['Basic %s' % challenge]})
        self.assertEquals(base64.decodestring(challenge),
                          '%s:%s' % (username, password))
