/* SOGoMailer.h - this file is part of SOGo
 *
 * Copyright (C) 2007 Inverse inc.
 *
 * Author: Wolfgang Sourdeau <wsourdeau@inverse.ca>
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef SOGOMAILER_H
#define SOGOMAILER_H

#import <Foundation/NSObject.h>

@class NSArray;
@class NSException;
@class NSString;

@class SOGoDomainDefaults;

@protocol NGMimePart;

@interface SOGoMailer : NSObject
{
  NSString *mailingMechanism;
  NSString *smtpServer;
}

+ (SOGoMailer *) mailerWithDomainDefaults: (SOGoDomainDefaults *) dd;

- (id) initWithDomainDefaults: (SOGoDomainDefaults *) dd;

- (NSException *) sendMailData: (NSData *) data
		  toRecipients: (NSArray *) recipients
			sender: (NSString *) sender;
- (NSException *) sendMailAtPath: (NSString *) filename
		    toRecipients: (NSArray *) recipients
			  sender: (NSString *) sender;
- (NSException *) sendMimePart: (id <NGMimePart>) part
		  toRecipients: (NSArray *) recipients
			sender: (NSString *) sender;

@end

#endif /* SOGOMAILER_H */
